/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Expr_c;
import polyglot.ast.Id;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.Term;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Local_c
extends Expr_c
implements Local {
    protected Id name;
    protected LocalInstance li;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Local_c(Position pos, Id name) {
        super(pos);
        if (!$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        this.name = name;
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    public Id id() {
        return this.name;
    }

    public Local id(Id name) {
        Local_c n = (Local_c)this.copy();
        n.name = name;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public Local name(String name) {
        return this.id(this.name.id(name));
    }

    public Flags flags() {
        return this.li.flags();
    }

    public VarInstance varInstance() {
        return this.li;
    }

    public LocalInstance localInstance() {
        return this.li;
    }

    public Local localInstance(LocalInstance li) {
        if (li == this.li) {
            return this;
        }
        Local_c n = (Local_c)this.copy();
        n.li = li;
        return n;
    }

    protected Local_c reconstruct(Id name) {
        if (name != this.name) {
            Local_c n = (Local_c)this.copy();
            n.name = name;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild(this.name, v);
        return this.reconstruct(name);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Local_c n = (Local_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        LocalInstance li = ts.localInstance(this.position(), Flags.NONE, ts.unknownType(this.position()), this.name.id());
        return n.localInstance(li);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        LocalInstance li;
        Context c = tc.context();
        if (!c.isLocal((li = c.findLocal(this.name.id())).name()) && !li.flags().isFinal()) {
            throw new SemanticException("Local variable \"" + li.name() + "\" is accessed from an inner class, and must be declared " + "final.", this.position());
        }
        return this.localInstance(li).type(li.type());
    }

    public Term firstChild() {
        return null;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        return succs;
    }

    public String toString() {
        return this.name.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        tr.print(this, this.name, w);
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.li != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.li + ")");
            w.end();
        }
    }

    public boolean constantValueSet() {
        return this.li != null && this.li.constantValueSet();
    }

    public boolean isConstant() {
        return this.li != null && this.li.isConstant();
    }

    public Object constantValue() {
        if (!this.isConstant()) {
            return null;
        }
        return this.li.constantValue();
    }

    public Node copy(NodeFactory nf) {
        return nf.Local(this.position, this.name);
    }

    static {
        $assertionsDisabled = !Local_c.class.desiredAssertionStatus();
    }
}

