/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.Expr;
import polyglot.ast.If;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.NodeList;
import polyglot.ast.Stmt;
import polyglot.ast.Stmt_c;
import polyglot.ast.Term;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.FlowGraph;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class If_c
extends Stmt_c
implements If {
    protected Expr cond;
    protected Stmt consequent;
    protected Stmt alternative;
    static final /* synthetic */ boolean $assertionsDisabled;

    public If_c(Position pos, Expr cond, Stmt consequent, Stmt alternative) {
        super(pos);
        if (!($assertionsDisabled || cond != null && consequent != null)) {
            throw new AssertionError();
        }
        this.cond = cond;
        this.consequent = consequent;
        this.alternative = alternative;
    }

    public Expr cond() {
        return this.cond;
    }

    public If cond(Expr cond) {
        If_c n = (If_c)this.copy();
        n.cond = cond;
        return n;
    }

    public Stmt consequent() {
        return this.consequent;
    }

    public If consequent(Stmt consequent) {
        If_c n = (If_c)this.copy();
        n.consequent = consequent;
        return n;
    }

    public Stmt alternative() {
        return this.alternative;
    }

    public If alternative(Stmt alternative) {
        If_c n = (If_c)this.copy();
        n.alternative = alternative;
        return n;
    }

    protected If_c reconstruct(Expr cond, Stmt consequent, Stmt alternative) {
        if (cond != this.cond || consequent != this.consequent || alternative != this.alternative) {
            If_c n = (If_c)this.copy();
            n.cond = cond;
            n.consequent = consequent;
            n.alternative = alternative;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Node alternative;
        Expr cond = (Expr)this.visitChild(this.cond, v);
        Node consequent = this.visitChild(this.consequent, v);
        if (consequent instanceof NodeList) {
            consequent = ((NodeList)consequent).toBlock();
        }
        if ((alternative = this.visitChild(this.alternative, v)) instanceof NodeList) {
            alternative = ((NodeList)alternative).toBlock();
        }
        return this.reconstruct(cond, (Stmt)consequent, (Stmt)alternative);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        if (!ts.typeEquals(this.cond.type(), ts.Boolean())) {
            throw new SemanticException("Condition of if statement must have boolean type.", this.cond.position());
        }
        return this;
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        TypeSystem ts = av.typeSystem();
        if (child == this.cond) {
            return ts.Boolean();
        }
        return child.type();
    }

    public String toString() {
        return "if (" + this.cond + ") " + this.consequent + (this.alternative != null ? " else " + this.alternative : "");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.write("if (");
        this.printBlock(this.cond, w, tr);
        w.write(")");
        this.printSubStmt(this.consequent, w, tr);
        if (this.alternative != null) {
            if (this.consequent instanceof Block) {
                w.write(" ");
            } else {
                w.allowBreak(0, " ");
            }
            if (this.alternative instanceof Block) {
                w.write("else ");
                this.print(this.alternative, w, tr);
            } else {
                w.begin(4);
                w.write("else");
                this.printSubStmt(this.alternative, w, tr);
                w.end();
            }
        }
    }

    public Term firstChild() {
        return this.cond;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.alternative == null) {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.consequent, 1, FlowGraph.EDGE_KEY_FALSE, this, 0);
            v.visitCFG(this.consequent, this, 0);
        } else {
            v.visitCFG(this.cond, FlowGraph.EDGE_KEY_TRUE, this.consequent, 1, FlowGraph.EDGE_KEY_FALSE, this.alternative, 1);
            v.visitCFG(this.consequent, this, 0);
            v.visitCFG(this.alternative, this, 0);
        }
        return succs;
    }

    public Node copy(NodeFactory nf) {
        return nf.If(this.position, this.cond, this.consequent, this.alternative);
    }

    static {
        $assertionsDisabled = !If_c.class.desiredAssertionStatus();
    }
}

