/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.CodeBlock;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Formal;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.ParsedClassType;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ConstructorDecl_c
extends Term_c
implements ConstructorDecl {
    protected Flags flags;
    protected Id name;
    protected List formals;
    protected List throwTypes;
    protected Block body;
    protected ConstructorInstance ci;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ConstructorDecl_c(Position pos, Flags flags, Id name, List formals, List throwTypes, Block body) {
        super(pos);
        if (!($assertionsDisabled || flags != null && name != null && formals != null && throwTypes != null)) {
            throw new AssertionError();
        }
        this.flags = flags;
        this.name = name;
        this.formals = TypedList.copyAndCheck(formals, Formal.class, true);
        this.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
        this.body = body;
    }

    public boolean isDisambiguated() {
        return this.ci != null && this.ci.isCanonical() && super.isDisambiguated();
    }

    public MemberInstance memberInstance() {
        return this.ci;
    }

    public Flags flags() {
        return this.flags;
    }

    public ConstructorDecl flags(Flags flags) {
        if (flags.equals(this.flags)) {
            return this;
        }
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    public Id id() {
        return this.name;
    }

    public ConstructorDecl id(Id name) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.name = name;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public ConstructorDecl name(String name) {
        return this.id(this.name.id(name));
    }

    public List formals() {
        return Collections.unmodifiableList(this.formals);
    }

    public ConstructorDecl formals(List formals) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.formals = TypedList.copyAndCheck(formals, Formal.class, true);
        return n;
    }

    public List throwTypes() {
        return Collections.unmodifiableList(this.throwTypes);
    }

    public ConstructorDecl throwTypes(List throwTypes) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
        return n;
    }

    public Term codeBody() {
        return this.body;
    }

    public Block body() {
        return this.body;
    }

    public CodeBlock body(Block body) {
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.body = body;
        return n;
    }

    public ConstructorInstance constructorInstance() {
        return this.ci;
    }

    public ProcedureInstance procedureInstance() {
        return this.ci;
    }

    public CodeInstance codeInstance() {
        return this.procedureInstance();
    }

    public ConstructorDecl constructorInstance(ConstructorInstance ci) {
        if (ci == this.ci) {
            return this;
        }
        ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
        n.ci = ci;
        return n;
    }

    protected ConstructorDecl_c reconstruct(Id name, List formals, List throwTypes, Block body) {
        if (name != this.name || !CollectionUtil.equals(formals, this.formals) || !CollectionUtil.equals(throwTypes, this.throwTypes) || body != this.body) {
            ConstructorDecl_c n = (ConstructorDecl_c)this.copy();
            n.name = name;
            n.formals = TypedList.copyAndCheck(formals, Formal.class, true);
            n.throwTypes = TypedList.copyAndCheck(throwTypes, TypeNode.class, true);
            n.body = body;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild(this.name, v);
        List formals = this.visitList(this.formals, v);
        List throwTypes = this.visitList(this.throwTypes, v);
        Block body = (Block)this.visitChild(this.body, v);
        return this.reconstruct(name, formals, throwTypes, body);
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        return tb.pushCode();
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        ParsedClassType ct = tb.currentClass();
        if (ct == null) {
            return this;
        }
        ArrayList<UnknownType> formalTypes = new ArrayList<UnknownType>(this.formals.size());
        for (int i = 0; i < this.formals.size(); ++i) {
            formalTypes.add(ts.unknownType(this.position()));
        }
        ArrayList<UnknownType> throwTypes = new ArrayList<UnknownType>(this.throwTypes().size());
        for (int i = 0; i < this.throwTypes().size(); ++i) {
            throwTypes.add(ts.unknownType(this.position()));
        }
        ConstructorInstance ci = ts.constructorInstance(this.position(), ct, this.flags, formalTypes, throwTypes);
        ct.addConstructor(ci);
        return this.constructorInstance(ci);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.ci.isCanonical()) {
            return this;
        }
        LinkedList<Type> formalTypes = new LinkedList<Type>();
        LinkedList<Type> throwTypes = new LinkedList<Type>();
        Iterator i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            if (!f.isDisambiguated()) {
                return this;
            }
            formalTypes.add(f.declType());
        }
        this.ci.setFormalTypes(formalTypes);
        i = this.throwTypes().iterator();
        while (i.hasNext()) {
            TypeNode tn = (TypeNode)i.next();
            if (!tn.isDisambiguated()) {
                return this;
            }
            throwTypes.add(tn.type());
        }
        this.ci.setThrowTypes(throwTypes);
        return this;
    }

    public Context enterScope(Context c) {
        return c.pushCode(this.ci);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Context c = tc.context();
        TypeSystem ts = tc.typeSystem();
        ClassType ct = c.currentClass();
        if (ct.flags().isInterface()) {
            throw new SemanticException("Cannot declare a constructor inside an interface.", this.position());
        }
        if (ct.isAnonymous()) {
            throw new SemanticException("Cannot declare a constructor inside an anonymous class.", this.position());
        }
        String ctName = ct.name();
        if (!ctName.equals(this.name.id())) {
            throw new SemanticException("Constructor name \"" + this.name + "\" does not match name of containing class \"" + ctName + "\".", this.position());
        }
        try {
            ts.checkConstructorFlags(this.flags());
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        if (this.body == null && !this.flags().isNative()) {
            throw new SemanticException("Missing constructor body.", this.position());
        }
        if (this.body != null && this.flags().isNative()) {
            throw new SemanticException("A native constructor cannot have a body.", this.position());
        }
        Iterator i = this.throwTypes().iterator();
        while (i.hasNext()) {
            TypeNode tn = (TypeNode)i.next();
            Type t = tn.type();
            if (t.isThrowable()) continue;
            throw new SemanticException("Type \"" + t + "\" is not a subclass of \"" + ts.Throwable() + "\".", tn.position());
        }
        return this;
    }

    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push(this.constructorInstance().throwTypes());
    }

    public String toString() {
        return this.flags.translate() + this.name + "(...)";
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        w.write(this.flags().translate());
        tr.print(this, this.name, w);
        w.write("(");
        w.begin(0);
        Iterator i = this.formals.iterator();
        while (i.hasNext()) {
            Formal f = (Formal)i.next();
            this.print(f, w, tr);
            if (!i.hasNext()) continue;
            w.write(",");
            w.allowBreak(0, " ");
        }
        w.end();
        w.write(")");
        if (!this.throwTypes().isEmpty()) {
            w.allowBreak(6);
            w.write("throws ");
            i = this.throwTypes().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(4, " ");
            }
        }
        w.end();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.prettyPrintHeader(w, tr);
        if (this.body != null) {
            this.printSubStmt(this.body, w, tr);
        } else {
            w.write(";");
        }
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        if (this.ci != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.ci + ")");
            w.end();
        }
    }

    public Term firstChild() {
        return ConstructorDecl_c.listChild(this.formals(), this.body() != null ? this.body() : null);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.body() != null) {
            v.visitCFGList(this.formals(), this.body(), 1);
            v.visitCFG(this.body(), this, 0);
        } else {
            v.visitCFGList(this.formals(), this, 0);
        }
        return succs;
    }

    public Node copy(NodeFactory nf) {
        return nf.ConstructorDecl(this.position, this.flags, this.name, this.formals, this.throwTypes, this.body);
    }

    static {
        $assertionsDisabled = !ConstructorDecl_c.class.desiredAssertionStatus();
    }
}

