/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.ast.TypeNode;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.main.Report;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MemberInstance;
import polyglot.types.Named;
import polyglot.types.ParsedClassType;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ClassDecl_c
extends Term_c
implements ClassDecl {
    protected Flags flags;
    protected Id name;
    protected TypeNode superClass;
    protected List interfaces;
    protected ClassBody body;
    protected ConstructorInstance defaultCI;
    protected ParsedClassType type;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassDecl_c(Position pos, Flags flags, Id name, TypeNode superClass, List interfaces, ClassBody body) {
        super(pos);
        if (!($assertionsDisabled || flags != null && name != null && interfaces != null && body != null)) {
            throw new AssertionError();
        }
        this.flags = flags;
        this.name = name;
        this.superClass = superClass;
        this.interfaces = TypedList.copyAndCheck(interfaces, TypeNode.class, true);
        this.body = body;
    }

    public boolean isDisambiguated() {
        return super.isDisambiguated() && this.type != null && this.type.isCanonical() && this.type.supertypesResolved() && this.type.signaturesResolved();
    }

    public MemberInstance memberInstance() {
        return this.type;
    }

    public ParsedClassType type() {
        return this.type;
    }

    public ClassDecl type(ParsedClassType type) {
        if (type == this.type) {
            return this;
        }
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.type = type;
        return n;
    }

    public Flags flags() {
        return this.flags;
    }

    public ClassDecl flags(Flags flags) {
        if (flags.equals(this.flags)) {
            return this;
        }
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.flags = flags;
        return n;
    }

    public Id id() {
        return this.name;
    }

    public ClassDecl id(Id name) {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.name = name;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public ClassDecl name(String name) {
        return this.id(this.name.id(name));
    }

    public TypeNode superClass() {
        return this.superClass;
    }

    public ClassDecl superClass(TypeNode superClass) {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.superClass = superClass;
        return n;
    }

    public List interfaces() {
        return this.interfaces;
    }

    public ClassDecl interfaces(List interfaces) {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.interfaces = TypedList.copyAndCheck(interfaces, TypeNode.class, true);
        return n;
    }

    public ClassBody body() {
        return this.body;
    }

    public ClassDecl body(ClassBody body) {
        ClassDecl_c n = (ClassDecl_c)this.copy();
        n.body = body;
        return n;
    }

    protected ClassDecl_c reconstruct(Id name, TypeNode superClass, List interfaces, ClassBody body) {
        if (name != this.name || superClass != this.superClass || !CollectionUtil.equals(interfaces, this.interfaces) || body != this.body) {
            ClassDecl_c n = (ClassDecl_c)this.copy();
            n.name = name;
            n.superClass = superClass;
            n.interfaces = TypedList.copyAndCheck(interfaces, TypeNode.class, true);
            n.body = body;
            return n;
        }
        return this;
    }

    public Term firstChild() {
        return this.body();
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        v.visitCFG(this.body(), this, 0);
        return succs;
    }

    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild(this.name, v);
        TypeNode superClass = (TypeNode)this.visitChild(this.superClass, v);
        List interfaces = this.visitList(this.interfaces, v);
        ClassBody body = (ClassBody)this.visitChild(this.body, v);
        return this.reconstruct(name, superClass, interfaces, body);
    }

    public NodeVisitor buildTypesEnter(TypeBuilder tb) throws SemanticException {
        ParsedClassType type = (tb = tb.pushClass(this.position(), this.flags, this.name.id())).currentClass();
        if (type.isMember() && type.outer().flags().isInterface()) {
            type.flags(type.flags().Public().Static());
        }
        if (type.isMember() && type.flags().isInterface()) {
            type.flags(type.flags().Static());
        }
        if (type.flags().isInterface()) {
            type.flags(type.flags().Abstract());
        }
        return tb;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        ParsedClassType type = tb.currentClass();
        if (type == null) {
            return this;
        }
        ConstructorInstance ci = null;
        type.setMembersAdded(true);
        if (type.defaultConstructorNeeded()) {
            ci = tb.typeSystem().defaultConstructor(this.position(), type);
            type.addConstructor(ci);
        }
        ClassDecl_c n = this;
        if (n.defaultCI != ci) {
            n = (ClassDecl_c)this.copy();
            n.defaultCI = ci;
        }
        return n.type(type).flags(type.flags());
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.body) {
            TypeSystem ts = c.typeSystem();
            c = c.pushClass(this.type, ts.staticTarget(this.type).toClass());
        } else {
            c = c.pushBlock();
            c.addNamed(this.type);
        }
        return super.enterChildScope(child, c);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (this.type == null) {
            throw new InternalCompilerError("Missing type.", this.position());
        }
        ClassDecl_c n = this.disambiguateSupertypes(ar);
        this.checkSupertypeCycles(ar.typeSystem());
        ParsedClassType type = n.type();
        if (!type.signaturesResolved()) {
            Scheduler scheduler = ar.job().extensionInfo().scheduler();
            Goal g = scheduler.SignaturesResolved(type);
            throw new MissingDependencyException(g);
        }
        Context ctxt = ar.context();
        type.inStaticContext(ctxt.inStaticContext());
        return this.addDefaultConstructorIfNeeded(ar.typeSystem(), ar.nodeFactory());
    }

    protected ClassDecl_c disambiguateSupertypes(AmbiguityRemover ar) throws SemanticException {
        boolean supertypesResolved = true;
        if (!this.type.supertypesResolved()) {
            if (this.superClass != null && !this.superClass.isDisambiguated()) {
                supertypesResolved = false;
            }
            Iterator i = this.interfaces.iterator();
            while (supertypesResolved && i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                if (tn.isDisambiguated()) continue;
                supertypesResolved = false;
            }
            if (!supertypesResolved) {
                Scheduler scheduler = ar.job().extensionInfo().scheduler();
                Goal g = scheduler.SupertypesResolved(this.type);
                throw new MissingDependencyException(g);
            }
            this.setSuperClass(ar, this.superClass);
            this.setInterfaces(ar, this.interfaces);
            this.type.setSupertypesResolved(true);
        }
        return this;
    }

    protected void checkSupertypeCycles(TypeSystem ts) throws SemanticException {
        if (this.type.superType() != null) {
            if (!this.type.superType().isReference()) {
                throw new SemanticException("Cannot extend type " + this.type.superType() + ".", this.superClass != null ? this.superClass.position() : this.position());
            }
            ReferenceType t = (ReferenceType)this.type.superType();
            ts.checkCycles(t);
        }
        Iterator i = this.type.interfaces().iterator();
        while (i.hasNext()) {
            Type it = (Type)i.next();
            if (!it.isReference()) {
                String s = this.type.flags().isInterface() ? "extend" : "implement";
                throw new SemanticException("Cannot " + s + " type " + it + ".", this.position());
            }
            ReferenceType t = (ReferenceType)it;
            ts.checkCycles(t);
        }
    }

    protected void setSuperClass(AmbiguityRemover ar, TypeNode superClass) throws SemanticException {
        TypeSystem ts = ar.typeSystem();
        if (superClass != null) {
            Type t = superClass.type();
            if (Report.should_report("types", 3)) {
                Report.report(3, "setting superclass of " + this.type + " to " + t);
            }
            this.type.superType(t);
        } else if (this.type.equals(ts.Object()) || this.type.fullName().equals(ts.Object().fullName())) {
            if (Report.should_report("types", 3)) {
                Report.report(3, "setting superclass of " + this.type + " to " + null);
            }
            this.type.superType(null);
        } else {
            if (Report.should_report("types", 3)) {
                Report.report(3, "setting superclass of " + this.type + " to " + ts.Object());
            }
            this.type.superType(ts.Object());
        }
    }

    protected void setInterfaces(AmbiguityRemover ar, List newInterfaces) throws SemanticException {
        Iterator i = newInterfaces.iterator();
        while (i.hasNext()) {
            TypeNode tn = (TypeNode)i.next();
            Type t = tn.type();
            if (Report.should_report("types", 3)) {
                Report.report(3, "adding interface of " + this.type + " to " + t);
            }
            this.type.addInterface(t);
        }
    }

    protected Node addDefaultConstructorIfNeeded(TypeSystem ts, NodeFactory nf) throws SemanticException {
        if (this.defaultConstructorNeeded()) {
            return this.addDefaultConstructor(ts, nf);
        }
        return this;
    }

    protected boolean defaultConstructorNeeded() {
        if (this.defaultCI == null) {
            return false;
        }
        Iterator i = this.body().members().iterator();
        while (i.hasNext()) {
            ConstructorDecl cd;
            ClassMember cm = (ClassMember)i.next();
            if (!(cm instanceof ConstructorDecl) || (cd = (ConstructorDecl)cm).constructorInstance() != this.defaultCI) continue;
            return false;
        }
        return true;
    }

    protected Node addDefaultConstructor(TypeSystem ts, NodeFactory nf) throws SemanticException {
        ConstructorInstance ci = this.defaultCI;
        if (ci == null) {
            throw new InternalCompilerError("addDefaultConstructor called without defaultCI set");
        }
        Block block = null;
        if (this.type.superType() instanceof ClassType) {
            ConstructorInstance sci = ts.findConstructor((ClassType)this.type.superType(), Collections.EMPTY_LIST, this.type);
            ConstructorCall cc = nf.SuperCall(this.position().startOf(), Collections.EMPTY_LIST);
            cc = cc.constructorInstance(sci);
            block = nf.Block(this.position().startOf(), cc);
        } else {
            block = nf.Block(this.position().startOf());
        }
        ConstructorDecl cd = nf.ConstructorDecl(this.body().position().startOf(), Flags.PUBLIC, this.name, Collections.EMPTY_LIST, Collections.EMPTY_LIST, block);
        cd = cd.constructorInstance(ci);
        return this.body(this.body.addMember(cd));
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        if (this.type().isNested() && this.type() instanceof Named) {
            Type another;
            Named nm;
            Context ctxt;
            ClassType container = this.type.outer();
            while (container instanceof Named) {
                String name;
                if (!container.isAnonymous() && (name = container.name()).equals(this.name.id())) {
                    throw new SemanticException("Cannot declare member class \"" + this.type + "\" inside class with the " + "same name.", this.position());
                }
                if (!container.isNested()) break;
                container = container.outer();
            }
            if (this.type().isLocal() && (ctxt = tc.context()).isLocal(this.name.id()) && (nm = ctxt.find(this.name.id())) instanceof Type && (another = (Type)((Object)nm)).isClass() && another.toClass().isLocal()) {
                throw new SemanticException("Cannot declare local class \"" + this.type + "\" within the same " + "method, constructor or initializer as another " + "local class of the same name.", this.position());
            }
        }
        if (this.type().isMember() && this.flags().isInterface() && this.type().outer().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare member interfaces.", this.position());
        }
        if (this.type().isMember() && this.type().flags().isStatic() && this.type().outer().isInnerClass()) {
            throw new SemanticException("Inner classes cannot declare static member classes.", this.position());
        }
        if (this.type.superType() != null) {
            if (!this.type.superType().isClass() || this.type.superType().toClass().flags().isInterface()) {
                throw new SemanticException("Cannot extend non-class \"" + this.type.superType() + "\".", this.position());
            }
            if (this.type.superType().toClass().flags().isFinal()) {
                throw new SemanticException("Cannot extend final class \"" + this.type.superType() + "\".", this.position());
            }
            if (this.type.equals(tc.typeSystem().Object()) || this.type.fullName().equals(tc.typeSystem().Object().fullName())) {
                throw new SemanticException("Class \"" + this.type + "\" cannot have a superclass.", this.superClass.position());
            }
        }
        Iterator i = this.interfaces.iterator();
        while (i.hasNext()) {
            TypeNode tn = (TypeNode)i.next();
            Type t = tn.type();
            if (!t.isClass() || !t.toClass().flags().isInterface()) {
                throw new SemanticException("Superinterface " + t + " of " + this.type + " is not an interface.", tn.position());
            }
            if (!this.type.equals(tc.typeSystem().Object()) && !this.type.fullName().equals(tc.typeSystem().Object().fullName())) continue;
            throw new SemanticException("Class " + this.type + " cannot have a superinterface.", tn.position());
        }
        TypeSystem ts = tc.typeSystem();
        try {
            if (this.type.isTopLevel()) {
                ts.checkTopLevelClassFlags(this.type.flags());
            }
            if (this.type.isMember()) {
                ts.checkMemberClassFlags(this.type.flags());
            }
            if (this.type.isLocal()) {
                ts.checkLocalClassFlags(this.type.flags());
            }
        }
        catch (SemanticException e) {
            throw new SemanticException(e.getMessage(), this.position());
        }
        ts.checkClassConformance(this.type);
        return this;
    }

    public String toString() {
        return this.flags.clearInterface().translate() + (this.flags.isInterface() ? "interface " : "class ") + this.name + " " + this.body;
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        if (this.flags.isInterface()) {
            w.write(this.flags.clearInterface().clearAbstract().translate());
        } else {
            w.write(this.flags.translate());
        }
        if (this.flags.isInterface()) {
            w.write("interface ");
        } else {
            w.write("class ");
        }
        tr.print(this, this.name, w);
        if (this.superClass() != null) {
            w.allowBreak(0);
            w.write("extends ");
            this.print(this.superClass(), w, tr);
        }
        if (!this.interfaces.isEmpty()) {
            w.allowBreak(2);
            if (this.flags.isInterface()) {
                w.write("extends ");
            } else {
                w.write("implements ");
            }
            w.begin(0);
            Iterator i = this.interfaces().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print(tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0);
            }
            w.end();
        }
        w.unifiedBreak(0);
        w.end();
        w.write("{");
    }

    public void prettyPrintFooter(CodeWriter w, PrettyPrinter tr) {
        w.write("}");
        w.newline(0);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.prettyPrintHeader(w, tr);
        this.print(this.body(), w, tr);
        this.prettyPrintFooter(w, tr);
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
        if (this.type != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(type " + this.type + ")");
            w.end();
        }
    }

    public Node disambiguateOverride(Node parent, AmbiguityRemover ar) throws SemanticException {
        return null;
    }

    public Node copy(NodeFactory nf) {
        return nf.ClassDecl(this.position, this.flags, this.name, this.superClass, this.interfaces, this.body);
    }

    static {
        $assertionsDisabled = !ClassDecl_c.class.desiredAssertionStatus();
    }
}

