/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassMember;
import polyglot.ast.CodeDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Term;
import polyglot.ast.Term_c;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.FieldInstance;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeChecker;

public class ClassBody_c
extends Term_c
implements ClassBody {
    protected List members;
    private static final Collection TOPICS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ClassBody_c(Position pos, List members) {
        super(pos);
        if (!$assertionsDisabled && members == null) {
            throw new AssertionError();
        }
        this.members = TypedList.copyAndCheck(members, ClassMember.class, true);
    }

    public List members() {
        return this.members;
    }

    public ClassBody members(List members) {
        ClassBody_c n = (ClassBody_c)this.copy();
        n.members = TypedList.copyAndCheck(members, ClassMember.class, true);
        return n;
    }

    public ClassBody addMember(ClassMember member) {
        ClassBody_c n = (ClassBody_c)this.copy();
        ArrayList<ClassMember> l = new ArrayList<ClassMember>(this.members.size() + 1);
        l.addAll(this.members);
        l.add(member);
        n.members = TypedList.copyAndCheck(l, ClassMember.class, true);
        return n;
    }

    protected ClassBody_c reconstruct(List members) {
        if (!CollectionUtil.equals(members, this.members)) {
            ClassBody_c n = (ClassBody_c)this.copy();
            n.members = TypedList.copyAndCheck(members, ClassMember.class, true);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        List members = this.visitList(this.members, v);
        return this.reconstruct(members);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        return this;
    }

    public String toString() {
        return "{ ... }";
    }

    protected void duplicateFieldCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        ArrayList l = new ArrayList(type.fields());
        for (int i = 0; i < l.size(); ++i) {
            FieldInstance fi = (FieldInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                FieldInstance fj = (FieldInstance)l.get(j);
                if (!fi.name().equals(fj.name())) continue;
                throw new SemanticException("Duplicate field \"" + fj + "\".", fj.position());
            }
        }
    }

    protected void duplicateConstructorCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        ArrayList l = new ArrayList(type.constructors());
        for (int i = 0; i < l.size(); ++i) {
            ConstructorInstance ci = (ConstructorInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                ConstructorInstance cj = (ConstructorInstance)l.get(j);
                if (!ci.hasFormals(cj.formalTypes())) continue;
                throw new SemanticException("Duplicate constructor \"" + cj + "\".", cj.position());
            }
        }
    }

    protected void duplicateMethodCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        TypeSystem ts = tc.typeSystem();
        ArrayList l = new ArrayList(type.methods());
        for (int i = 0; i < l.size(); ++i) {
            MethodInstance mi = (MethodInstance)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                MethodInstance mj = (MethodInstance)l.get(j);
                if (!this.isSameMethod(ts, mi, mj)) continue;
                throw new SemanticException("Duplicate method \"" + mj + "\".", mj.position());
            }
        }
    }

    protected void duplicateMemberClassCheck(TypeChecker tc) throws SemanticException {
        ClassType type = tc.context().currentClass();
        ArrayList l = new ArrayList(type.memberClasses());
        for (int i = 0; i < l.size(); ++i) {
            ClassType mi = (ClassType)l.get(i);
            for (int j = i + 1; j < l.size(); ++j) {
                ClassType mj = (ClassType)l.get(j);
                if (!mi.name().equals(mj.name())) continue;
                throw new SemanticException("Duplicate member type \"" + mj + "\".", mj.position());
            }
        }
    }

    protected boolean isSameMethod(TypeSystem ts, MethodInstance mi, MethodInstance mj) {
        return mi.isSameMethod(mj);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        this.duplicateFieldCheck(tc);
        this.duplicateConstructorCheck(tc);
        this.duplicateMethodCheck(tc);
        this.duplicateMemberClassCheck(tc);
        return this;
    }

    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        return ec.push();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (!this.members.isEmpty()) {
            w.newline(4);
            w.begin(0);
            ClassMember prev = null;
            Iterator i = this.members.iterator();
            while (i.hasNext()) {
                ClassMember member = (ClassMember)i.next();
                if (member instanceof CodeDecl || prev instanceof CodeDecl) {
                    w.newline(0);
                }
                prev = member;
                this.printBlock(member, w, tr);
                if (!i.hasNext()) continue;
                w.newline(0);
            }
            w.end();
            w.newline(0);
        }
    }

    public Term firstChild() {
        return null;
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        return succs;
    }

    public Node copy(NodeFactory nf) {
        return nf.ClassBody(this.position, this.members);
    }

    static {
        $assertionsDisabled = !ClassBody_c.class.desiredAssertionStatus();
        TOPICS = CollectionUtil.list("types", "context");
    }
}

