/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.frontend.ExtensionInfo;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeChecker;

public class CanonicalTypeNode_c
extends TypeNode_c
implements CanonicalTypeNode {
    static final /* synthetic */ boolean $assertionsDisabled;

    public CanonicalTypeNode_c(Position pos, Type type) {
        super(pos);
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        this.type = type;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        ClassType ct;
        TypeSystem ts = tc.typeSystem();
        if (this.type.isClass() && ((ct = this.type.toClass()).isTopLevel() || ct.isMember()) && !ts.classAccessible(ct, tc.context())) {
            throw new SemanticException("Cannot access class \"" + ct + "\" from the body of \"" + tc.context().currentClass() + "\".", this.position());
        }
        return this;
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.type == null) {
            w.write("<unknown-type>");
        } else {
            this.type.print(w);
        }
    }

    public void translate(CodeWriter w, Translator tr) {
        w.write(this.type.translate(tr.context()));
    }

    public String toString() {
        if (this.type == null) {
            return "<unknown-type>";
        }
        return ((Object)this.type).toString();
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(type " + this.type + ")");
        w.end();
    }

    public Node copy(NodeFactory nf) {
        CanonicalTypeNode result = nf.CanonicalTypeNode(this.position, this.type);
        return result;
    }

    public Node copy(ExtensionInfo extInfo) throws SemanticException {
        TypeNode tn = (TypeNode)this.del().copy(extInfo.nodeFactory());
        Type t = tn.type();
        if (t != null) {
            TypeSystem ts = extInfo.typeSystem();
            if (t.isVoid()) {
                t = ts.Void();
            } else if (t.isBoolean()) {
                t = ts.Boolean();
            } else if (t.isByte()) {
                t = ts.Byte();
            } else if (t.isChar()) {
                t = ts.Char();
            } else if (t.isDouble()) {
                t = ts.Double();
            } else if (t.isFloat()) {
                t = ts.Float();
            } else if (t.isInt()) {
                t = ts.Int();
            } else if (t.isLong()) {
                t = ts.Long();
            } else if (t.isNull()) {
                t = ts.Null();
            } else if (t.isShort()) {
                t = ts.Short();
            }
            tn = tn.type(t);
        }
        return tn;
    }

    static {
        $assertionsDisabled = !CanonicalTypeNode_c.class.desiredAssertionStatus();
    }
}

