/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Expr_c;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Precedence;
import polyglot.ast.ProcedureCall;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.Term;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.MethodInstance;
import polyglot.types.ProcedureInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.UnknownType;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AscriptionVisitor;
import polyglot.visit.CFGBuilder;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class Call_c
extends Expr_c
implements Call {
    protected Receiver target;
    protected Id name;
    protected List arguments;
    protected MethodInstance mi;
    protected boolean targetImplicit;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Call_c(Position pos, Receiver target, Id name, List arguments) {
        super(pos);
        if (!($assertionsDisabled || name != null && arguments != null)) {
            throw new AssertionError();
        }
        this.target = target;
        this.name = name;
        this.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        this.targetImplicit = target == null;
    }

    public Precedence precedence() {
        return Precedence.LITERAL;
    }

    public Receiver target() {
        return this.target;
    }

    public Call target(Receiver target) {
        Call_c n = (Call_c)this.copy();
        n.target = target;
        return n;
    }

    public Id id() {
        return this.name;
    }

    public Call id(Id name) {
        Call_c n = (Call_c)this.copy();
        n.name = name;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public Call name(String name) {
        return this.id(this.name.id(name));
    }

    public ProcedureInstance procedureInstance() {
        return this.methodInstance();
    }

    public MethodInstance methodInstance() {
        return this.mi;
    }

    public Call methodInstance(MethodInstance mi) {
        if (mi == this.mi) {
            return this;
        }
        Call_c n = (Call_c)this.copy();
        n.mi = mi;
        return n;
    }

    public boolean isTargetImplicit() {
        return this.targetImplicit;
    }

    public Call targetImplicit(boolean targetImplicit) {
        if (targetImplicit == this.targetImplicit) {
            return this;
        }
        Call_c n = (Call_c)this.copy();
        n.targetImplicit = targetImplicit;
        return n;
    }

    public List arguments() {
        return this.arguments;
    }

    public ProcedureCall arguments(List arguments) {
        Call_c n = (Call_c)this.copy();
        n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
        return n;
    }

    protected Call_c reconstruct(Receiver target, Id name, List arguments) {
        if (target != this.target || name != this.name || !CollectionUtil.equals(arguments, this.arguments)) {
            Call_c n = (Call_c)this.copy();
            n.targetImplicit = n.targetImplicit & target == n.target;
            n.target = target;
            n.name = name;
            n.arguments = TypedList.copyAndCheck(arguments, Expr.class, true);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Receiver target = (Receiver)this.visitChild(this.target, v);
        Id name = (Id)this.visitChild(this.name, v);
        List arguments = this.visitList(this.arguments, v);
        return this.reconstruct(target, name, arguments);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        Call_c n = (Call_c)super.buildTypes(tb);
        TypeSystem ts = tb.typeSystem();
        ArrayList<UnknownType> l = new ArrayList<UnknownType>(this.arguments.size());
        for (int i = 0; i < this.arguments.size(); ++i) {
            l.add(ts.unknownType(this.position()));
        }
        MethodInstance mi = ts.methodInstance(this.position(), tb.currentClass(), Flags.NONE, ts.unknownType(this.position()), this.name.id(), l, Collections.EMPTY_LIST);
        return n.methodInstance(mi);
    }

    protected Node typeCheckNullTarget(TypeChecker tc, List argTypes) throws SemanticException {
        Receiver r;
        TypeSystem ts = tc.typeSystem();
        NodeFactory nf = tc.nodeFactory();
        Context c = tc.context();
        MethodInstance mi = c.findMethod(this.name.id(), argTypes);
        if (mi.flags().isStatic()) {
            Type container = this.findContainer(ts, mi);
            r = nf.CanonicalTypeNode(this.position().startOf(), container).type(container);
        } else {
            ClassType scope = c.findMethodScope(this.name.id());
            r = !ts.equals(scope, c.currentClass()) ? nf.This(this.position().startOf(), nf.CanonicalTypeNode(this.position().startOf(), scope)).type(scope) : nf.This(this.position().startOf()).type(scope);
        }
        Call_c call = (Call_c)this.targetImplicit(true).target(r);
        return call.visit(tc.rethrowMissingDependencies(true));
    }

    protected Type findContainer(TypeSystem ts, MethodInstance mi) {
        return ts.staticTarget(mi.container());
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        TypeSystem ts = tc.typeSystem();
        Context c = tc.context();
        ArrayList<Type> argTypes = new ArrayList<Type>(this.arguments.size());
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            Expr e = (Expr)i.next();
            if (!e.type().isCanonical()) {
                return this;
            }
            argTypes.add(e.type());
        }
        if (this.target == null) {
            return this.typeCheckNullTarget(tc, argTypes);
        }
        if (!this.target.type().isCanonical()) {
            return this;
        }
        ReferenceType targetType = this.findTargetType();
        MethodInstance mi = ts.findMethod(targetType, this.name.id(), argTypes, c.currentClass());
        boolean staticContext = this.target instanceof TypeNode;
        if (staticContext && !mi.flags().isStatic()) {
            throw new SemanticException("Cannot call non-static method " + this.name.id() + " of " + this.target.type() + " in static " + "context.", this.position());
        }
        if (this.target instanceof Special && ((Special)this.target).kind() == Special.SUPER && mi.flags().isAbstract()) {
            throw new SemanticException("Cannot call an abstract method of the super class", this.position());
        }
        Call_c call = (Call_c)this.methodInstance(mi).type(mi.returnType());
        call.checkConsistency(c);
        return call;
    }

    protected ReferenceType findTargetType() throws SemanticException {
        Type t = this.target.type();
        if (t.isReference()) {
            return t.toReference();
        }
        if (this.target instanceof Expr) {
            throw new SemanticException("Cannot invoke method \"" + this.name + "\" on " + "an expression of non-reference type " + t + ".", this.target.position());
        }
        if (this.target instanceof TypeNode) {
            throw new SemanticException("Cannot invoke static method \"" + this.name + "\" on non-reference type " + t + ".", this.target.position());
        }
        throw new SemanticException("Cannot invoke method \"" + this.name + "\" on non-reference type " + t + ".", this.target.position());
    }

    public Type childExpectedType(Expr child, AscriptionVisitor av) {
        if (child == this.target) {
            return this.mi.container();
        }
        Iterator i = this.arguments.iterator();
        Iterator j = this.mi.formalTypes().iterator();
        while (i.hasNext() && j.hasNext()) {
            Expr e = (Expr)i.next();
            Type t = (Type)j.next();
            if (e != child) continue;
            return t;
        }
        return child.type();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.targetImplicit ? "" : this.target.toString() + ".");
        sb.append(this.name);
        sb.append("(");
        int count = 0;
        Iterator i = this.arguments.iterator();
        while (i.hasNext()) {
            if (count++ > 2) {
                sb.append("...");
                break;
            }
            Expr n = (Expr)i.next();
            sb.append(n.toString());
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        w.begin(0);
        if (!this.targetImplicit) {
            if (this.target instanceof Expr) {
                this.printSubExpr((Expr)this.target, w, tr);
            } else if (this.target != null) {
                this.print(this.target, w, tr);
            }
            w.write(".");
            w.allowBreak(2, 3, "", 0);
        }
        w.write(this.name + "(");
        if (this.arguments.size() > 0) {
            w.allowBreak(2, 2, "", 0);
            w.begin(0);
            Iterator i = this.arguments.iterator();
            while (i.hasNext()) {
                Expr e = (Expr)i.next();
                this.print(e, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.end();
        }
        w.write(")");
        w.end();
    }

    public void dump(CodeWriter w) {
        super.dump(w);
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(targetImplicit " + this.targetImplicit + ")");
        w.end();
        if (this.mi != null) {
            w.allowBreak(4, " ");
            w.begin(0);
            w.write("(instance " + this.mi + ")");
            w.end();
        }
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(name " + this.name + ")");
        w.end();
        w.allowBreak(4, " ");
        w.begin(0);
        w.write("(arguments " + this.arguments + ")");
        w.end();
    }

    public Term firstChild() {
        if (this.target instanceof Term) {
            return (Term)((Object)this.target);
        }
        return Call_c.listChild(this.arguments, null);
    }

    public List acceptCFG(CFGBuilder v, List succs) {
        if (this.target instanceof Term) {
            Term t = (Term)((Object)this.target);
            if (!this.arguments.isEmpty()) {
                v.visitCFG(t, Call_c.listChild(this.arguments, null), 1);
                v.visitCFGList(this.arguments, this, 0);
            } else {
                v.visitCFG(t, this, 0);
            }
        }
        return succs;
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        if (this.mi == null) {
            throw new InternalCompilerError(this.position(), "Null method instance after type check.");
        }
        return super.exceptionCheck(ec);
    }

    public List throwTypes(TypeSystem ts) {
        LinkedList<ClassType> l = new LinkedList<ClassType>();
        l.addAll(this.mi.throwTypes());
        l.addAll(ts.uncheckedExceptions());
        if (this.target instanceof Expr && !(this.target instanceof Special)) {
            l.add(ts.NullPointerException());
        }
        return l;
    }

    protected void checkConsistency(Context c) throws SemanticException {
        if (this.targetImplicit) {
            MethodInstance methodInstance = c.findMethod(this.name.id(), this.mi.formalTypes());
        }
    }

    public Node copy(NodeFactory nf) {
        return nf.Call(this.position, this.target, this.name, this.arguments);
    }

    static {
        $assertionsDisabled = !Call_c.class.desiredAssertionStatus();
    }
}

