/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import polyglot.ast.ArrayTypeNode;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.TypeNode;
import polyglot.ast.TypeNode_c;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.CodeWriter;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class ArrayTypeNode_c
extends TypeNode_c
implements ArrayTypeNode {
    protected TypeNode base;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ArrayTypeNode_c(Position pos, TypeNode base) {
        super(pos);
        if (!$assertionsDisabled && base == null) {
            throw new AssertionError();
        }
        this.base = base;
    }

    public TypeNode base() {
        return this.base;
    }

    public ArrayTypeNode base(TypeNode base) {
        ArrayTypeNode_c n = (ArrayTypeNode_c)this.copy();
        n.base = base;
        return n;
    }

    protected ArrayTypeNode_c reconstruct(TypeNode base) {
        if (base != this.base) {
            ArrayTypeNode_c n = (ArrayTypeNode_c)this.copy();
            n.base = base;
            return n;
        }
        return this;
    }

    public boolean isDisambiguated() {
        return false;
    }

    public Node visitChildren(NodeVisitor v) {
        TypeNode base = (TypeNode)this.visitChild(this.base, v);
        return this.reconstruct(base);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        TypeSystem ts = tb.typeSystem();
        return this.type(ts.arrayOf(this.position(), this.base.type()));
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        TypeSystem ts = ar.typeSystem();
        NodeFactory nf = ar.nodeFactory();
        if (!this.base.isDisambiguated()) {
            return this;
        }
        Type baseType = this.base.type();
        if (!baseType.isCanonical()) {
            return this;
        }
        return nf.CanonicalTypeNode(this.position(), ts.arrayOf(this.position(), baseType));
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot type check ambiguous node " + this + ".");
    }

    public Node exceptionCheck(ExceptionChecker ec) throws SemanticException {
        throw new InternalCompilerError(this.position(), "Cannot exception check ambiguous node " + this + ".");
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.print(this.base, w, tr);
        w.write("[]");
    }

    public String toString() {
        return this.base.toString() + "[]";
    }

    public Node copy(NodeFactory nf) {
        return nf.ArrayTypeNode(this.position, this.base);
    }

    static {
        $assertionsDisabled = !ArrayTypeNode_c.class.desiredAssertionStatus();
    }
}

