/*
 * Decompiled with CFR 0.152.
 */
package polyglot.ast;

import java.util.ArrayList;
import java.util.List;
import polyglot.ast.ArrayAccess;
import polyglot.ast.ArrayAccessAssign;
import polyglot.ast.Assign;
import polyglot.ast.Assign_c;
import polyglot.ast.Expr;
import polyglot.ast.Term;
import polyglot.types.ClassType;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.CFGBuilder;

public class ArrayAccessAssign_c
extends Assign_c
implements ArrayAccessAssign {
    public ArrayAccessAssign_c(Position pos, ArrayAccess left, Assign.Operator op, Expr right) {
        super(pos, left, op, right);
    }

    public Assign left(Expr left) {
        ArrayAccessAssign_c n = (ArrayAccessAssign_c)super.left(left);
        n.assertLeftType();
        return n;
    }

    private void assertLeftType() {
        if (!(this.left() instanceof ArrayAccess)) {
            throw new InternalCompilerError("left expression of an ArrayAccessAssign must be an array access");
        }
    }

    public Term firstChild() {
        if (this.operator() == ASSIGN) {
            return ((ArrayAccess)this.left()).array();
        }
        return this.left();
    }

    protected void acceptCFGAssign(CFGBuilder v) {
        ArrayAccess a = (ArrayAccess)this.left();
        v.visitCFG(a.array(), a.index(), 1);
        v.visitCFG(a.index(), this.right(), 1);
        v.visitCFG(this.right(), this, 0);
    }

    protected void acceptCFGOpAssign(CFGBuilder v) {
        v.visitCFG(this.left(), this.right(), 1);
        v.visitCFG(this.right(), this, 0);
    }

    public List throwTypes(TypeSystem ts) {
        ArrayList<ClassType> l = new ArrayList<ClassType>(super.throwTypes(ts));
        if (this.throwsArrayStoreException()) {
            l.add(ts.ArrayStoreException());
        }
        l.add(ts.NullPointerException());
        l.add(ts.OutOfBoundsException());
        return l;
    }

    public boolean throwsArrayStoreException() {
        return this.op == ASSIGN && this.left.type().isReference();
    }
}

