/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.regex.Pattern;
import polyglot.pth.AbstractTest;
import polyglot.pth.Main;
import polyglot.pth.OutputController;
import polyglot.pth.Test;
import polyglot.pth.TestResult;
import polyglot.pth.TestSuiteResult;

public class TestSuite
extends AbstractTest {
    protected List tests;
    protected boolean haltOnFirstFailure = false;
    protected int totalTests = 0;
    protected int successfulTests = 0;

    public TestSuite(String name) {
        this(name, new ArrayList(), false);
    }

    public TestSuite(String name, List tests) {
        this(name, tests, false);
    }

    public TestSuite(String name, List tests, boolean haltOnFirstFailure) {
        super(name);
        this.tests = tests;
        this.haltOnFirstFailure = haltOnFirstFailure;
    }

    public boolean getHaltOnFirstFailure() {
        return this.haltOnFirstFailure;
    }

    public void setOutputController(OutputController output) {
        super.setOutputController(output);
        Iterator iter = this.tests.iterator();
        while (iter.hasNext()) {
            Test t = (Test)iter.next();
            t.setOutputController(output);
        }
    }

    protected boolean runTest() {
        boolean okay = true;
        if (this.getTestSuiteResult() == null) {
            this.setTestResult(this.createTestResult(null));
        }
        HashMap oldTestResults = new HashMap(this.getTestSuiteResult().testResults);
        HashMap<String, TestResult> newResults = new HashMap<String, TestResult>();
        Iterator i = this.tests.iterator();
        while (i.hasNext()) {
            Test t = (Test)i.next();
            TestResult tr = (TestResult)oldTestResults.get(t.getName());
            if (TestSuite.executeTest(t.getName(), tr)) {
                ++this.totalTests;
                if (tr != null) {
                    t.setTestResult(tr);
                }
                boolean result = t.run();
                okay = okay && result;
                tr = t.getTestResult();
                if (!result && this.haltOnFirstFailure) break;
                if (result) {
                    ++this.successfulTests;
                }
            }
            this.getTestSuiteResult().testResults.put(t.getName(), tr);
            newResults.put(t.getName(), tr);
            this.postIndividualTest();
        }
        this.getTestSuiteResult().testResults.clear();
        this.getTestSuiteResult().testResults.putAll(newResults);
        return okay;
    }

    protected void postIndividualTest() {
    }

    public int getTotalTestCount() {
        return this.totalTests;
    }

    public int getSuccesfulTestCount() {
        return this.successfulTests;
    }

    public int getFailedTestCount() {
        return this.totalTests - this.successfulTests;
    }

    protected static boolean executeTest(String testName, TestResult tr) {
        if (Main.options.testFilter != null && !Pattern.matches(Main.options.testFilter, testName)) {
            return false;
        }
        return !Main.options.testPreviouslyFailedOnly || tr == null || tr.dateLastSuccess == null || !tr.dateLastSuccess.equals(tr.dateTestRun);
    }

    protected TestSuiteResult getTestSuiteResult() {
        return (TestSuiteResult)this.getTestResult();
    }

    public List getTests() {
        return Collections.unmodifiableList(this.tests);
    }

    protected TestResult createTestResult(Date lastSuccess) {
        LinkedHashMap testResults = this.getTestSuiteResult() != null ? this.getTestSuiteResult().testResults : new LinkedHashMap();
        Date lastRun = new Date();
        if (this.success()) {
            lastSuccess = lastRun;
        }
        return new TestSuiteResult(this, lastRun, testResults, lastSuccess);
    }
}

