/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import polyglot.main.Main;
import polyglot.pth.AbstractTest;
import polyglot.pth.AnyExpectedFailure;
import polyglot.pth.ExpectedFailure;
import polyglot.pth.Main;
import polyglot.util.ErrorInfo;
import polyglot.util.ErrorQueue;
import polyglot.util.SilentErrorQueue;

public class SourceFileTest
extends AbstractTest {
    protected final List sourceFilenames;
    protected String extensionClassname = null;
    protected String[] extraArgs;
    protected List mainExtraArgs;
    protected final SilentErrorQueue eq;
    protected String destDir;
    protected List expectedFailures;
    protected Set undefinedEnvVars = new HashSet();

    public SourceFileTest(String filename) {
        super(new File(filename).getName());
        this.sourceFilenames = Collections.singletonList(filename);
        this.eq = new SilentErrorQueue(100, this.getName());
    }

    public SourceFileTest(List filenames) {
        super(filenames.toString());
        this.sourceFilenames = filenames;
        this.eq = new SilentErrorQueue(100, this.getName());
    }

    public SourceFileTest(String[] filenames) {
        this(Arrays.asList(filenames).toString());
    }

    public void setExpectedFailures(List expectedFailures) {
        this.expectedFailures = expectedFailures;
    }

    protected boolean runTest() {
        Iterator i = this.sourceFilenames.iterator();
        while (i.hasNext()) {
            File sourceFile = new File((String)i.next());
            if (sourceFile.exists()) continue;
            this.setFailureMessage("File not found.");
            return false;
        }
        try {
            this.invokePolyglot(this.getSourceFileNames());
        }
        catch (Main.TerminationException e) {
            if (e.getMessage() != null) {
                this.setFailureMessage(e.getMessage());
                return false;
            }
            if (!this.eq.hasErrors()) {
                this.setFailureMessage("Failed to compile for unknown reasons: " + e.toString());
                return false;
            }
        }
        catch (RuntimeException e) {
            if (e.getMessage() != null) {
                this.setFailureMessage(e.getMessage());
                e.printStackTrace();
                return false;
            }
            this.setFailureMessage("Uncaught " + e.getClass().getName());
            e.printStackTrace();
            return false;
        }
        return this.checkErrorQueue(this.eq);
    }

    protected void postRun() {
        this.output.finishTest(this, (ErrorQueue)this.eq);
    }

    protected boolean checkErrorQueue(SilentErrorQueue eq) {
        ArrayList errors = new ArrayList(eq.getErrors());
        boolean swallowRemainingFailures = false;
        Iterator i = this.expectedFailures.iterator();
        while (i.hasNext()) {
            ExpectedFailure f = (ExpectedFailure)i.next();
            if (f instanceof AnyExpectedFailure) {
                swallowRemainingFailures = true;
                continue;
            }
            boolean found = false;
            Iterator j = errors.iterator();
            while (j.hasNext()) {
                ErrorInfo e = (ErrorInfo)j.next();
                if (!f.matches(e)) continue;
                found = true;
                j.remove();
                break;
            }
            if (found) continue;
            this.setFailureMessage("Expected to see " + f.toString());
            return false;
        }
        if (!errors.isEmpty() && !swallowRemainingFailures) {
            StringBuffer sb = new StringBuffer();
            Iterator iter = errors.iterator();
            while (iter.hasNext()) {
                ErrorInfo err = (ErrorInfo)iter.next();
                sb.append(err.getMessage());
                if (err.getPosition() != null) {
                    sb.append(" (");
                    sb.append(err.getPosition());
                    sb.append(")");
                }
                if (!iter.hasNext()) continue;
                sb.append("; ");
            }
            this.setFailureMessage(sb.toString());
        }
        return errors.isEmpty() || swallowRemainingFailures;
    }

    protected String[] getSourceFileNames() {
        return this.sourceFilenames.toArray(new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invokePolyglot(String[] files) throws Main.TerminationException {
        File tmpdir = new File("pthOutput");
        int i = 1;
        while (tmpdir.exists()) {
            tmpdir = new File("pthOutput." + i);
            ++i;
        }
        tmpdir.mkdir();
        this.setDestDir(tmpdir.getPath());
        String[] cmdLine = this.buildCmdLine(files);
        polyglot.main.Main polyglotMain = new polyglot.main.Main();
        try {
            polyglotMain.start(cmdLine, (ErrorQueue)this.eq);
        }
        finally {
            if (Main.options.deleteOutputFiles) {
                this.deleteDir(tmpdir);
            }
            this.setDestDir(null);
        }
    }

    protected void deleteDir(File dir) {
        File[] list = dir.listFiles();
        for (int i = 0; i < list.length; ++i) {
            if (list[i].isDirectory()) {
                this.deleteDir(list[i]);
                continue;
            }
            if (list[i].delete()) continue;
            list[i].deleteOnExit();
        }
        if (!dir.delete()) {
            dir.deleteOnExit();
        }
    }

    protected String[] buildCmdLine(String[] files) {
        String sas;
        int i;
        String[] sa;
        ArrayList<String> args = new ArrayList<String>();
        String s = this.getExtensionClassname();
        if (s != null) {
            args.add("-extclass");
            args.add(s);
        }
        if ((s = this.getAdditionalClasspath()) != null) {
            args.add("-cp");
            args.add(s);
        }
        if ((s = this.getDestDir()) != null) {
            args.add("-d");
            args.add(s);
        }
        if ((s = this.getSourceDir()) != null) {
            args.add("-sourcepath");
            args.add(s);
        }
        char pathSep = File.pathSeparatorChar;
        if (this.mainExtraArgs == null && (s = Main.options.extraArgs) != null) {
            this.mainExtraArgs = new ArrayList();
            sa = SourceFileTest.breakString(Main.options.extraArgs);
            for (i = 0; i < sa.length; ++i) {
                sas = sa[i];
                if (pathSep != ':' && sas.indexOf(58) >= 0) {
                    sas = this.replacePathSep(sas, pathSep);
                }
                this.mainExtraArgs.add(sas);
            }
        }
        if (this.mainExtraArgs != null) {
            args.addAll(this.mainExtraArgs);
        }
        if ((sa = this.getExtraCmdLineArgs()) != null) {
            for (i = 0; i < sa.length; ++i) {
                sas = sa[i];
                if (pathSep != ':' && sas.indexOf(58) >= 0) {
                    sas = this.replacePathSep(sas, pathSep);
                }
                sas = this.replaceEnvVariables(sas);
                args.add(sas);
            }
        }
        args.addAll(Arrays.asList(files));
        return args.toArray(new String[0]);
    }

    private String replacePathSep(String sas, char pathSep) {
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < sas.length(); ++j) {
            if (sas.charAt(j) == '\\' && j + 1 < sas.length() && sas.charAt(j + 1) == ':') {
                ++j;
                sb.append(':');
                continue;
            }
            if (sas.charAt(j) == ':') {
                sb.append(pathSep);
                continue;
            }
            sb.append(sas.charAt(j));
        }
        return sb.toString();
    }

    private String replaceEnvVariables(String sas) {
        int start;
        while ((start = sas.indexOf(36)) >= 0) {
            int end;
            for (end = start + 1; end < sas.length() && (Character.isUnicodeIdentifierStart(sas.charAt(end)) || Character.isUnicodeIdentifierPart(sas.charAt(end))); ++end) {
            }
            String var = sas.substring(start + 1, end);
            String v = System.getenv(var);
            if (v == null && !this.undefinedEnvVars.contains(var)) {
                this.undefinedEnvVars.add(var);
                this.output.warning("environment variable $" + var + " undefined.");
                v = "";
            }
            sas = sas.substring(0, start) + v + sas.substring(end);
        }
        return sas;
    }

    protected String getExtensionClassname() {
        return this.extensionClassname;
    }

    protected void setExtensionClassname(String extClassname) {
        this.extensionClassname = extClassname;
    }

    protected String[] getExtraCmdLineArgs() {
        return this.extraArgs;
    }

    protected static String[] breakString(String s) {
        ArrayList<String> l = new ArrayList<String>();
        String token = "";
        char endChar = '\u0000';
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (endChar != '\u0000' && c == endChar) {
                endChar = '\u0000';
                continue;
            }
            if (c == '\\') {
                c = s.charAt(++i);
                token = token + c;
                continue;
            }
            if (c == '\"' || c == '\'') {
                endChar = c;
                continue;
            }
            if (endChar == '\u0000' && Character.isWhitespace(c)) {
                if (token.length() > 0) {
                    l.add(token);
                }
                token = "";
                continue;
            }
            token = token + c;
        }
        if (token.length() > 0) {
            l.add(token);
        }
        return l.toArray(new String[l.size()]);
    }

    protected void setExtraCmdLineArgs(String args) {
        if (args != null) {
            this.extraArgs = SourceFileTest.breakString(args);
        }
    }

    protected String getAdditionalClasspath() {
        return Main.options.classpath;
    }

    protected void setDestDir(String dir) {
        this.destDir = dir;
    }

    protected String getDestDir() {
        return this.destDir;
    }

    protected String getSourceDir() {
        return null;
    }
}

