/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.io.PrintStream;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import polyglot.pth.CommandLineOption;

public class Options {
    private static final int USAGE_FLAG_WIDTH = 21;
    private static final int USAGE_SCREEN_WIDTH = 75;
    protected List inputFilenames = new LinkedList();
    protected int verbosity = 5;
    protected String classpath = null;
    protected String extraArgs = null;
    protected String testFilter = null;
    protected boolean showResultsOnly = false;
    protected boolean testPreviouslyFailedOnly = false;
    protected boolean deleteOutputFiles = true;
    protected CommandLineOption[] commandLineOpts = new CommandLineOption[]{new CommandLineOption(new String[]{"f", "filter"}, "regexp", "only execute the tests for which the regular expression regexp occurs somewhere in the test's name."){

        protected int invoke(int index, String[] args) {
            Options.this.testFilter = ".*" + this.getStringArg(++index, args) + ".*";
            return index + 1;
        }
    }, new CommandLineOption(new String[]{"p", "preserve"}, "preserve output files between tests; default is to delete"){

        protected int invoke(int index, String[] args) {
            Options.this.deleteOutputFiles = false;
            return index + 1;
        }
    }, new CommandLineOption(new String[]{"q", "question"}, "show the latest results for the scripts; don't run any tests"){

        protected int invoke(int index, String[] args) {
            Options.this.showResultsOnly = true;
            return index + 1;
        }
    }, new CommandLineOption("s", "only execute the tests which did not succeed last time they were executed."){

        protected int invoke(int index, String[] args) {
            Options.this.testPreviouslyFailedOnly = true;
            return index + 1;
        }
    }, new CommandLineOption(new String[]{"v"}, "n", "set verbosity level to n. n should be between 0 (quiet) and 9 (most verbose)."){

        protected int invoke(int index, String[] args) {
            Options.this.verbosity = this.getIntArg(++index, args);
            if (Options.this.verbosity < 0 || Options.this.verbosity > 9) {
                throw new IllegalArgumentException("Verbosity must be between 0 and 9 inclusive.");
            }
            return index + 1;
        }
    }, new CommandLineOption(new String[]{"cp", "classpath"}, "path", "set the class path for the Polyglot compiler."){

        protected int invoke(int index, String[] args) {
            Options.this.classpath = this.getStringArg(++index, args);
            return index + 1;
        }
    }, new CommandLineOption(new String[]{"args"}, "extraArgs", "provide additional command line arguments to the Polyglot compiler."){

        protected int invoke(int index, String[] args) {
            Options.this.extraArgs = this.getStringArg(++index, args);
            return index + 1;
        }
    }, new CommandLineOption(new String[]{"h", "help", "?"}, "Display this message."){

        protected int invoke(int index, String[] args) {
            Options.this.usage(System.out);
            System.exit(0);
            return index + 1;
        }
    }, new CommandLineOption(new String[0], "Files"){

        protected int invoke(int index, String[] args) {
            return index;
        }

        protected int parse(int index, String[] args) {
            if (!args[index].startsWith("-")) {
                Options.this.inputFilenames.add(args[index++]);
            }
            return index;
        }
    }};

    protected void usage(PrintStream out) {
        out.println("Polyglot Test Harness");
        out.println("Usage: pth [options] scriptFile ...");
        out.println("where options include: ");
        for (int i = 0; i < this.commandLineOpts.length; ++i) {
            this.usageForSwitch(out, this.commandLineOpts[i]);
        }
    }

    protected void usageForSwitch(PrintStream out, CommandLineOption arg) {
        if (arg.switches.length == 0) {
            return;
        }
        out.print("  ");
        int cur = 2;
        for (int i = 0; i < arg.switches.length; ++i) {
            String flag = arg.switches[i];
            out.print("-" + flag);
            cur += 1 + flag.length();
            if (arg.additionalArg != null) {
                out.print(" " + arg.additionalArg);
                cur += 1 + arg.additionalArg.length();
            }
            if (i >= arg.switches.length - 1) continue;
            out.print(", ");
            cur += 2;
        }
        if (cur < 21) {
            Options.printSpaces(out, 21 - cur);
        } else {
            out.println();
            Options.printSpaces(out, 21);
        }
        cur = 21;
        StringTokenizer st = new StringTokenizer(arg.explanation);
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (cur + s.length() > 75) {
                out.println();
                Options.printSpaces(out, 21);
                cur = 21;
            }
            out.print(s);
            cur += s.length();
            if (!st.hasMoreTokens()) continue;
            if (cur + 1 > 75) {
                out.println();
                Options.printSpaces(out, 21);
                cur = 21;
                continue;
            }
            out.print(" ");
            ++cur;
        }
        out.println();
    }

    protected static void printSpaces(PrintStream out, int n) {
        while (n-- > 0) {
            out.print(' ');
        }
    }

    protected void parseCommandLine(String[] args) {
        int ind = 0;
        if (args == null || args.length == 0) {
            args = new String[]{"-h"};
        }
        while (ind < args.length) {
            int newInd = ind;
            for (int i = 0; i < this.commandLineOpts.length && newInd == ind; ++i) {
                CommandLineOption a = this.commandLineOpts[i];
                newInd = a.parse(ind, args);
            }
            if (newInd == ind) {
                throw new IllegalArgumentException("Unknown switch: " + args[ind] + "\nTry -h for help.");
            }
            ind = newInd;
        }
    }
}

