/*
 * Decompiled with CFR 0.152.
 */
package polyglot.pth;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import polyglot.util.ErrorInfo;

public class ExpectedFailure {
    final Integer kind;
    final String errMsgRegExp;

    public ExpectedFailure(int kind) {
        this(kind, (String)null);
    }

    public ExpectedFailure(String errMsg) {
        this(null, errMsg);
    }

    public ExpectedFailure(int kind, String errMsg) {
        this(new Integer(kind), errMsg);
    }

    public ExpectedFailure(Integer kind, String errMsg) {
        this.kind = kind;
        this.errMsgRegExp = errMsg;
    }

    public boolean matches(ErrorInfo e) {
        if (this.kind != null && this.kind.intValue() != e.getErrorKind()) {
            return false;
        }
        if (this.errMsgRegExp != null) {
            Matcher m = Pattern.compile(this.errMsgRegExp).matcher(e.getMessage());
            return m.find();
        }
        return true;
    }

    public boolean equals(Object o) {
        if (o instanceof ExpectedFailure) {
            ExpectedFailure that = (ExpectedFailure)o;
            return (that.kind == this.kind || that.kind != null && that.kind.equals(this.kind)) && (that.errMsgRegExp == this.errMsgRegExp || that.errMsgRegExp != null && that.errMsgRegExp.equals(this.errMsgRegExp));
        }
        return false;
    }

    public int hashCode() {
        return (this.errMsgRegExp == null ? -323 : this.errMsgRegExp.hashCode()) + (this.kind == null ? 41 : this.kind.hashCode());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.kind != null) {
            sb.append(ErrorInfo.getErrorString((int)this.kind));
        } else {
            sb.append("error");
        }
        if (this.errMsgRegExp != null) {
            sb.append(" matching the regular expression '");
            sb.append(this.errMsgRegExp);
            sb.append('\'');
        }
        return sb.toString();
    }
}

