/*
 * Decompiled with CFR 0.152.
 */
package jif.visit;

import jif.ast.CanonicalLabelNode;
import jif.ast.JifUtil;
import jif.ast.Jif_c;
import jif.types.JifFieldInstance;
import jif.types.JifLocalInstance;
import jif.types.JifProcedureInstance;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.Solver;
import jif.types.VarMap;
import polyglot.ast.Call;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.FieldDecl;
import polyglot.ast.Formal;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.ProcedureDecl;
import polyglot.frontend.Job;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.ErrorQueue;
import polyglot.visit.ContextVisitor;
import polyglot.visit.NodeVisitor;

public class JifLabelSubst
extends ContextVisitor {
    protected JifTypeSystem ts;
    protected final Solver solver;
    protected ErrorQueue eq;
    protected VarMap bounds;

    public JifLabelSubst(Job job, JifTypeSystem ts, NodeFactory nf, Solver solver) {
        super(job, (TypeSystem)ts, nf);
        this.solver = solver;
        this.ts = ts;
        this.eq = job.compiler().errorQueue();
    }

    public Node leaveCall(Node old, Node n, NodeVisitor v) throws SemanticException {
        try {
            this.solve();
        }
        catch (SemanticException e) {
            this.eq.enqueue(5, e.getMessage(), e.position());
            return n;
        }
        n = this.updateNode(n);
        return n;
    }

    protected void solve() throws SemanticException {
        this.bounds = this.solver.solve();
    }

    protected Node updateNode(Node n) throws SemanticException {
        PathMap X;
        JifLocalInstance li;
        if (n instanceof ProcedureDecl) {
            JifProcedureInstance pi = (JifProcedureInstance)((ProcedureDecl)n).procedureInstance();
            pi.subst(this.bounds);
        }
        if (n instanceof FieldDecl) {
            JifFieldInstance fi = (JifFieldInstance)((FieldDecl)n).fieldInstance();
            fi.subst(this.bounds);
        }
        if (n instanceof LocalDecl) {
            li = (JifLocalInstance)((LocalDecl)n).localInstance();
            li.subst(this.bounds);
        }
        if (n instanceof Formal) {
            li = (JifLocalInstance)((Formal)n).localInstance();
            li.subst(this.bounds);
        }
        if (n instanceof Call) {
            Call c = (Call)n;
            MethodInstance mi = this.ts.findMethod(c.target().type().toReference(), c.methodInstance().name(), c.methodInstance().formalTypes(), c.target().type().toClass());
            n = c.methodInstance(mi);
        }
        if (JifUtil.jifExt(n) != null && (X = Jif_c.getPathMap(n)) != null) {
            n = Jif_c.updatePathMap(n, X.subst(this.bounds));
        }
        if (n instanceof CanonicalTypeNode) {
            CanonicalTypeNode tn = (CanonicalTypeNode)n;
            n = tn.type(this.bounds.applyTo(tn.type()));
        }
        if (n instanceof CanonicalLabelNode) {
            CanonicalLabelNode ln = (CanonicalLabelNode)n;
            n = ln.label(this.bounds.applyTo(ln.label()));
        }
        return n;
    }
}

