/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.Collections;
import java.util.Set;
import jif.types.JifTypeSystem;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.Label;
import jif.types.label.Label_c;
import jif.types.label.ThisLabel;
import polyglot.main.Report;
import polyglot.types.ReferenceType;
import polyglot.types.TypeObject;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class ThisLabel_c
extends Label_c
implements ThisLabel {
    private final ReferenceType ct;
    private final String fullName;

    public ThisLabel_c(JifTypeSystem ts, ReferenceType ct, Position pos) {
        super(ts, pos);
        this.ct = ct;
        if (ct.isClass()) {
            this.fullName = ct.toClass().fullName();
        } else if (ct.isArray()) {
            this.fullName = ct.toArray().base().toString() + "[]";
        } else {
            throw new InternalCompilerError("Only class types and arrays allowed");
        }
        this.setDescription("label of the special variable \"this\"");
    }

    public boolean isRuntimeRepresentable() {
        return false;
    }

    public boolean isCovariant() {
        return false;
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isCanonical() {
        return true;
    }

    public boolean isDisambiguatedImpl() {
        return true;
    }

    public boolean isEnumerable() {
        return true;
    }

    public ReferenceType classType() {
        return this.ct;
    }

    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ThisLabel)) {
            return false;
        }
        ThisLabel that = (ThisLabel)o;
        return this.ct.equals(that.classType());
    }

    public int hashCode() {
        return this.fullName.hashCode();
    }

    public String componentString(Set printedLabels) {
        if (Report.should_report((String)"debug", (int)2)) {
            return "<this (of " + this.fullName + ")>";
        }
        if (Report.should_report((String)"debug", (int)1)) {
            return "<this (of " + this.fullName + ")>";
        }
        return "this";
    }

    public boolean leq_(Label L, LabelEnv env, LabelEnv.SearchState state) {
        return false;
    }

    public Set variables() {
        return Collections.EMPTY_SET;
    }
}

