/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import jif.translate.LabelToJavaExpr;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.ConfPolicy;
import jif.types.label.IntegPolicy;
import jif.types.label.Label;
import jif.types.label.Label_c;
import jif.types.label.PairLabel;
import jif.visit.LabelChecker;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.Position;

public class PairLabel_c
extends Label_c
implements PairLabel {
    private final ConfPolicy confPolicy;
    private final IntegPolicy integPolicy;

    public PairLabel_c(JifTypeSystem ts, ConfPolicy confPolicy, IntegPolicy integPolicy, Position pos, LabelToJavaExpr trans) {
        super(ts, pos, trans);
        this.confPolicy = confPolicy;
        this.integPolicy = integPolicy;
    }

    public ConfPolicy confPolicy() {
        return this.confPolicy;
    }

    public IntegPolicy integPolicy() {
        return this.integPolicy;
    }

    public boolean isRuntimeRepresentable() {
        return this.confPolicy.isRuntimeRepresentable() && this.integPolicy.isRuntimeRepresentable();
    }

    public boolean isCovariant() {
        return false;
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isCanonical() {
        return this.confPolicy.isCanonical() && this.integPolicy.isCanonical();
    }

    public boolean isEnumerable() {
        return true;
    }

    protected boolean isDisambiguatedImpl() {
        return this.isCanonical();
    }

    public boolean isBottom() {
        return this.confPolicy.isBottom() && this.integPolicy.isBottom();
    }

    public boolean isTop() {
        return this.confPolicy.isTop() && this.integPolicy.isTop();
    }

    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PairLabel_c)) {
            return false;
        }
        PairLabel_c that = (PairLabel_c)o;
        return this.confPolicy.equals(that.confPolicy) && this.integPolicy.equals(that.integPolicy);
    }

    protected Label simplifyImpl() {
        ConfPolicy cp = (ConfPolicy)this.confPolicy.simplify();
        IntegPolicy ip = (IntegPolicy)this.integPolicy.simplify();
        if (cp != this.confPolicy || ip != this.integPolicy) {
            return ((JifTypeSystem)this.ts).pairLabel(this.position, cp, ip);
        }
        return this;
    }

    public ConfPolicy confProjection() {
        return this.confPolicy();
    }

    public IntegPolicy integProjection() {
        return this.integPolicy();
    }

    public int hashCode() {
        return this.confPolicy.hashCode() ^ this.integPolicy.hashCode();
    }

    public String toString() {
        return this.toString(new HashSet());
    }

    public String toString(Set printedLabels) {
        return this.toString(printedLabels, true);
    }

    public String componentString(Set printedLabels) {
        return this.toString(printedLabels, false);
    }

    public String toString(Set printedLabels, boolean topLevel) {
        StringBuffer sb = new StringBuffer();
        if (topLevel) {
            sb.append("{");
        }
        if (Report.should_report((String)"debug", (int)2)) {
            sb.append("<pair " + this.confPolicy.toString(printedLabels) + " ; " + this.integPolicy.toString(printedLabels) + ">");
        } else if (Report.should_report((String)"debug", (int)1)) {
            sb.append(this.confPolicy.toString(printedLabels) + "; " + this.integPolicy.toString(printedLabels));
        } else {
            String cs = "";
            if (!topLevel || !this.confPolicy.isBottomConfidentiality()) {
                cs = this.confPolicy.toString(printedLabels);
            }
            String is = "";
            if (!topLevel || !this.integPolicy.isTopIntegrity()) {
                is = this.integPolicy.toString(printedLabels);
            }
            if (cs.length() > 0 && is.length() > 0) {
                sb.append(cs + "; " + is);
            } else {
                sb.append(cs + is);
            }
        }
        if (topLevel) {
            sb.append("}");
        }
        return sb.toString();
    }

    public boolean leq_(Label L, LabelEnv env, LabelEnv.SearchState state) {
        if (L instanceof PairLabel) {
            PairLabel that = (PairLabel)L;
            return env.leq(this.confPolicy(), that.confPolicy(), state) && env.leq(this.integPolicy(), that.integPolicy(), state);
        }
        return false;
    }

    public Label subst(LabelSubstitution substitution) throws SemanticException {
        PairLabel lbl = this;
        if (substitution.recurseIntoChildren(lbl)) {
            ConfPolicy newCP = (ConfPolicy)lbl.confPolicy().subst(substitution);
            IntegPolicy newIP = (IntegPolicy)lbl.integPolicy().subst(substitution);
            if (newCP != this.confPolicy || newIP != this.integPolicy) {
                lbl = ((JifTypeSystem)this.ts).pairLabel(this.position, newCP, newIP);
            }
        }
        return substitution.substLabel(lbl);
    }

    public Set variables() {
        return Collections.EMPTY_SET;
    }

    public List throwTypes(TypeSystem ts) {
        ArrayList throwTypes = new ArrayList();
        throwTypes.addAll(this.confPolicy.throwTypes(ts));
        throwTypes.addAll(this.integPolicy.throwTypes(ts));
        return throwTypes;
    }

    public boolean hasWritersToReaders() {
        return this.confPolicy.hasWritersToReaders() || this.integPolicy.hasWritersToReaders();
    }

    public PathMap labelCheck(JifContext A, LabelChecker lc) {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        PathMap X = ts.pathMap().N(A.pc()).NV(A.pc());
        A = (JifContext)A.pushBlock();
        PathMap Xc = this.confPolicy.labelCheck(A, lc);
        X = X.join(Xc);
        A.setPc(X.N(), lc);
        PathMap Xi = this.integPolicy.labelCheck(A, lc);
        X = X.join(Xi);
        return X;
    }
}

