/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.Set;
import jif.types.JifConstructorInstance;
import jif.types.JifMethodInstance;
import jif.types.JifProcedureInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import jif.types.label.Label_c;
import polyglot.main.Report;
import polyglot.types.CodeInstance;
import polyglot.types.ProcedureInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeObject;
import polyglot.types.VarInstance;
import polyglot.util.Position;

public class ArgLabel_c
extends Label_c
implements ArgLabel {
    private final VarInstance vi;
    private CodeInstance ci;
    private String name;
    private Label upperBound;

    protected ArgLabel_c() {
        this.vi = null;
        this.ci = null;
        this.name = null;
    }

    public ArgLabel_c(JifTypeSystem ts, VarInstance vi, CodeInstance ci, Position pos) {
        super(ts, pos);
        this.vi = vi;
        this.ci = ci;
        this.name = vi.name();
        this.setDescription();
    }

    public ArgLabel_c(JifTypeSystem ts, ProcedureInstance pi, String name, Position pos) {
        super(ts, pos);
        this.vi = null;
        this.ci = pi;
        this.name = name;
    }

    private void setDescription() {
        if (this.vi != null) {
            StringBuffer sb = new StringBuffer();
            sb.append("polymorphic label of formal argument ");
            sb.append(this.vi.name());
            if (this.ci instanceof JifProcedureInstance) {
                sb.append(" of ");
                if (this.ci instanceof JifMethodInstance) {
                    sb.append("method ");
                    sb.append(((JifMethodInstance)this.ci).name());
                } else if (this.ci instanceof JifConstructorInstance) {
                    sb.append("constructor");
                } else {
                    sb.append(((JifProcedureInstance)this.ci).debugString());
                }
            }
            sb.append(" (bounded above by ");
            sb.append(this.upperBound);
            sb.append(")");
            this.setDescription(sb.toString());
        }
    }

    public VarInstance formalInstance() {
        return this.vi;
    }

    public Label upperBound() {
        return this.upperBound;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setUpperBound(Label upperBound) {
        this.upperBound = upperBound;
        this.setDescription();
    }

    public void setCodeInstance(CodeInstance ci) {
        this.ci = ci;
    }

    public boolean isRuntimeRepresentable() {
        return false;
    }

    public boolean isCovariant() {
        return false;
    }

    public boolean isComparable() {
        return true;
    }

    public boolean isCanonical() {
        return true;
    }

    public boolean isEnumerable() {
        return true;
    }

    protected boolean isDisambiguatedImpl() {
        return this.upperBound != null;
    }

    public boolean equalsImpl(TypeObject o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArgLabel_c)) {
            return false;
        }
        ArgLabel_c that = (ArgLabel_c)o;
        return (this.ci == that.ci || this.ci != null && this.ci.equals(that.ci)) && (this.vi == that.vi || this.vi != null && this.vi.equals(that.vi)) && this.name.equals(that.name);
    }

    public int hashCode() {
        return (this.vi == null ? 234 : this.vi.hashCode()) ^ 0x23CF82;
    }

    public String componentString(Set printedLabels) {
        if (printedLabels.contains(this)) {
            if (Report.should_report((String)"debug", (int)2)) {
                return "<arg " + this.nicename() + ">";
            }
            if (Report.should_report((String)"debug", (int)1)) {
                return "<arg " + this.name + ">";
            }
            return this.nicename();
        }
        printedLabels.add(this);
        if (Report.should_report((String)"debug", (int)2)) {
            String ub = this.upperBound == null ? "-" : this.upperBound.toString(printedLabels);
            return "<arg " + this.name + " " + ub + ">";
        }
        if (Report.should_report((String)"debug", (int)1)) {
            String ub = this.upperBound == null ? "-" : this.upperBound.toString(printedLabels);
            return "<arg " + this.nicename() + " " + ub + ">";
        }
        return this.nicename();
    }

    private String nicename() {
        return this.vi == null ? this.name : this.vi.name();
    }

    public boolean leq_(Label L, LabelEnv env, LabelEnv.SearchState state) {
        return false;
    }

    public Label subst(LabelSubstitution substitution) throws SemanticException {
        ArgLabel lbl = this;
        if (substitution.recurseIntoChildren(lbl) && !substitution.stackContains(this) && lbl.upperBound() != null) {
            substitution.pushLabel(this);
            Label newBound = lbl.upperBound().subst(substitution);
            if (newBound != lbl.upperBound()) {
                lbl = (ArgLabel)lbl.copy();
                lbl.setUpperBound(newBound);
            }
            substitution.popLabel(this);
        }
        return substitution.substLabel(lbl);
    }

    public String description() {
        this.setDescription();
        return super.description();
    }
}

