/*
 * Decompiled with CFR 0.152.
 */
package jif.types.label;

import java.util.ArrayList;
import java.util.List;
import jif.ast.JifInstantiator;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathRoot;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class AccessPathField
extends AccessPath {
    protected FieldInstance fi;
    protected String fieldName;
    protected final AccessPath path;
    private boolean neverNull = false;

    public AccessPathField(AccessPath path, FieldInstance fi, String fieldName, Position pos) {
        super(pos);
        this.fi = fi;
        this.path = path;
        this.fieldName = fieldName;
        if (fi != null && !fieldName.equals(fi.name())) {
            throw new InternalCompilerError("Inconsistent field names");
        }
    }

    public boolean isNeverNull() {
        return this.neverNull;
    }

    public void setIsNeverNull() {
        this.neverNull = true;
    }

    public boolean isCanonical() {
        return this.path.isCanonical();
    }

    public boolean isUninterpreted() {
        return this.path.isUninterpreted();
    }

    public AccessPath subst(AccessPathRoot r, AccessPath e) {
        AccessPath newPath = this.path.subst(r, e);
        if (newPath == this.path) {
            return this;
        }
        return new AccessPathField(newPath, this.fi, this.fieldName, this.position());
    }

    public final AccessPathRoot root() {
        return this.path.root();
    }

    public String toString() {
        return this.path + "." + this.fieldName;
    }

    public String exprString() {
        return this.path.exprString() + "." + this.fieldName;
    }

    public AccessPath path() {
        return this.path;
    }

    public FieldInstance fieldInstance() {
        return this.fi;
    }

    public boolean equals(Object o) {
        if (o instanceof AccessPathField) {
            AccessPathField that = (AccessPathField)o;
            return this.fieldName.equals(that.fieldName) && this.path.equals(that.path);
        }
        return false;
    }

    public int hashCode() {
        return this.path.hashCode() + this.fieldName.hashCode();
    }

    public Type type() {
        if (this.fi == null) {
            return null;
        }
        return this.fi.type();
    }

    public PathMap labelcheck(JifContext A, LabelChecker lc) {
        PathMap Xt = this.path.labelcheck(A, lc);
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        PathMap X = Xt;
        if (!this.isTargetNeverNull()) {
            X = Xt.exc(Xt.NV(), (Type)ts.NullPointerException());
        }
        Label L = ts.labelOfField(this.fi, A.pc());
        L = JifInstantiator.instantiate(L, A, this.path, this.path.type().toReference(), Xt.NV());
        X = X.NV(lc.upperBound(L, X.NV()));
        return X;
    }

    protected boolean isTargetNeverNull() {
        return this.path.isNeverNull();
    }

    public void verify(JifContext A) throws SemanticException {
        this.path.verify(A);
        if (!this.path.type().isReference()) {
            throw new SemanticException("Expression " + this.path + " used in final access path is not a reference type", this.position());
        }
        FieldInstance found = A.typeSystem().findField(this.path.type().toReference(), this.fieldName);
        if (this.fi == null || !this.fi.isCanonical()) {
            this.fi = found;
        } else if (!this.fi.equals(found)) {
            throw new InternalCompilerError("Unexpected field instance for name " + this.fieldName + ": original was " + this.fi + "; found was " + found);
        }
        if (this.fi == null) {
            throw new SemanticException("Field " + this.fieldName + " cannot be found in class " + this.path.type(), this.position());
        }
        if (!this.fi.flags().isFinal()) {
            throw new SemanticException("Field " + this.fi.name() + " in access path is not final", this.position());
        }
    }

    public List throwTypes(TypeSystem ts) {
        List l = this.path.throwTypes(ts);
        if (this.isTargetNeverNull()) {
            return l;
        }
        ArrayList<ClassType> throwTypes = new ArrayList<ClassType>(l.size() + 1);
        throwTypes.addAll(l);
        throwTypes.add(ts.NullPointerException());
        return throwTypes;
    }

    public boolean equivalentTo(AccessPath p, LabelEnv env) {
        if (p instanceof AccessPathField) {
            AccessPathField apf = (AccessPathField)p;
            if (this.fieldInstance().equals(apf.fieldInstance())) {
                return env.equivalentAccessPaths(this.path(), apf.path());
            }
        }
        return false;
    }
}

