/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import jif.types.AbstractSolver;
import jif.types.Equation;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.LabelEquation;
import jif.types.PrincipalConstraint;
import jif.types.PrincipalEquation;
import jif.types.VarMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.ConfPolicy;
import jif.types.label.IntegPolicy;
import jif.types.label.JoinLabel;
import jif.types.label.JoinPolicy_c;
import jif.types.label.Label;
import jif.types.label.MeetLabel;
import jif.types.label.MeetPolicy_c;
import jif.types.label.PairLabel;
import jif.types.label.VarLabel;
import jif.types.label.Variable;
import jif.types.principal.Principal;
import jif.types.principal.VarPrincipal;
import polyglot.frontend.Compiler;
import polyglot.types.SemanticException;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class SolverGLB
extends AbstractSolver {
    public SolverGLB(JifTypeSystem ts, Compiler compiler, String solverName) {
        super(ts, compiler, solverName);
    }

    protected SolverGLB(SolverGLB js) {
        super(js);
    }

    protected void addDependencies(Equation eqn) {
        Set awakeable;
        Set changeable;
        if (eqn instanceof LabelEquation) {
            changeable = ((LabelEquation)eqn).rhs().variableComponents();
            awakeable = ((LabelEquation)eqn).lhs().variableComponents();
        } else if (eqn instanceof PrincipalEquation) {
            changeable = ((PrincipalEquation)eqn).lhs().variables();
            awakeable = ((PrincipalEquation)eqn).rhs().variables();
        } else {
            throw new InternalCompilerError("Unexpected kind of equation " + eqn);
        }
        for (Variable v : changeable) {
            this.addDependency(eqn, v);
        }
        for (Variable v : awakeable) {
            this.addDependency(v, eqn);
        }
    }

    protected Label getDefaultLabelBound() {
        return this.ts.bottomLabel();
    }

    protected Principal getDefaultPrincipalBound() {
        return this.ts.bottomPrincipal(Position.COMPILER_GENERATED);
    }

    protected void solve_eqn(LabelEquation eqn) throws SemanticException {
        if (!eqn.rhs().hasVariableComponents()) {
            this.checkEquation(eqn);
            return;
        }
        ArrayList rhsVariables = new ArrayList(eqn.rhs().variableComponents());
        boolean isSingleVar = rhsVariables.size() == 1;
        VarLabel singleVar = null;
        if (isSingleVar) {
            singleVar = (VarLabel)rhsVariables.get(0);
        }
        if (isSingleVar && (!this.isFixedValueVar(singleVar) || eqn.constraint().kind() == LabelConstraint.EQUAL)) {
            this.refineVariableEquation(singleVar, eqn);
        } else {
            if (!isSingleVar && !this.allActivesAreMultiVarRHS()) {
                if (SolverGLB.shouldReport(3)) {
                    SolverGLB.report(3, "Deferring multi var RHS constraint");
                }
                this.addEquationToQueue(eqn);
                return;
            }
            VarMap origBounds = this.bounds().copy();
            for (VarLabel comp : rhsVariables) {
                if (this.isFixedValueVar(comp) && eqn.constraint().kind() != LabelConstraint.EQUAL) continue;
                this.refineVariableEquation(comp, eqn);
                Label lhsbound = this.triggerTransforms(this.bounds().applyTo(eqn.lhs()), eqn.env());
                Label rhsbound = this.triggerTransforms(this.bounds().applyTo(eqn.rhs()), eqn.env());
                if (eqn.env().leq(lhsbound, rhsbound) && this.search(eqn)) {
                    return;
                }
                this.setBounds(origBounds);
            }
            if (SolverGLB.shouldReport(1)) {
                SolverGLB.report(1, "Search for refinement to constraint " + eqn + " failed.");
            }
            this.reportError(eqn.labelConstraint(), eqn.variableComponents());
        }
    }

    protected void solve_eqn(PrincipalEquation eqn) throws SemanticException {
        if (!eqn.lhs().hasVariables()) {
            this.checkEquation(eqn);
            return;
        }
        ArrayList lhsVariables = new ArrayList(eqn.lhs().variables());
        boolean isSingleVar = lhsVariables.size() == 1;
        VarPrincipal singleVar = null;
        if (isSingleVar) {
            singleVar = (VarPrincipal)lhsVariables.get(0);
        }
        if (isSingleVar && (!this.isFixedValueVar(singleVar) || eqn.constraint().kind() == PrincipalConstraint.EQUIV)) {
            this.refineVariableEquation(singleVar, eqn);
        } else {
            VarMap origBounds = this.bounds().copy();
            for (VarPrincipal comp : lhsVariables) {
                if (this.isFixedValueVar(comp)) continue;
                this.refineVariableEquation(comp, eqn);
                Principal lhsbound = this.bounds().applyTo(eqn.lhs());
                Principal rhsbound = this.bounds().applyTo(eqn.rhs());
                if (eqn.env().actsFor(lhsbound, rhsbound) && this.search(eqn)) {
                    return;
                }
                this.setBounds(origBounds);
            }
            if (SolverGLB.shouldReport(1)) {
                SolverGLB.report(1, "Search for refinement to constraint " + eqn + " failed.");
            }
            this.reportError(eqn.constraint(), eqn.variables());
        }
    }

    protected boolean allActivesAreMultiVarRHS() {
        for (Equation eqn : this.getQueue()) {
            if (!(eqn instanceof LabelEquation) || ((LabelEquation)eqn).rhs().variableComponents().size() > 1) continue;
            return false;
        }
        return true;
    }

    protected void refineVariableEquation(VarLabel v, LabelEquation eqn) throws SemanticException {
        Label vBound = this.bounds().boundOf(v);
        Label lhsBound = this.triggerTransforms(this.bounds().applyTo(eqn.lhs()), eqn.env());
        Label rhsBound = this.triggerTransforms(this.bounds().applyTo(eqn.rhs()), eqn.env());
        if (SolverGLB.shouldReport(5)) {
            SolverGLB.report(5, "BOUND of " + v + " = " + vBound);
        }
        if (SolverGLB.shouldReport(5)) {
            SolverGLB.report(5, "RHSBOUND = " + rhsBound);
        }
        if (SolverGLB.shouldReport(5)) {
            SolverGLB.report(5, "LHSBOUND = " + lhsBound);
        }
        Label needed = this.findNeeded(lhsBound, rhsBound, eqn.env());
        if (SolverGLB.shouldReport(5)) {
            SolverGLB.report(4, "NEEDED = " + needed);
        }
        Label newBound = this.ts.join(vBound, needed);
        if (SolverGLB.shouldReport(4)) {
            SolverGLB.report(4, "JOIN (" + v + ", NEEDED) := " + newBound);
        }
        if (v.mustRuntimeRepresentable() && !newBound.isRuntimeRepresentable()) {
            Label rtRep = eqn.env().findNonArgLabelUpperBound(newBound);
            if (SolverGLB.shouldReport(4)) {
                SolverGLB.report(4, "RUNTIME_REPR (" + newBound + ") := " + rtRep);
            }
            newBound = rtRep;
        }
        this.addTrace(v, eqn, newBound);
        this.setBound(v, newBound, eqn.labelConstraint());
        this.wakeUp(v);
    }

    protected void refineVariableEquation(VarPrincipal v, PrincipalEquation eqn) throws SemanticException {
        Principal vBound = this.bounds().boundOf(v);
        Principal lhsBound = this.bounds().applyTo(eqn.lhs());
        Principal rhsBound = this.bounds().applyTo(eqn.rhs());
        if (SolverGLB.shouldReport(5)) {
            SolverGLB.report(5, "BOUND of " + v + " = " + vBound);
        }
        if (SolverGLB.shouldReport(5)) {
            SolverGLB.report(5, "RHSBOUND = " + rhsBound);
        }
        if (SolverGLB.shouldReport(5)) {
            SolverGLB.report(5, "LHSBOUND = " + lhsBound);
        }
        Principal newBound = this.ts.conjunctivePrincipal(vBound.position(), vBound, rhsBound).simplify();
        if (SolverGLB.shouldReport(4)) {
            SolverGLB.report(4, "CONJUNCT (" + v + ", NEEDED) := " + newBound);
        }
        this.setBound(v, newBound, eqn.principalConstraint());
        this.wakeUp(v);
    }

    protected Label findNeeded(Label lhs, Label rhs, LabelEnv env) {
        if (lhs instanceof JoinLabel) {
            JoinLabel jl = (JoinLabel)lhs;
            LinkedHashSet<Label> needed = new LinkedHashSet<Label>();
            for (Label ci : jl.joinComponents()) {
                if (env.leq(ci, rhs)) continue;
                needed.add(this.findNeeded(ci, rhs, env));
            }
            return this.ts.joinLabel(lhs.position(), needed);
        }
        if (lhs instanceof MeetLabel) {
            MeetLabel ml = (MeetLabel)lhs;
            LinkedHashSet<Label> needed = new LinkedHashSet<Label>();
            for (Label ci : ml.meetComponents()) {
                needed.add(this.findNeeded(ci, rhs, env));
            }
            return this.ts.meetLabel(lhs.position(), needed);
        }
        if (lhs instanceof PairLabel) {
            PairLabel pl = (PairLabel)lhs;
            ConfPolicy cp = this.findNeeded(pl.confPolicy(), this.ts.confProjection(rhs), env);
            IntegPolicy ip = this.findNeeded(pl.integPolicy(), this.ts.integProjection(rhs), env);
            return this.ts.pairLabel(lhs.position(), cp, ip);
        }
        return lhs;
    }

    protected ConfPolicy findNeeded(ConfPolicy lhs, ConfPolicy rhs, LabelEnv env) {
        if (lhs instanceof JoinPolicy_c) {
            JoinPolicy_c jp = (JoinPolicy_c)((Object)lhs);
            LinkedHashSet<ConfPolicy> needed = new LinkedHashSet<ConfPolicy>();
            for (ConfPolicy ci : jp.joinComponents()) {
                if (env.leq(ci, rhs)) continue;
                needed.add(this.findNeeded(ci, rhs, env));
            }
            return this.ts.joinConfPolicy(lhs.position(), needed);
        }
        if (lhs instanceof MeetPolicy_c) {
            MeetPolicy_c mp = (MeetPolicy_c)((Object)lhs);
            LinkedHashSet<ConfPolicy> needed = new LinkedHashSet<ConfPolicy>();
            for (ConfPolicy ci : mp.meetComponents()) {
                needed.add(this.findNeeded(ci, rhs, env));
            }
            return this.ts.meetConfPolicy(lhs.position(), needed);
        }
        return lhs;
    }

    protected IntegPolicy findNeeded(IntegPolicy lhs, IntegPolicy rhs, LabelEnv env) {
        if (lhs instanceof JoinPolicy_c) {
            JoinPolicy_c jp = (JoinPolicy_c)((Object)lhs);
            LinkedHashSet<IntegPolicy> needed = new LinkedHashSet<IntegPolicy>();
            for (IntegPolicy ci : jp.joinComponents()) {
                if (env.leq(ci, rhs)) continue;
                needed.add(this.findNeeded(ci, rhs, env));
            }
            return this.ts.joinIntegPolicy(lhs.position(), needed);
        }
        if (lhs instanceof MeetPolicy_c) {
            MeetPolicy_c mp = (MeetPolicy_c)((Object)lhs);
            LinkedHashSet<IntegPolicy> needed = new LinkedHashSet<IntegPolicy>();
            for (IntegPolicy ci : mp.meetComponents()) {
                needed.add(this.findNeeded(ci, rhs, env));
            }
            return this.ts.meetIntegPolicy(lhs.position(), needed);
        }
        return lhs;
    }

    protected boolean search(Equation eqn) {
        if (SolverGLB.shouldReport(2)) {
            SolverGLB.report(2, "===== Starting recursive search =====");
        }
        SolverGLB js = new SolverGLB(this);
        js.addEquationToQueueHead(eqn);
        try {
            this.setBounds(js.solve_bounds());
            if (SolverGLB.shouldReport(2)) {
                SolverGLB.report(2, "Solution succeeded, finishing up");
            }
            return true;
        }
        catch (SemanticException dummy) {
            if (SolverGLB.shouldReport(2)) {
                SolverGLB.report(2, "Solution failed, backtracking");
            }
            return false;
        }
    }

    protected void checkEquation(LabelEquation eqn) throws SemanticException {
        if (eqn.rhs().hasVariableComponents()) {
            throw new InternalCompilerError("RHS of equation " + eqn + " should not contain variables.");
        }
        Label rhsLabel = this.triggerTransforms(this.bounds().applyTo(eqn.rhs()), eqn.env());
        if (SolverGLB.shouldReport(4)) {
            SolverGLB.report(4, "RHS = " + rhsLabel);
        }
        Label lhsBound = this.triggerTransforms(this.bounds().applyTo(eqn.lhs()), eqn.env());
        if (SolverGLB.shouldReport(4)) {
            SolverGLB.report(4, "LHS APP = " + lhsBound);
        }
        if (!eqn.env().leq(lhsBound, rhsLabel)) {
            this.reportError(eqn.labelConstraint(), eqn.variableComponents());
        }
    }

    protected void checkEquation(PrincipalEquation eqn) throws SemanticException {
        if (eqn.lhs().hasVariables()) {
            throw new InternalCompilerError("LHS of equation " + eqn + " should not contain variables.");
        }
        Principal rhsBound = this.bounds().applyTo(eqn.rhs());
        if (SolverGLB.shouldReport(4)) {
            SolverGLB.report(4, "RHS = " + rhsBound);
        }
        Principal lhsBound = this.bounds().applyTo(eqn.lhs());
        if (SolverGLB.shouldReport(4)) {
            SolverGLB.report(4, "LHS APP = " + lhsBound);
        }
        if (!eqn.env().actsFor(lhsBound, rhsBound)) {
            this.reportError(eqn.constraint(), eqn.variables());
        }
    }

    protected Equation findContradictiveEqn(LabelConstraint c) {
        if (c.lhsLabel().variableComponents().size() == 1) {
            VarLabel v = (VarLabel)c.lhsLabel().variableComponents().iterator().next();
            return this.findTrace(v, this.bounds().applyTo(c.rhsLabel()), false);
        }
        return null;
    }
}

