/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.LinkedHashMap;
import java.util.Map;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.util.Position;

public class NamedLabel {
    protected Map nameToLabels = new LinkedHashMap();
    protected Map nameToDescrip = new LinkedHashMap();
    protected String totalName;
    protected Label label = null;
    protected Position pos;

    public NamedLabel() {
        this(null);
    }

    public NamedLabel(String name, Label l) {
        this(name, null, l);
    }

    public NamedLabel(String name, String descrip, Label l) {
        this(l.position());
        this.nameToLabels.put(name, l);
        if (descrip != null) {
            this.nameToDescrip.put(name, descrip);
        }
        this.label = l;
        if (this.pos == null) {
            this.pos = l.position();
        }
        this.totalName = name;
    }

    public NamedLabel(Position pos) {
        this.pos = pos;
    }

    public Position position() {
        return this.pos;
    }

    public NamedLabel join(LabelChecker lc, String name, Label l) {
        return this.join(lc, name, null, l);
    }

    public NamedLabel join(LabelChecker lc, String name, String descrip, Label l) {
        this.nameToLabels.put(name, l);
        if (descrip != null) {
            this.nameToDescrip.put(name, descrip);
        }
        if (this.label == null) {
            this.label = l;
            if (this.pos == null) {
                this.pos = l.position();
            }
            this.totalName = name;
        } else {
            this.label = lc.upperBound(this.label, l);
            this.totalName = this.totalName + " join " + name;
        }
        return this;
    }

    public NamedLabel meet(LabelChecker lc, String name, Label l) {
        return this.meet(lc, name, null, l);
    }

    public NamedLabel meet(LabelChecker lc, String name, String descrip, Label l) {
        this.nameToLabels.put(name, l);
        if (descrip != null) {
            this.nameToDescrip.put(name, descrip);
        }
        if (this.label == null) {
            this.label = l;
            if (this.pos == null) {
                this.pos = l.position();
            }
            this.totalName = name;
        } else {
            this.label = lc.lowerBound(this.label, l);
            this.totalName = this.totalName + " meet " + name;
        }
        return this;
    }

    public Label label() {
        return this.label;
    }

    public String toString() {
        return this.totalName;
    }

    public Label label(String name) {
        return (Label)this.nameToLabels.get(name);
    }

    public String name() {
        return this.totalName;
    }
}

