/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import jif.types.Equation;
import jif.types.LabelConstraint;
import jif.types.LabelSubstitution;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.JoinLabel;
import jif.types.label.Label;
import jif.types.label.MeetLabel;
import polyglot.types.SemanticException;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class LabelEquation
extends Equation {
    private Label lhs;
    private Label rhs;

    LabelEquation(Label lhs, Label rhs, LabelConstraint constraint) {
        super(constraint);
        this.lhs = lhs;
        this.rhs = rhs.simplify();
        if (lhs instanceof JoinLabel) {
            throw new InternalCompilerError("LHS of equation must not be a join label.");
        }
        if (rhs instanceof MeetLabel) {
            throw new InternalCompilerError("LHS of equation must not be a meet label.");
        }
    }

    public Label lhs() {
        return this.lhs;
    }

    public Label rhs() {
        return this.rhs;
    }

    public LabelEnv env() {
        return this.constraint().env();
    }

    public Position position() {
        return this.constraint().position();
    }

    public LabelConstraint labelConstraint() {
        return (LabelConstraint)this.constraint;
    }

    public List variableComponents() {
        LinkedList l = new LinkedList();
        l.addAll(this.lhs.variableComponents());
        l.addAll(this.rhs.variableComponents());
        return l;
    }

    public Set variables() {
        LinkedHashSet l = new LinkedHashSet();
        l.addAll(this.lhs.variables());
        l.addAll(this.rhs.variables());
        return l;
    }

    public int hashCode() {
        return this.lhs.hashCode() ^ this.rhs.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LabelEquation)) {
            return false;
        }
        LabelEquation eqn = (LabelEquation)o;
        if (this.constraint != eqn.constraint) {
            return false;
        }
        return this.lhs.equals(eqn.lhs) && this.rhs.equals(eqn.rhs);
    }

    public String toString() {
        return this.lhs.toString() + " <= " + this.rhs.toString() + " in environment " + this.env() + " (produced from " + this.labelConstraint().lhsLabel() + (Object)((Object)this.labelConstraint().kind()) + this.labelConstraint().rhsLabel() + ") " + this.position();
    }

    public void subst(LabelSubstitution subst) throws SemanticException {
        this.rhs = this.rhs.subst(subst);
        this.lhs = this.lhs.subst(subst);
    }
}

