/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jif.types.Assertion;
import jif.types.JifMethodInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelSubstitution;
import jif.types.TypeSubstitutor;
import jif.types.VarMap;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import polyglot.main.Report;
import polyglot.types.Flags;
import polyglot.types.MethodInstance_c;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.Position;
import polyglot.util.TypedList;

public class JifMethodInstance_c
extends MethodInstance_c
implements JifMethodInstance {
    protected Label pcBound;
    protected Label returnLabel;
    protected List constraints;
    protected boolean isDefaultPCBound;
    protected boolean isDefaultReturnLabel;

    public JifMethodInstance_c(JifTypeSystem ts, Position pos, ReferenceType container, Flags flags, Type returnType, String name, Label pcBound, boolean isDefaultPCBound, List formalTypes, List formalArgLabels, Label returnLabel, boolean isDefaultReturnLabel, List excTypes, List constraints) {
        super((TypeSystem)ts, pos, container, flags, returnType, name, formalTypes, excTypes);
        this.constraints = TypedList.copyAndCheck((List)constraints, Assertion.class, (boolean)true);
        this.pcBound = pcBound;
        this.isDefaultPCBound = isDefaultPCBound;
        this.returnLabel = returnLabel;
        this.isDefaultReturnLabel = isDefaultReturnLabel;
        this.throwTypes = TypedList.copyAndCheck((List)this.throwTypes, Type.class, (boolean)true);
        this.formalTypes = TypedList.copyAndCheck((List)formalTypes, Type.class, (boolean)true);
    }

    public Label pcBound() {
        return this.pcBound;
    }

    public void setPCBound(Label pcBound, boolean isDefault) {
        this.pcBound = pcBound;
        this.isDefaultPCBound = isDefault;
    }

    public boolean isDefaultPCBound() {
        return this.isDefaultPCBound;
    }

    public Label returnLabel() {
        return this.returnLabel;
    }

    public void setReturnLabel(Label returnLabel, boolean isDefault) {
        this.returnLabel = returnLabel;
        this.isDefaultReturnLabel = isDefault;
    }

    public boolean isDefaultReturnLabel() {
        return this.isDefaultReturnLabel;
    }

    public Label returnValueLabel() {
        JifTypeSystem jts = (JifTypeSystem)this.ts;
        if (this.returnType.isVoid()) {
            return jts.notTaken();
        }
        return jts.labelOfType(this.returnType);
    }

    public List constraints() {
        return this.constraints;
    }

    public void setConstraints(List constraints) {
        this.constraints = TypedList.copyAndCheck((List)constraints, Assertion.class, (boolean)true);
    }

    public String toString() {
        Type t;
        String s = "method " + this.flags.translate() + this.returnType + " " + this.name;
        if (this.pcBound != null) {
            s = s + this.pcBound.toString();
        }
        s = s + "(";
        Iterator i = this.formalTypes.iterator();
        while (i.hasNext()) {
            t = (Type)i.next();
            s = s + t.toString();
            if (!i.hasNext()) continue;
            s = s + ", ";
        }
        s = s + ")";
        if (this.returnLabel != null) {
            s = s + " : " + this.returnLabel.toString();
        }
        if (!this.throwTypes.isEmpty()) {
            s = s + " throws (";
            i = this.throwTypes.iterator();
            while (i.hasNext()) {
                t = (Type)i.next();
                s = s + t.toString();
                if (!i.hasNext()) continue;
                s = s + ", ";
            }
            s = s + ")";
        }
        if (!this.constraints.isEmpty()) {
            s = s + " where ";
            i = this.constraints.iterator();
            while (i.hasNext()) {
                Assertion c = (Assertion)i.next();
                s = s + c.toString();
                if (!i.hasNext()) continue;
                s = s + ", ";
            }
        }
        return s;
    }

    public boolean isCanonical() {
        if (!(super.isCanonical() && this.pcBound.isCanonical() && this.returnLabel.isCanonical() && this.listIsCanonical(this.constraints) && this.formalTypes != null)) {
            return false;
        }
        JifTypeSystem jts = (JifTypeSystem)this.typeSystem();
        for (Type t : this.formalTypes()) {
            if (jts.isLabeled(t) && jts.labelOfType(t) instanceof ArgLabel) continue;
            return false;
        }
        return true;
    }

    public void subst(VarMap bounds) {
        this.pcBound = bounds.applyTo(this.pcBound);
        this.returnLabel = bounds.applyTo(this.returnLabel);
        this.returnType = bounds.applyTo(this.returnType);
        LinkedList<Type> formalTypes = new LinkedList<Type>();
        for (Type t : this.formalTypes()) {
            formalTypes.add(bounds.applyTo(t));
        }
        this.setFormalTypes(formalTypes);
        LinkedList<Type> throwTypes = new LinkedList<Type>();
        for (Type t : this.throwTypes()) {
            throwTypes.add(bounds.applyTo(t));
        }
        this.setThrowTypes(throwTypes);
    }

    public void subst(LabelSubstitution subst) throws SemanticException {
        TypeSubstitutor tsbs = new TypeSubstitutor(subst);
        this.setPCBound(this.pcBound().subst(subst), this.isDefaultPCBound());
        this.setReturnLabel(this.returnLabel().subst(subst), this.isDefaultReturnLabel());
        this.setReturnType(tsbs.rewriteType(this.returnType()));
        LinkedList<Type> formalTypes = new LinkedList<Type>();
        for (Type t : this.formalTypes()) {
            formalTypes.add(tsbs.rewriteType(t));
        }
        this.setFormalTypes(formalTypes);
        LinkedList<Type> throwTypes = new LinkedList<Type>();
        for (Type t : this.throwTypes()) {
            throwTypes.add(tsbs.rewriteType(t));
        }
        this.setThrowTypes(throwTypes);
    }

    public String debugString() {
        return this.debugString(true);
    }

    private String debugString(boolean showInstanceKind) {
        JifTypeSystem jts = (JifTypeSystem)this.ts;
        String s = "";
        if (showInstanceKind) {
            s = "method ";
        }
        s = s + this.flags.translate() + jts.unlabel(this.returnType) + " " + this.name + "(";
        Iterator i = this.formalTypes.iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            s = s + jts.unlabel(t).toString();
            if (!i.hasNext()) continue;
            s = s + ", ";
        }
        s = s + ")";
        return s;
    }

    public String signature() {
        if (Report.should_report((String)"debug", (int)1)) {
            return this.fullSignature();
        }
        return this.debugString(false);
    }

    public String fullSignature() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.name);
        if (!this.isDefaultPCBound() || Report.should_report((String)"debug", (int)1)) {
            sb.append(this.pcBound);
        }
        sb.append("(");
        Iterator i = this.formalTypes.iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            if (Report.should_report((String)"debug", (int)1)) {
                sb.append(t.toString());
            } else if (t.isClass()) {
                sb.append(t.toClass().name());
            } else {
                sb.append(t.toString());
            }
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        if (!this.isDefaultReturnLabel() || Report.should_report((String)"debug", (int)1)) {
            sb.append(":");
            sb.append(this.returnLabel);
        }
        return sb.toString();
    }
}

