/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.hierarchy.LabelEnv_c;
import jif.types.hierarchy.PrincipalHierarchy;
import jif.types.label.AccessPath;
import jif.types.label.Label;
import jif.types.label.PairLabel;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.ast.Branch;
import polyglot.ast.Expr;
import polyglot.ast.Local;
import polyglot.types.ClassType;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.Context_c;
import polyglot.types.LocalInstance;
import polyglot.types.Named;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;

public class JifContext_c
extends Context_c
implements JifContext {
    private final TypeSystem jlts;
    private final JifTypeSystem jifts;
    private LabelEnv_c env;
    private Set auth;
    private Label pc;
    private Label currentCodePCBound;
    protected Map<LocalInstance, Label> checkedEndorsements;
    protected Map gotos;
    protected boolean checkingInits;
    protected boolean inConstructorCall;
    protected Label constructorReturnLabel;

    protected JifContext_c(JifTypeSystem ts, TypeSystem jlts) {
        super((TypeSystem)ts);
        this.jlts = jlts;
        this.jifts = ts;
        this.env = (LabelEnv_c)ts.createLabelEnv();
    }

    public Object copy() {
        JifContext_c ctxt = (JifContext_c)super.copy();
        if (this.auth != null) {
            ctxt.auth = new LinkedHashSet(this.auth);
        }
        if (this.gotos != null) {
            ctxt.gotos = new HashMap(this.gotos);
        }
        return ctxt;
    }

    public VarInstance findVariableSilent(String name) {
        Type t;
        Named n;
        ClassType principal;
        VarInstance vi = super.findVariableSilent(name);
        if (vi != null) {
            return vi;
        }
        try {
            principal = (ClassType)this.jlts.typeForName("jif.lang.Principal");
        }
        catch (SemanticException e) {
            throw new InternalCompilerError("Cannot find jif.lang.Principal class.", (Throwable)e);
        }
        try {
            String className = "jif.principals." + name;
            n = this.jlts.loadedResolver().find(className);
        }
        catch (SemanticException e) {
            return null;
        }
        if (n instanceof Type && (t = (Type)n).isClass() && this.jlts.isSubtype((Type)t.toClass(), (Type)principal)) {
            return this.jifts.principalInstance(null, this.jifts.externalPrincipal(null, name));
        }
        return null;
    }

    public LabelEnv labelEnv() {
        return this.env;
    }

    protected void envModification() {
        JifContext_c jifOuter = (JifContext_c)this.outer;
        if (jifOuter != null && jifOuter.env == this.env) {
            this.env = this.env.copy();
        }
    }

    public void addAssertionLE(Label L1, Label L2) {
        this.envModification();
        this.env.addAssertionLE(L1, L2);
    }

    public void addDefinitionalAssertionEquiv(Label L1, Label L2) {
        this.addDefinitionalAssertionEquiv(L1, L2, false);
    }

    public void addDefinitionalAssertionEquiv(Label L1, Label L2, boolean addToClass) {
        this.env.addEquiv(L1, L2);
        JifContext_c jc = this;
        LabelEnv_c lastEnvAddedTo = this.env;
        while (jc != null && (!jc.isCode() || addToClass)) {
            if ((jc = (JifContext_c)jc.pop()) == null || jc.scope != this.scope || jc.env == lastEnvAddedTo) continue;
            jc.env.addEquiv(L1, L2);
            lastEnvAddedTo = jc.env;
        }
    }

    public void addDefinitionalAssertionEquiv(AccessPath p, AccessPath q) {
        this.env.addEquiv(p, q);
        JifContext_c jc = this;
        LabelEnv_c lastEnvAddedTo = this.env;
        while (!jc.isCode()) {
            if ((jc = (JifContext_c)jc.pop()) == null || jc.scope != this.scope || jc.env == lastEnvAddedTo) continue;
            jc.env.addEquiv(p, q);
            lastEnvAddedTo = jc.env;
        }
    }

    public void addEquiv(Label L1, Label L2) {
        this.envModification();
        this.env.addEquiv(L1, L2);
    }

    public void addEquiv(Principal p1, Principal p2) {
        this.envModification();
        this.env.addEquiv(p1, p2);
    }

    public void addActsFor(Principal p1, Principal p2) {
        this.envModification();
        this.env.addActsFor(p1, p2);
    }

    public void addEquiv(AccessPath p, AccessPath q) {
        boolean lastJCBlock;
        this.env.addEquiv(p, q);
        JifContext_c jc = this;
        LabelEnv_c lastEnvAddedTo = this.env;
        boolean bl = lastJCBlock = jc.kind == Context_c.BLOCK;
        while (!jc.isCode() && !lastJCBlock) {
            if ((jc = (JifContext_c)jc.pop()) != null && jc.scope == this.scope && jc.env != lastEnvAddedTo) {
                jc.env.addEquiv(p, q);
                lastEnvAddedTo = jc.env;
            }
            lastJCBlock = jc.kind == Context_c.BLOCK;
        }
    }

    public void addDefinitionalEquiv(Principal p1, Principal p2) {
        this.addEquiv(p1, p2);
        JifContext_c jc = this;
        LabelEnv_c lastEnvAddedTo = this.env;
        while (!jc.isCode()) {
            if ((jc = (JifContext_c)jc.pop()) == null || jc.scope != this.scope || jc.env == lastEnvAddedTo) continue;
            jc.env.addEquiv(p1, p2);
            lastEnvAddedTo = jc.env;
        }
    }

    public void clearPH() {
        this.envModification();
        this.env.ph().clear();
    }

    public Label gotoLabel(Branch.Kind kind, String label) {
        if (this.gotos == null) {
            return null;
        }
        return (Label)this.gotos.get(new Key(kind, label));
    }

    public void gotoLabel(Branch.Kind kind, String label, Label L) {
        if (this.gotos == null) {
            this.gotos = new HashMap();
        }
        this.gotos.put(new Key(kind, label), L);
    }

    public Label currentCodePCBound() {
        return this.currentCodePCBound;
    }

    public void setCurrentCodePCBound(Label currentCodePCBound) {
        this.currentCodePCBound = currentCodePCBound;
    }

    public Label pc() {
        return this.pc;
    }

    public void setPc(Label pc, LabelChecker lc) {
        this.pc = pc;
    }

    public Set authority() {
        return this.auth;
    }

    public void setAuthority(Set auth) {
        this.auth = auth;
    }

    public PrincipalHierarchy ph() {
        return this.env.ph();
    }

    public Label authLabel() {
        Set auth = this.authority();
        LinkedHashSet<PairLabel> labels = new LinkedHashSet<PairLabel>();
        for (Principal p : auth) {
            PairLabel pl = this.jifts.pairLabel(p.position(), this.jifts.readerPolicy(p.position(), p, this.jifts.topPrincipal(p.position())), this.jifts.topIntegPolicy(p.position()));
            labels.add(pl);
        }
        if (labels.isEmpty()) {
            return this.jifts.bottomLabel(this.currentCode().position());
        }
        Label L = this.jifts.joinLabel(this.currentCode().position(), labels);
        return L;
    }

    public Label authLabelInteg() {
        LinkedHashSet<PairLabel> labels = new LinkedHashSet<PairLabel>();
        for (Principal p : this.authority()) {
            PairLabel pl = this.jifts.pairLabel(p.position(), this.jifts.bottomConfPolicy(p.position()), this.jifts.writerPolicy(p.position(), p, this.jifts.topPrincipal(p.position())));
            labels.add(pl);
        }
        if (labels.isEmpty()) {
            return this.jifts.topLabel(this.currentCode().position());
        }
        Label L = this.jifts.meetLabel(this.currentCode().position(), labels);
        return L;
    }

    public boolean checkingInits() {
        return this.checkingInits;
    }

    public void setCheckingInits(boolean checkingInits) {
        this.checkingInits = checkingInits;
    }

    public Label constructorReturnLabel() {
        return this.constructorReturnLabel;
    }

    public void setConstructorReturnLabel(Label Lr) {
        this.constructorReturnLabel = Lr;
    }

    public Context pushConstructorCall() {
        JifContext_c A = (JifContext_c)this.pushStatic();
        A.inConstructorCall = true;
        return A;
    }

    public Context pushClass(ParsedClassType classScope, ClassType type) {
        JifContext_c jc = (JifContext_c)super.pushClass(classScope, type);
        jc.envModification();
        return jc;
    }

    public Context pushCode(CodeInstance ci) {
        JifContext_c jc = (JifContext_c)super.pushCode(ci);
        jc.envModification();
        return jc;
    }

    public boolean inConstructorCall() {
        return this.inConstructorCall;
    }

    public PathMap pathMapForLocal(LocalInstance li, LabelChecker lc) {
        JifTypeSystem ts = lc.jifTypeSystem();
        Label L = null;
        L = this.checkedEndorsements != null && this.checkedEndorsements.containsKey(li) ? this.checkedEndorsements.get(li) : ts.labelOfLocal(li, this.pc());
        PathMap X = ts.pathMap();
        X = X.N(this.pc());
        X = X.NV(lc.upperBound(L, this.pc()));
        return X;
    }

    public boolean updateAllowed(Expr e) {
        if (e instanceof Local && this.checkedEndorsements != null) {
            return !this.checkedEndorsements.containsKey(((Local)e).localInstance());
        }
        return true;
    }

    public void addCheckedEndorse(LocalInstance li, Label downgradeTo) {
        this.checkedEndorsements = this.checkedEndorsements == null ? new HashMap<LocalInstance, Label>() : new HashMap<LocalInstance, Label>(this.checkedEndorsements);
        this.checkedEndorsements.put(li, downgradeTo);
    }

    static class Key {
        Branch.Kind kind;
        String label;

        Key(Branch.Kind kind, String label) {
            this.kind = kind;
            this.label = label;
        }

        public int hashCode() {
            return this.kind.hashCode() + (this.label == null ? 0 : this.label.hashCode());
        }

        public String toString() {
            return this.kind.toString() + this.label;
        }

        public boolean equals(Object o) {
            if (o instanceof Key) {
                Key that = (Key)o;
                return this.kind.equals((Object)that.kind) && (this.label == that.label || this.label != null && this.label.equals(that.label));
            }
            return false;
        }
    }
}

