/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.ArrayList;
import java.util.Collections;
import jif.types.ConstArrayType;
import jif.types.JifFieldInstance;
import jif.types.JifTypeSystem;
import jif.types.label.ThisLabel;
import polyglot.types.ArrayType;
import polyglot.types.ArrayType_c;
import polyglot.types.ReferenceType;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.types.TypeSystem;
import polyglot.util.Position;

public class ConstArrayType_c
extends ArrayType_c
implements ConstArrayType {
    protected boolean isConst;
    protected boolean isNonConst;

    protected ConstArrayType_c() {
    }

    public ConstArrayType_c(JifTypeSystem ts, Position pos, Type base, boolean isConst) {
        this(ts, pos, base, isConst, !isConst);
    }

    public ConstArrayType_c(JifTypeSystem ts, Position pos, Type base, boolean isConst, boolean isNonConst) {
        super((TypeSystem)ts, pos, base);
        this.isConst = isConst;
        this.isNonConst = isNonConst;
    }

    public String toString() {
        Type base = this.base();
        Type ultBase = this.ultimateBase();
        JifTypeSystem ts = (JifTypeSystem)this.typeSystem();
        boolean isBaseArray = base.isArray();
        if (isBaseArray && ts.isLabeled(base) && ts.isLabeled(ultBase) && ts.labelOfType(base).equals(ts.labelOfType(ultBase))) {
            base = ts.unlabel(base);
        }
        String s = base.toString();
        if (!isBaseArray && this.isConst && !this.isNonConst) {
            return s + " const[]";
        }
        if (!isBaseArray && this.isConst && this.isNonConst) {
            return s + " const?[]";
        }
        return s + "[]";
    }

    public boolean equalsImpl(TypeObject o) {
        if (o instanceof ConstArrayType) {
            ConstArrayType t = (ConstArrayType)o;
            return t.isConst() == this.isConst && t.isNonConst() == this.isNonConst && this.ts.equals((TypeObject)this.base, (TypeObject)t.base());
        }
        if (o instanceof ArrayType) {
            ArrayType t = (ArrayType)o;
            return !this.isConst && !this.isNonConst && this.ts.equals((TypeObject)this.base, (TypeObject)t.base());
        }
        return false;
    }

    public boolean isConst() {
        return this.isConst;
    }

    public boolean isNonConst() {
        return this.isNonConst;
    }

    public boolean isImplicitCastValidImpl(Type toType) {
        if (this.isNonConst && !this.isConst) {
            if (toType.isArray()) {
                if (toType instanceof ConstArrayType && ((ConstArrayType)toType).isConst()) {
                    return false;
                }
                return this.ts.equals((TypeObject)this.base(), (TypeObject)toType.toArray().base());
            }
            return super.isImplicitCastValidImpl(toType);
        }
        if (this.isConst) {
            if (toType.isArray()) {
                if (!(this.isNonConst || toType instanceof ConstArrayType && ((ConstArrayType)toType).isConst())) {
                    return false;
                }
                return this.ts.isImplicitCastValid(this.base(), toType.toArray().base());
            }
            return super.isImplicitCastValidImpl(toType);
        }
        return false;
    }

    protected void init() {
        JifTypeSystem ts = (JifTypeSystem)this.ts;
        if (this.methods == null) {
            this.methods = new ArrayList(1);
            ConstArrayType retType = ts.constArrayOf(this.position(), this.base(), 1, true, true);
            this.methods.add(ts.jifMethodInstance(this.position(), (ReferenceType)this, ts.Public(), (Type)retType, "clone", ts.topLabel(), false, Collections.EMPTY_LIST, Collections.EMPTY_LIST, ts.bottomLabel(), false, Collections.EMPTY_LIST, Collections.EMPTY_LIST));
        }
        if (this.fields == null) {
            this.fields = new ArrayList(2);
            ThisLabel fieldLabel = ts.thisLabel(this);
            JifFieldInstance fi = (JifFieldInstance)ts.fieldInstance(this.position(), (ReferenceType)this, ts.Public().Final(), ts.labeledType(this.position(), (Type)ts.Int(), fieldLabel), "length");
            fi.setLabel(fieldLabel);
            fi.setNotConstant();
            this.fields.add(fi);
        }
        if (this.interfaces == null) {
            this.interfaces = Collections.EMPTY_LIST;
        }
    }
}

