/*
 * Decompiled with CFR 0.152.
 */
package jif.types;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jif.JifOptions;
import jif.Topics;
import jif.types.Constraint;
import jif.types.Equation;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.LabelEquation;
import jif.types.PrincipalConstraint;
import jif.types.PrincipalEquation;
import jif.types.Solver;
import jif.types.VarMap;
import jif.types.hierarchy.LabelEnv;
import jif.types.label.Label;
import jif.types.label.NotTaken;
import jif.types.label.VarLabel;
import jif.types.label.Variable;
import jif.types.principal.Principal;
import jif.types.principal.VarPrincipal;
import polyglot.frontend.Compiler;
import polyglot.main.Options;
import polyglot.main.Report;
import polyglot.types.SemanticException;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Pair;
import polyglot.util.Position;

public abstract class AbstractSolver
implements Solver {
    protected EquationQueue Q;
    protected LinkedList scc;
    protected Set currentSCC;
    protected Collection equations;
    private Map varEqnDependencies;
    private Map eqnVarDependencies;
    private Map varEqnReverseDependencies;
    private Map eqnVarReverseDependencies;
    protected Set fixedValueVars;
    protected static final int STATUS_NOT_SOLVED = 0;
    protected static final int STATUS_SOLVING = 1;
    protected static final int STATUS_SOLVED = 2;
    protected static final int STATUS_NO_SOLUTION = 3;
    protected int status;
    protected VarMap bounds;
    protected JifTypeSystem ts;
    protected Set staticFailedConstraints;
    protected static final boolean THROW_STATIC_FAILED_CONSTRAINTS = false;
    protected final Compiler compiler;
    protected Map traces;
    protected static Collection topics = CollectionUtil.list((Object)Topics.jif, (Object)Topics.solver);
    protected final boolean useSCC;
    private final String solverName;
    protected static int solverCounter;
    protected static int constraint_counter;

    protected AbstractSolver(JifTypeSystem ts, Compiler compiler, String solverName) {
        this(ts, compiler, solverName, false);
    }

    protected AbstractSolver(JifTypeSystem ts, Compiler compiler, String solverName, boolean useSCC) {
        this.ts = ts;
        this.compiler = compiler;
        this.useSCC = useSCC;
        this.Q = new EquationQueue();
        this.equations = new LinkedHashSet();
        this.varEqnDependencies = new LinkedHashMap();
        this.eqnVarDependencies = new LinkedHashMap();
        this.varEqnReverseDependencies = new LinkedHashMap();
        this.eqnVarReverseDependencies = new LinkedHashMap();
        this.traces = new LinkedHashMap();
        this.setStatus(0);
        this.bounds = new VarMap(ts, this.getDefaultLabelBound(), this.getDefaultPrincipalBound());
        this.scc = null;
        this.currentSCC = null;
        this.solverName = solverName + " (#" + ++solverCounter + ")";
        this.fixedValueVars = new HashSet();
    }

    protected AbstractSolver(AbstractSolver js) {
        this.ts = js.ts;
        this.compiler = js.compiler;
        this.useSCC = js.useSCC;
        this.Q = new EquationQueue(js.Q);
        this.equations = new LinkedHashSet(js.equations);
        this.varEqnDependencies = js.varEqnDependencies;
        this.eqnVarDependencies = js.eqnVarDependencies;
        this.traces = new LinkedHashMap(js.traces);
        this.status = js.status;
        this.bounds = js.bounds.copy();
        this.equations = new LinkedHashSet(js.equations);
        this.scc = new LinkedList(js.scc);
        this.solverName = js.solverName;
        this.fixedValueVars = js.fixedValueVars;
    }

    public static final void report(int level, String s) {
        Report.report((int)level, (String)s);
    }

    public static final boolean shouldReport(int obscurity) {
        return Report.should_report((Collection)topics, (int)obscurity);
    }

    public Label applyBoundsTo(Label L) {
        return this.bounds.applyTo(L);
    }

    protected Label triggerTransforms(Label label, LabelEnv env) {
        return env.triggerTransforms(label);
    }

    protected List getQueue() {
        return Collections.unmodifiableList(this.Q.list);
    }

    protected void addEquationToQueue(Equation eqn) {
        this.Q.add(eqn);
    }

    protected void addEquationToQueueHead(Equation eqn) {
        this.Q.addFirst(eqn);
    }

    public VarMap bounds() {
        return this.bounds;
    }

    public void setBounds(VarMap bnds) {
        this.bounds = bnds;
    }

    public void setBound(VarLabel v, Label newBound, LabelConstraint responsible) throws SemanticException {
        this.bounds.setBound((Variable)v, newBound);
    }

    public void setBound(VarPrincipal v, Principal newBound, PrincipalConstraint responsible) throws SemanticException {
        this.bounds.setBound((Variable)v, newBound);
    }

    public VarMap solve() throws SemanticException {
        if (this.status == 2 || this.status == 3) {
            return this.bounds;
        }
        if (this.status == 1) {
            throw new InternalCompilerError("solve called on solver while in the process of solving.");
        }
        this.setStatus(1);
        if (AbstractSolver.shouldReport(1)) {
            AbstractSolver.report(1, "===== Starting solver " + this.solverName + " =====");
            AbstractSolver.report(1, "   " + this.equations.size() + " equations");
        }
        if (this.staticFailedConstraints != null && !this.staticFailedConstraints.isEmpty()) {
            if (AbstractSolver.shouldReport(1)) {
                AbstractSolver.report(1, "   " + this.staticFailedConstraints.size() + " statically failed constraint");
            }
            this.setStatus(3);
            Iterator iter = this.staticFailedConstraints.iterator();
            while (iter.hasNext()) {
                Constraint cons = (Constraint)iter.next();
                SemanticException ex = new SemanticException(this.errorMsg(cons), cons.position());
                if (!iter.hasNext()) {
                    throw ex;
                }
                this.compiler.errorQueue().enqueue(5, ex.getMessage(), ex.position());
            }
        }
        if (this.useSCC) {
            LinkedList pair = this.findSCCs();
            Equation[] by_scc = (Equation[])pair.getFirst();
            int[] scc_head = (int[])pair.getLast();
            this.scc = new LinkedList();
            LinkedHashSet<Equation> currentScc = null;
            for (int i = 0; i < scc_head.length; ++i) {
                if (scc_head[i] == -1 && currentScc != null) {
                    this.scc.add(currentScc);
                    currentScc = null;
                }
                if (currentScc == null) {
                    currentScc = new LinkedHashSet<Equation>();
                }
                currentScc.add(by_scc[i]);
            }
            if (currentScc != null) {
                this.scc.add(currentScc);
                currentScc = null;
            }
        } else {
            this.scc = new LinkedList();
            this.scc.add(new LinkedHashSet(this.equations));
        }
        if (this.scc.isEmpty()) {
            this.currentSCC = Collections.EMPTY_SET;
            this.Q = new EquationQueue();
        } else {
            this.currentSCC = (Set)this.scc.removeFirst();
            this.Q = new EquationQueue(this.currentSCC);
        }
        try {
            VarMap soln = this.solve_bounds();
            this.setStatus(2);
            if (AbstractSolver.shouldReport(1)) {
                AbstractSolver.report(1, "   finished " + this.solverName);
            }
            return soln;
        }
        catch (SemanticException e) {
            this.setStatus(3);
            throw e;
        }
    }

    protected void setStatus(int status) {
        this.status = status;
    }

    protected abstract Label getDefaultLabelBound();

    protected abstract Principal getDefaultPrincipalBound();

    protected VarMap solve_bounds() throws SemanticException {
        if (AbstractSolver.shouldReport(3)) {
            AbstractSolver.report(3, "======EQUATIONS======");
            for (Equation eqn : this.equations) {
                AbstractSolver.report(3, eqn.toString());
            }
        }
        int counter = 0;
        if (this.Q.isEmpty()) {
            this.checkCandidateSolution();
        }
        while (!this.Q.isEmpty()) {
            while (!this.Q.isEmpty()) {
                Equation eqn;
                ++counter;
                eqn = this.Q.removeFirst();
                this.considerEquation(eqn);
                if (!this.Q.isEmpty() || this.scc.isEmpty()) continue;
                this.currentSCC = (Set)this.scc.removeFirst();
                this.Q.addAll(this.currentSCC);
            }
            this.checkCandidateSolution();
        }
        if (AbstractSolver.shouldReport(2)) {
            AbstractSolver.report(2, "Number of relaxation steps: " + counter);
        }
        if (AbstractSolver.shouldReport(2)) {
            AbstractSolver.report(2, this.bounds.toString());
        }
        return this.bounds;
    }

    protected void considerEquation(Equation eqn) throws SemanticException {
        if (eqn instanceof LabelEquation) {
            this.considerEquation((LabelEquation)eqn);
        } else if (eqn instanceof PrincipalEquation) {
            this.considerEquation((PrincipalEquation)eqn);
        } else {
            throw new InternalCompilerError("Unexpected eqn " + eqn);
        }
    }

    protected void considerEquation(LabelEquation eqn) throws SemanticException {
        Label lhsbound = this.triggerTransforms(this.bounds.applyTo(eqn.lhs()), eqn.env());
        Label rhsbound = this.triggerTransforms(this.bounds.applyTo(eqn.rhs()), eqn.env());
        if (eqn.env().leq(lhsbound, rhsbound)) {
            if (AbstractSolver.shouldReport(5)) {
                AbstractSolver.report(5, "constraint: " + eqn + " already satisfied: " + lhsbound + "<=" + rhsbound);
            }
        } else {
            if (AbstractSolver.shouldReport(4)) {
                AbstractSolver.report(4, "Considering constraint: " + eqn + " (" + (eqn.position() == null ? "null" : "line " + eqn.position().line()) + ")");
            }
            this.solve_eqn(eqn);
        }
    }

    protected abstract void solve_eqn(LabelEquation var1) throws SemanticException;

    protected void considerEquation(PrincipalEquation eqn) throws SemanticException {
        Principal lhsbound = this.bounds.applyTo(eqn.lhs());
        Principal rhsbound = this.bounds.applyTo(eqn.rhs());
        if (eqn.env().actsFor(lhsbound, rhsbound)) {
            if (AbstractSolver.shouldReport(5)) {
                AbstractSolver.report(5, "constraint: " + eqn + " already satisfied: " + lhsbound + " actsfor " + rhsbound);
            }
        } else {
            if (AbstractSolver.shouldReport(4)) {
                AbstractSolver.report(4, "Considering constraint: " + eqn + " (" + (eqn.position() == null ? "null" : "line " + eqn.position().line()) + ")");
            }
            this.solve_eqn(eqn);
        }
    }

    protected abstract void solve_eqn(PrincipalEquation var1) throws SemanticException;

    protected final void checkCandidateSolution() throws SemanticException {
        if (AbstractSolver.shouldReport(4)) {
            AbstractSolver.report(4, "===== Checking candidate solution =====");
        }
        for (Equation eqn : this.equations) {
            if (!(eqn instanceof LabelEquation)) continue;
            this.checkEquationSatisfied((LabelEquation)eqn);
        }
    }

    protected void checkEquationSatisfied(LabelEquation eqn) throws SemanticException {
        for (Variable v : eqn.variables()) {
            if (!v.mustRuntimeRepresentable()) continue;
            boolean isRuntimeRepresentable = false;
            if (v instanceof VarLabel) {
                isRuntimeRepresentable = this.bounds.boundOf((VarLabel)v).isRuntimeRepresentable();
            } else if (v instanceof VarPrincipal) {
                isRuntimeRepresentable = this.bounds.boundOf((VarPrincipal)v).isRuntimeRepresentable();
            } else {
                throw new InternalCompilerError("Unexpected variable " + v);
            }
            if (isRuntimeRepresentable) continue;
            this.reportError(eqn.labelConstraint(), Collections.singleton(v));
        }
        Label lhsBound = this.triggerTransforms(this.bounds.applyTo(eqn.lhs()), eqn.env());
        Label rhsBound = this.triggerTransforms(this.bounds.applyTo(eqn.rhs()), eqn.env());
        if (AbstractSolver.shouldReport(4)) {
            AbstractSolver.report(4, "Checking equation: " + eqn);
        }
        if (AbstractSolver.shouldReport(6)) {
            AbstractSolver.report(6, "LHS = " + eqn.lhs());
            AbstractSolver.report(6, "LHS APP = " + lhsBound);
            AbstractSolver.report(6, "RHS APP = " + rhsBound);
        }
        if (!eqn.env().leq(lhsBound, rhsBound)) {
            this.reportError(eqn.labelConstraint(), eqn.variableComponents());
        }
    }

    protected final void wakeUp(Variable v) {
        Set eqns = (Set)this.varEqnDependencies.get(v);
        if (eqns != null) {
            for (Equation eqn : eqns) {
                if (this.Q.contains(eqn) || this.useSCC && !this.currentSCC.contains(eqn)) continue;
                this.Q.add(eqn);
            }
        }
    }

    public String solverName() {
        return this.solverName;
    }

    protected final void inc_counter() {
        ++constraint_counter;
    }

    protected boolean isFixedValueVar(Variable v) {
        return this.fixedValueVars.contains(v);
    }

    public void addConstraint(Constraint c) throws SemanticException {
        if (this.status != 0) {
            throw new InternalCompilerError("Computed solution already. Cannot add more constraints");
        }
        if (AbstractSolver.shouldReport(5)) {
            AbstractSolver.report(5, constraint_counter + 1 + ": " + c);
        }
        if (AbstractSolver.shouldReport(6)) {
            AbstractSolver.report(6, ">>> " + c.msg());
        }
        this.inc_counter();
        if (!c.isCanonical()) {
            throw new SemanticException(this.errorMsg(c), c.position());
        }
        if (c instanceof LabelConstraint) {
            LabelConstraint lc = (LabelConstraint)c;
            if (lc.lhsLabel() instanceof NotTaken && lc.kind() == LabelConstraint.LEQ) {
                return;
            }
            if (lc.rhsLabel() instanceof NotTaken && lc.kind() == LabelConstraint.LEQ) {
                throw new SemanticException(this.errorMsg(c), c.position());
            }
        }
        this.processConstraint(c);
        this.addConstraintEquations(c);
    }

    protected void processConstraint(Constraint c) throws SemanticException {
        PrincipalConstraint pc;
        if (c instanceof LabelConstraint) {
            LabelConstraint lc = (LabelConstraint)c;
            if (lc.lhsLabel() instanceof VarLabel && lc.kind() == LabelConstraint.EQUAL) {
                VarLabel v = (VarLabel)lc.lhsLabel();
                Label initialBound = this.bounds.applyTo(lc.rhsLabel());
                this.addTrace(v, (Equation)lc.getEquations().iterator().next(), initialBound);
                this.setBound(v, initialBound, lc);
                if (!lc.rhsLabel().hasVariableComponents()) {
                    this.fixedValueVars.add(v);
                }
            }
        } else if (c instanceof PrincipalConstraint && ((pc = (PrincipalConstraint)c).lhsPrincipal() instanceof VarPrincipal || pc.rhsPrincipal() instanceof VarPrincipal) && pc.kind() == PrincipalConstraint.EQUIV) {
            VarPrincipal v = null;
            Principal other = null;
            if (pc.lhsPrincipal() instanceof VarPrincipal) {
                v = (VarPrincipal)pc.lhsPrincipal();
                other = pc.rhsPrincipal();
            } else {
                v = (VarPrincipal)pc.rhsPrincipal();
                other = pc.lhsPrincipal();
            }
            Principal initialBound = this.bounds.applyTo(other);
            this.setBound(v, initialBound, pc);
            if (!other.hasVariables()) {
                this.fixedValueVars.add(v);
            }
        }
    }

    protected void addConstraintEquations(Constraint c) throws SemanticException {
        Collection eqns = c.getEquations();
        Equation eqn2 = null;
        for (Equation eqn2 : eqns) {
            LabelEnv eqnEnv = eqn2.env();
            if (!eqnEnv.hasVariables() && !eqn2.constraint().hasVariables()) {
                boolean eqnSatisfied = false;
                if (eqn2 instanceof LabelEquation) {
                    LabelEquation leqn = (LabelEquation)eqn2;
                    eqnSatisfied = eqnEnv.leq(this.triggerTransforms(leqn.lhs(), eqnEnv), this.triggerTransforms(leqn.rhs(), eqnEnv));
                } else if (eqn2 instanceof PrincipalEquation) {
                    PrincipalEquation peqn = (PrincipalEquation)eqn2;
                    eqnSatisfied = eqnEnv.actsFor(peqn.lhs(), peqn.rhs());
                } else {
                    throw new InternalCompilerError("Unexpected kind of equation: " + eqn2);
                }
                if (eqnSatisfied) continue;
                if (AbstractSolver.shouldReport(2)) {
                    AbstractSolver.report(2, "Statically failed " + eqn2);
                }
                if (AbstractSolver.shouldReport(3) && eqn2 instanceof LabelEquation) {
                    AbstractSolver.report(3, "Statically failed " + this.triggerTransforms(((LabelEquation)eqn2).lhs(), eqnEnv) + " <= " + this.triggerTransforms(((LabelEquation)eqn2).rhs(), eqnEnv));
                }
                if (this.staticFailedConstraints == null) {
                    this.staticFailedConstraints = new LinkedHashSet();
                }
                this.staticFailedConstraints.add(eqn2.constraint());
                continue;
            }
            if (AbstractSolver.shouldReport(5)) {
                AbstractSolver.report(5, "Adding equation: " + eqn2);
            }
            eqnEnv.setSolver(this);
            this.equations.add(eqn2);
            this.addDependencies(eqn2);
        }
    }

    protected abstract void addDependencies(Equation var1);

    protected void addDependency(Variable var, Equation eqn) {
        LinkedHashSet<Equation> eqns = (LinkedHashSet<Equation>)this.varEqnDependencies.get(var);
        if (eqns == null) {
            eqns = new LinkedHashSet<Equation>();
            this.varEqnDependencies.put(var, eqns);
        }
        eqns.add(eqn);
        LinkedHashSet<Variable> vars = (LinkedHashSet<Variable>)this.eqnVarReverseDependencies.get(eqn);
        if (vars == null) {
            vars = new LinkedHashSet<Variable>();
            this.eqnVarReverseDependencies.put(eqn, vars);
        }
        vars.add(var);
    }

    protected void addDependency(Equation eqn, Variable var) {
        LinkedHashSet<Variable> vars = (LinkedHashSet<Variable>)this.eqnVarDependencies.get(eqn);
        if (vars == null) {
            vars = new LinkedHashSet<Variable>();
            this.eqnVarDependencies.put(eqn, vars);
        }
        vars.add(var);
        LinkedHashSet<Equation> eqns = (LinkedHashSet<Equation>)this.varEqnReverseDependencies.get(var);
        if (eqns == null) {
            eqns = new LinkedHashSet<Equation>();
            this.varEqnReverseDependencies.put(var, eqns);
        }
        eqns.add(eqn);
    }

    protected Set eqnEqnDependencies(Equation eqn) {
        Set vars = (Set)this.eqnVarDependencies.get(eqn);
        if (vars == null || vars.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet eqns = new LinkedHashSet();
        for (VarLabel v : vars) {
            Set s = (Set)this.varEqnDependencies.get(v);
            if (s == null) continue;
            eqns.addAll(s);
        }
        return eqns;
    }

    protected Set eqnEqnReverseDependencies(Equation eqn) {
        Set vars = (Set)this.eqnVarReverseDependencies.get(eqn);
        if (vars == null || vars.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        LinkedHashSet eqns = new LinkedHashSet();
        for (VarLabel v : vars) {
            Set s = (Set)this.varEqnReverseDependencies.get(v);
            if (s == null) continue;
            eqns.addAll(s);
        }
        return eqns;
    }

    protected final void addTrace(VarLabel v, Equation eqn, Label lb) {
        LinkedList<Pair> trace = (LinkedList<Pair>)this.traces.get(v);
        if (trace == null) {
            trace = new LinkedList<Pair>();
            this.traces.put(v, trace);
        }
        trace.add(new Pair((Object)eqn, lb.copy()));
    }

    protected final Equation findTrace(VarLabel var, Label threshold, boolean lowerThreshold) {
        List history = (List)this.traces.get(var);
        if (history != null) {
            for (Pair eqn_label : history) {
                Label label = (Label)eqn_label.part2();
                Equation eqn = (Equation)eqn_label.part1();
                boolean test = lowerThreshold ? eqn.env().leq(threshold, label) : eqn.env().leq(label, threshold);
                if (test) continue;
                return eqn;
            }
        }
        return null;
    }

    protected void reportTraces(Collection variables) {
    }

    protected boolean errorShowConstraint() {
        return this.errorShowTechnicalMsg() || this.errorShowDetailMsg();
    }

    protected boolean errorShowTechnicalMsg() {
        return false;
    }

    protected boolean errorShowDetailMsg() {
        return ((JifOptions)Options.global).explainErrors;
    }

    protected boolean errorShowDefns() {
        return (this.errorShowTechnicalMsg() || this.errorShowDetailMsg()) && this.errorShowConstraint();
    }

    protected final String errorMsg(Constraint c) {
        StringBuffer sb = new StringBuffer();
        if (this.errorShowConstraint()) {
            sb.append("Unsatisfiable constraint: \n");
            sb.append(this.errorStringConstraint(c));
            sb.append(" \n \n");
        }
        if (this.errorShowDefns() && c instanceof LabelConstraint) {
            sb.append("Label Descriptions");
            sb.append(" \n------------------");
            sb.append(this.errorStringDefns((LabelConstraint)c));
            sb.append(" \n \n");
        }
        if (this.errorShowTechnicalMsg()) {
            sb.append(c.technicalMsg());
        } else if (this.errorShowDetailMsg()) {
            sb.append(c.detailMsg());
        } else {
            sb.append(c.msg());
        }
        return sb.toString();
    }

    protected String errorStringConstraint(Constraint c) {
        LabelConstraint lc;
        StringBuffer sb = new StringBuffer();
        if (c instanceof LabelConstraint && ((lc = (LabelConstraint)c).namedLhs() != null || lc.namedRhs() != null)) {
            sb.append("  ");
            sb.append(lc.namedLhs());
            sb.append((Object)c.kind());
            sb.append(lc.namedRhs());
            sb.append(" \n");
        }
        sb.append("\t");
        sb.append(this.bounds.applyTo(c.lhs));
        sb.append((Object)c.kind());
        sb.append(this.bounds.applyTo(c.rhs));
        if (!c.env().isEmpty()) {
            sb.append(" \nin environment \n   ");
            sb.append(c.env());
        }
        return sb.toString();
    }

    protected String errorStringDefns(LabelConstraint c) {
        StringBuffer sb = new StringBuffer();
        Map defns = c.definitions(this.bounds);
        for (Map.Entry e : defns.entrySet()) {
            sb.append(" \n - ");
            sb.append((String)e.getKey());
            List l = (List)e.getValue();
            Iterator j = l.iterator();
            while (j.hasNext()) {
                sb.append(" = ");
                sb.append((String)j.next());
                if (!j.hasNext()) continue;
                sb.append(" \n - ");
                sb.append((String)e.getKey());
            }
        }
        return sb.toString();
    }

    protected void reportError(Constraint c, Collection variables) throws SemanticException {
        int count = 0;
        while (!c.report() && count++ < 1000) {
            Equation eqn = this.findContradictiveEqn(c);
            if (eqn == null) {
                if (!AbstractSolver.shouldReport(3)) break;
                AbstractSolver.report(3, "Could not find contradictive eqn for " + c);
                break;
            }
            if (AbstractSolver.shouldReport(3)) {
                AbstractSolver.report(3, "Found contradictive eqn for " + c + "; it is " + eqn);
            }
            c = eqn.constraint();
        }
        Position pos = c.position();
        if (variables != null) {
            this.reportTraces(variables);
        }
        throw new SemanticException(this.errorMsg(c), pos);
    }

    protected Equation findContradictiveEqn(Constraint c) {
        if (c instanceof LabelConstraint) {
            return this.findContradictiveEqn((LabelConstraint)c);
        }
        throw new InternalCompilerError("Unexpected constraint type: " + c.getClass());
    }

    protected abstract Equation findContradictiveEqn(LabelConstraint var1);

    protected LinkedList findSCCs() {
        Equation[] sorted = new Equation[this.equations.size()];
        int n = 0;
        LinkedList<Frame> stack = new LinkedList<Frame>();
        HashSet<Equation> reachable = new HashSet<Equation>();
        for (Equation eq : this.equations) {
            if (reachable.contains(eq)) continue;
            reachable.add(eq);
            stack.addFirst(new Frame(eq, true));
            while (!stack.isEmpty()) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    Equation eqTo = (Equation)top.edges.next();
                    if (reachable.contains(eqTo)) continue;
                    reachable.add(eqTo);
                    stack.addFirst(new Frame(eqTo, true));
                    continue;
                }
                stack.removeFirst();
                sorted[n++] = top.eqn;
            }
        }
        Equation[] by_scc = new Equation[n];
        int[] scc_head = new int[n];
        HashSet<Equation> visited = new HashSet<Equation>();
        int head = 0;
        for (int i = n - 1; i >= 0; --i) {
            if (visited.contains(sorted[i])) continue;
            HashSet<Equation> SCC = new HashSet<Equation>();
            visited.add(sorted[i]);
            stack.add(new Frame(sorted[i], false));
            while (!stack.isEmpty()) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    Equation eqTo = (Equation)top.edges.next();
                    if (!reachable.contains(eqTo) || visited.contains(eqTo)) continue;
                    visited.add(eqTo);
                    Frame f = new Frame(eqTo, false);
                    stack.addFirst(f);
                    continue;
                }
                stack.removeFirst();
                SCC.add(top.eqn);
            }
            stack.add(new Frame(sorted[i], true));
            HashSet<Equation> revisited = new HashSet<Equation>();
            revisited.add(sorted[i]);
            int scc_size = SCC.size();
            int nsorted = 0;
            while (stack.size() != 0) {
                Frame top = (Frame)stack.getFirst();
                if (top.edges.hasNext()) {
                    Equation eqTo = (Equation)top.edges.next();
                    if (!SCC.contains(eqTo) || revisited.contains(eqTo)) continue;
                    revisited.add(eqTo);
                    Frame f = new Frame(eqTo, true);
                    stack.addFirst(f);
                    continue;
                }
                stack.removeFirst();
                int n3 = head + scc_size - nsorted - 1;
                scc_head[n3] = -2;
                by_scc[n3] = top.eqn;
                ++nsorted;
            }
            scc_head[head + scc_size - 1] = head;
            scc_head[head] = -1;
            head += scc_size;
        }
        LinkedList<Object[]> ret = new LinkedList<Object[]>();
        ret.addFirst(scc_head);
        ret.addFirst(by_scc);
        return ret;
    }

    static {
        constraint_counter = 0;
    }

    protected static class EquationQueue {
        final LinkedList list;
        final Set elements;

        public EquationQueue() {
            this.list = new LinkedList();
            this.elements = new HashSet();
        }

        public EquationQueue(Collection c) {
            this.list = new LinkedList(c);
            this.elements = new HashSet(c);
        }

        public EquationQueue(EquationQueue q) {
            this.list = new LinkedList(q.list);
            this.elements = new HashSet(q.elements);
        }

        public boolean contains(Equation eqn) {
            return this.elements.contains(eqn);
        }

        public void addAll(Collection c) {
            if (c != null) {
                for (Equation e : c) {
                    this.add(e);
                }
            }
        }

        public Equation removeFirst() {
            Equation e = (Equation)this.list.removeFirst();
            this.elements.remove(e);
            return e;
        }

        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        public void add(Equation eqn) {
            if (!this.elements.contains(eqn)) {
                this.list.add(eqn);
                this.elements.add(eqn);
            }
        }

        public void addFirst(Equation eqn) {
            if (this.elements.contains(eqn)) {
                this.list.remove(eqn);
            }
            this.list.addFirst(eqn);
            this.elements.add(eqn);
        }
    }

    protected class Frame {
        Equation eqn;
        Iterator edges;

        Frame(Equation e, boolean forward) {
            this.eqn = e;
            this.edges = forward ? AbstractSolver.this.eqnEqnDependencies(e).iterator() : AbstractSolver.this.eqnEqnReverseDependencies(e).iterator();
        }
    }
}

