/*
 * Decompiled with CFR 0.152.
 */
package jif.translate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jif.ast.JifConstructorDecl;
import jif.translate.ClassDeclToJavaExt_c;
import jif.translate.JifToJavaRewriter;
import jif.translate.ToJavaExt_c;
import jif.types.JifConstructorInstance;
import jif.types.JifPolyType;
import jif.types.JifSubstType;
import polyglot.ast.Block;
import polyglot.ast.CanonicalTypeNode;
import polyglot.ast.ConstructorCall;
import polyglot.ast.ConstructorDecl;
import polyglot.ast.Empty;
import polyglot.ast.Expr;
import polyglot.ast.MethodDecl;
import polyglot.ast.Node;
import polyglot.ast.NodeFactory;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class ConstructorDeclToJavaExt_c
extends ToJavaExt_c {
    protected JifConstructorInstance ci;
    protected List formals;

    public NodeVisitor toJavaEnter(JifToJavaRewriter rw) throws SemanticException {
        JifConstructorDecl n = (JifConstructorDecl)this.node();
        rw.inConstructor(true);
        this.ci = (JifConstructorInstance)n.constructorInstance();
        this.formals = new ArrayList(n.formals());
        return rw.bypass(n.startLabel()).bypass((Node)n.returnLabel()).bypass((Collection)n.constraints());
    }

    public Node toJava(JifToJavaRewriter rw) throws SemanticException {
        Node retVal;
        ConstructorDecl n = (ConstructorDecl)this.node();
        ClassType ct = this.ci.container().toClass();
        if (!rw.jif_ts().isJifClass((Type)ct)) {
            if (rw.jif_ts().isParamsRuntimeRep((Type)ct)) {
                ArrayList formals = new ArrayList(n.formals().size() + 2);
                if (this.ci.container() instanceof JifPolyType) {
                    JifPolyType jpt = (JifPolyType)this.ci.container();
                    formals.addAll(ClassDeclToJavaExt_c.produceParamFormals(jpt, rw, false));
                }
                formals.addAll(n.formals());
                n = rw.java_nf().ConstructorDecl(n.position(), n.flags(), n.name(), formals, n.throwTypes(), n.body());
                n = n.constructorInstance(null);
                retVal = n;
            } else {
                NodeFactory nf = rw.java_nf();
                retVal = nf.ConstructorDecl(n.position(), n.flags(), n.name(), n.formals(), n.throwTypes(), n.body());
            }
        } else {
            retVal = this.jifClassConstructorDecl(rw, n);
        }
        rw.inConstructor(false);
        return retVal;
    }

    private Node jifClassConstructorDecl(JifToJavaRewriter rw, ConstructorDecl n) throws SemanticException {
        NodeFactory nf = rw.java_nf();
        ConstructorInstance ci = n.constructorInstance();
        ClassType ct = ci.container().toClass();
        Block body = n.body();
        ArrayList<Object> inits = new ArrayList<Object>(3);
        inits.add(rw.qq().parseStmt("this.jif$init();"));
        if (!(body.statements().isEmpty() || body.statements().size() == 1 && body.statements().get(0) instanceof Empty)) {
            if (rw.jif_ts().isJifClass((Type)ct) && !rw.jif_ts().isJifClass(ct.superType())) {
                ConstructorCall cc;
                Stmt s;
                Type superType;
                int numSuperParams = 0;
                if (rw.jif_ts().isParamsRuntimeRep(ct.superType()) && (superType = ct.superType()) instanceof JifSubstType) {
                    numSuperParams = ((JifPolyType)((JifSubstType)superType).base()).params().size();
                }
                if ((s = (Stmt)body.statements().get(0)) instanceof ConstructorCall && (cc = (ConstructorCall)s).kind() == ConstructorCall.SUPER) {
                    if (cc.arguments().size() != numSuperParams) {
                        throw new InternalCompilerError(body.position(), "Expected super constructor call to be the default constructor as we have a Jif class with a non-Jif superclass: " + cc);
                    }
                    LinkedList stmtList = new LinkedList(body.statements());
                    stmtList.remove(0);
                    body = body.statements(stmtList);
                }
            }
            inits.add(body);
        }
        inits.addAll(this.additionalInits(rw));
        this.addConstructorReturn(rw, (JifConstructorInstance)ci, inits, n.position());
        body = nf.Block(n.position(), inits);
        body = this.jifConstructorBody(rw, body);
        String name = ClassDeclToJavaExt_c.constructorTranslatedName(ct);
        CanonicalTypeNode tn = rw.jif_nf().CanonicalTypeNode(n.position(), (Type)ct);
        tn = (TypeNode)tn.visit((NodeVisitor)rw);
        MethodDecl m = nf.MethodDecl(n.position(), n.flags(), (TypeNode)tn, name, n.formals(), n.throwTypes(), body);
        m = m.methodInstance(null);
        return m;
    }

    protected void addConstructorReturn(JifToJavaRewriter rw, JifConstructorInstance ci, List inits, Position pos) {
        NodeFactory nf = rw.java_nf();
        inits.add(nf.Return(pos, (Expr)nf.This(pos)));
    }

    protected Block jifConstructorBody(JifToJavaRewriter rw, Block body) {
        return body;
    }

    protected List additionalInits(JifToJavaRewriter rw) {
        return Collections.EMPTY_LIST;
    }
}

