/*
 * Decompiled with CFR 0.152.
 */
package jif.translate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import jif.ast.JifClassDecl;
import jif.translate.JifToJavaRewriter;
import jif.translate.ParamToJavaExpr_c;
import jif.translate.ToJavaExt_c;
import jif.types.JifContext;
import jif.types.JifPolyType;
import jif.types.JifSubst;
import jif.types.JifSubstType;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.label.Label;
import jif.types.principal.Principal;
import polyglot.ast.AmbTypeNode;
import polyglot.ast.Block;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl;
import polyglot.ast.ClassMember;
import polyglot.ast.Expr;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.ConstructorInstance;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.PrimitiveType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.NodeVisitor;

public class ClassDeclToJavaExt_c
extends ToJavaExt_c {
    protected static final String INSTANCEOF_METHOD_NAME = "jif$Instanceof";
    protected static final String INITIALIZATIONS_METHOD_NAME = "jif$init";
    protected static final String DEFAULT_CONSTRUCTOR_INVOKER_METHOD_NAME = "jif$invokeDefConstructor";
    private boolean hasDefaultConstructor = false;
    private List defaultConstructorExceptions = null;

    protected static final String castMethodName(ClassType ct) {
        return "jif$cast$" + ct.fullName().replace('.', '_');
    }

    protected static final String interfaceClassImplName(String jifInterfaceName) {
        return jifInterfaceName + "_JIF_IMPL";
    }

    protected static final String constructorTranslatedName(ClassType ct) {
        return (ct.fullName() + ".").replace('.', '$');
    }

    public NodeVisitor toJavaEnter(JifToJavaRewriter rw) throws SemanticException {
        JifClassDecl n = (JifClassDecl)this.node();
        rw.enteringClass((ClassType)n.type());
        ParsedClassType ct = n.type();
        for (ConstructorInstance ci : ct.constructors()) {
            if (!ci.formalTypes().isEmpty()) continue;
            this.hasDefaultConstructor = true;
            this.defaultConstructorExceptions = ci.throwTypes();
            break;
        }
        return rw.bypass(n.params()).bypass((Collection)n.authority());
    }

    public Node toJava(JifToJavaRewriter rw) throws SemanticException {
        JifClassDecl n = (JifClassDecl)this.node();
        JifPolyType jpt = (JifPolyType)n.type();
        ClassBody cb = n.body();
        if (!jpt.flags().isInterface()) {
            if (rw.jif_ts().isJifClass((Type)jpt)) {
                cb = cb.addMember(this.produceConstructor(jpt, rw));
                if (this.hasDefaultConstructor) {
                    cb = cb.addMember(this.produceDefaultConstructorInvoker(jpt, rw, this.defaultConstructorExceptions));
                }
                cb = this.addInitializer(cb, rw);
                cb = this.addStaticInitializers(cb, rw);
            }
            if (rw.jif_ts().isParamsRuntimeRep((Type)jpt)) {
                if (!jpt.params().isEmpty()) {
                    cb = cb.addMember(this.produceInstanceOfMethod(jpt, rw, false));
                    cb = cb.addMember(this.produceCastMethod(jpt, rw));
                    if (rw.jif_ts().isJifClass((Type)jpt)) {
                        for (ParamInstance pi : jpt.params()) {
                            String paramFieldName = ParamToJavaExpr_c.paramFieldName(pi);
                            TypeNode tn = ClassDeclToJavaExt_c.typeNodeForParam(pi, rw);
                            cb = cb.addMember(rw.qq().parseMember("private final %T %s;", (Object)tn, (Object)paramFieldName));
                        }
                    }
                }
                cb = this.addInterfaceParamGetters(cb, jpt, jpt, rw);
            }
        } else if (rw.jif_ts().isParamsRuntimeRep((Type)jpt)) {
            ClassBody implBody = rw.java_nf().ClassBody(Position.compilerGenerated(), new ArrayList(2));
            implBody = implBody.addMember(this.produceInstanceOfMethod(jpt, rw, true));
            implBody = implBody.addMember(this.produceCastMethod(jpt, rw));
            ClassDecl implDecl = rw.java_nf().ClassDecl(Position.compilerGenerated(), n.flags().clearInterface().Abstract(), ClassDeclToJavaExt_c.interfaceClassImplName(n.name()), null, Collections.EMPTY_LIST, implBody);
            rw.addAdditionalClassDecl(implDecl);
            for (ParamInstance pi : jpt.params()) {
                String paramFieldNameGetter = ParamToJavaExpr_c.paramFieldNameGetter(pi);
                TypeNode tn = ClassDeclToJavaExt_c.typeNodeForParam(pi, rw);
                cb = cb.addMember(rw.qq().parseMember("%T %s();", (Object)tn, (Object)paramFieldNameGetter));
            }
        }
        rw.leavingClass();
        return rw.java_nf().ClassDecl(n.position(), n.flags(), n.name(), n.superClass(), n.interfaces(), cb);
    }

    private ClassBody addInitializer(ClassBody cb, JifToJavaRewriter rw) {
        ArrayList inits = new ArrayList(rw.getInitializations());
        rw.getInitializations().clear();
        return cb.addMember(rw.qq().parseMember("private void %s() { %LS }", (Object)INITIALIZATIONS_METHOD_NAME, inits));
    }

    protected ClassBody addStaticInitializers(ClassBody cb, JifToJavaRewriter rw) {
        if (rw.getStaticInitializations().isEmpty()) {
            return cb;
        }
        ArrayList inits = new ArrayList(rw.getStaticInitializations());
        rw.getStaticInitializations().clear();
        Block b = inits.size() == 1 ? (Block)inits.get(0) : rw.java_nf().Block(Position.compilerGenerated(), inits);
        return cb.addMember((ClassMember)rw.java_nf().Initializer(Position.compilerGenerated(), Flags.STATIC, b));
    }

    protected ClassBody addInterfaceParamGetters(ClassBody cb, JifPolyType baseClass, JifPolyType jpt, JifToJavaRewriter rw) throws SemanticException {
        if (!rw.jif_ts().isParamsRuntimeRep((Type)jpt)) {
            return cb;
        }
        for (Type interf : jpt.interfaces()) {
            if (!rw.jif_ts().isParamsRuntimeRep(interf) || rw.jif_ts().isSubtype(baseClass.superType(), interf)) continue;
            JifPolyType interfPT = null;
            if (interf instanceof JifSubstType) {
                JifSubstType interfST = (JifSubstType)interf;
                JifSubst subst = (JifSubst)interfST.subst();
                interfPT = (JifPolyType)interfST.base();
                for (ParamInstance pi : interfPT.params()) {
                    String paramFieldName = ParamToJavaExpr_c.paramFieldName(pi);
                    String paramFieldNameGetter = ParamToJavaExpr_c.paramFieldNameGetter(pi);
                    TypeNode tn = ClassDeclToJavaExt_c.typeNodeForParam(pi, rw);
                    Expr lblExpr = rw.paramToJava(subst.get(pi));
                    if (rw.jif_ts().isJifClass((Type)jpt)) {
                        cb = cb.addMember(rw.qq().parseMember("private %T %s;", (Object)tn, (Object)paramFieldName));
                        cb = cb.addMember(rw.qq().parseMember("public final %T %s() {  if (this.%s==null) this.%s = %E; return this.%s; }", (Object)tn, (Object)paramFieldNameGetter, (Object)paramFieldName, (Object)paramFieldName, (Object)lblExpr, (Object)paramFieldName));
                        continue;
                    }
                    cb = cb.addMember(rw.qq().parseMember("public final native %T %s();", (Object)tn, (Object)paramFieldNameGetter));
                }
            } else if (interf instanceof JifPolyType) {
                interfPT = (JifPolyType)interf;
            }
            if (interfPT == null) continue;
            cb = this.addInterfaceParamGetters(cb, baseClass, interfPT, rw);
        }
        return cb;
    }

    protected ClassMember produceInstanceOfMethod(JifPolyType jpt, JifToJavaRewriter rw, boolean useGetters) throws SemanticException {
        Context A = rw.context();
        rw = (JifToJavaRewriter)rw.context(A.pushStatic());
        List formals = ClassDeclToJavaExt_c.produceParamFormals(jpt, rw, true);
        String name = jpt.name();
        if (!rw.jif_ts().isJifClass((Type)jpt)) {
            return rw.qq().parseMember("static public native boolean %s(%LF);", (Object)INSTANCEOF_METHOD_NAME, (Object)formals);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("static public boolean %s(%LF) {");
        if (jpt.params().isEmpty()) {
            sb.append("return (o instanceof %s);");
        } else {
            sb.append("if (o instanceof %s) { ");
            sb.append("%s c = (%s)o; ");
            boolean moreThanOneParam = jpt.params().size() > 1;
            sb.append(moreThanOneParam ? "boolean ok = true;" : "");
            for (ParamInstance pi : jpt.params()) {
                String paramFieldName = ParamToJavaExpr_c.paramFieldName(pi);
                String paramArgName = ParamToJavaExpr_c.paramArgName(pi);
                String comparison = "equivalentTo";
                if (pi.isCovariantLabel()) {
                    comparison = "relabelsTo";
                }
                sb.append(moreThanOneParam ? "ok = ok && " : "return ");
                String paramExpr = paramFieldName;
                if (useGetters) {
                    paramExpr = ParamToJavaExpr_c.paramFieldNameGetter(pi) + "()";
                }
                if (pi.isPrincipal()) {
                    sb.append("jif.lang.PrincipalUtil." + comparison + "(c." + paramExpr + "," + paramArgName + ");");
                    continue;
                }
                sb.append(rw.runtimeLabelUtil() + "." + comparison + "(c." + paramExpr + "," + paramArgName + ");");
            }
            if (moreThanOneParam) {
                sb.append("return ok;");
            }
            sb.append("}");
            sb.append("return false;");
        }
        sb.append("}");
        return rw.qq().parseMember(sb.toString(), (Object)INSTANCEOF_METHOD_NAME, (Object)formals, (Object)name, (Object)name, (Object)name);
    }

    private static TypeNode typeNodeForParam(ParamInstance pi, JifToJavaRewriter rw) throws SemanticException {
        PrimitiveType paramType = pi.isPrincipal() ? rw.jif_ts().Principal() : rw.jif_ts().Label();
        return rw.typeToJava((Type)paramType, Position.compilerGenerated());
    }

    protected ClassMember produceCastMethod(JifPolyType jpt, JifToJavaRewriter rw) throws SemanticException {
        Context A = rw.context();
        rw = (JifToJavaRewriter)rw.context(A.pushStatic());
        TypeNode tn = rw.typeToJava((Type)jpt, Position.compilerGenerated());
        List formals = ClassDeclToJavaExt_c.produceParamFormals(jpt, rw, true);
        if (!rw.jif_ts().isJifClass((Type)jpt)) {
            return rw.qq().parseMember("static public native %T %s(%LF);", (Object)tn, (Object)ClassDeclToJavaExt_c.castMethodName(jpt), (Object)formals);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("static public %T %s(%LF) {");
        sb.append("if (o == null) return null;");
        sb.append("if (%s(%LE)) return (%T)o;");
        sb.append("throw new ClassCastException();");
        sb.append("}");
        List args = this.produceParamArgs(jpt, rw);
        return rw.qq().parseMember(sb.toString(), (Object)tn, (Object)ClassDeclToJavaExt_c.castMethodName(jpt), (Object)formals, (Object)INSTANCEOF_METHOD_NAME, (Object)args, (Object)tn);
    }

    protected static List produceParamFormals(JifPolyType jpt, JifToJavaRewriter rw, boolean addObjectFormal) throws SemanticException {
        ArrayList<Formal> formals = new ArrayList<Formal>(jpt.params().size() + 1);
        Position pos = Position.compilerGenerated();
        for (ParamInstance pi : jpt.params()) {
            String paramArgName = ParamToJavaExpr_c.paramArgName(pi);
            TypeNode tn = ClassDeclToJavaExt_c.typeNodeForParam(pi, rw);
            Formal f = rw.java_nf().Formal(pos, Flags.FINAL, tn, paramArgName);
            formals.add(f);
        }
        if (addObjectFormal) {
            TypeNode tn = rw.qq().parseType("Object");
            formals.add(rw.java_nf().Formal(pos, Flags.FINAL, tn, "o"));
        }
        return formals;
    }

    protected List produceParamArgs(JifPolyType jpt, JifToJavaRewriter rw) {
        ArrayList<Expr> args = new ArrayList<Expr>(jpt.params().size() + 1);
        for (ParamInstance pi : jpt.params()) {
            String paramArgName = ParamToJavaExpr_c.paramArgName(pi);
            args.add(rw.qq().parseExpr(paramArgName));
        }
        args.add(rw.qq().parseExpr("o"));
        return args;
    }

    protected ClassMember produceConstructor(JifPolyType jpt, JifToJavaRewriter rw) throws SemanticException {
        List formals = ClassDeclToJavaExt_c.produceParamFormals(jpt, rw, false);
        ArrayList<Stmt> inits = new ArrayList<Stmt>();
        ArrayList<Expr> superArgs = new ArrayList<Expr>();
        Type superType = jpt.superType();
        if (superType instanceof JifSubstType && rw.jif_ts().isParamsRuntimeRep(((JifSubstType)superType).base())) {
            JifSubstType superjst = (JifSubstType)jpt.superType();
            JifPolyType superjpt = (JifPolyType)superjst.base();
            JifContext A = (JifContext)rw.context();
            JifToJavaRewriter rwCons = (JifToJavaRewriter)rw.context(A.pushConstructorCall());
            for (ParamInstance pi : superjpt.params()) {
                Param param = ((JifSubst)superjst.subst()).get(pi);
                if (pi.isLabel()) {
                    superArgs.add(((Label)param).toJava(rwCons));
                    continue;
                }
                superArgs.add(((Principal)param).toJava(rwCons));
            }
        }
        inits.add(rw.qq().parseStmt("super(%LE);", superArgs));
        for (ParamInstance pi : jpt.params()) {
            String paramFieldName = ParamToJavaExpr_c.paramFieldName(pi);
            String paramArgName = ParamToJavaExpr_c.paramArgName(pi);
            inits.add(rw.qq().parseStmt("this." + paramFieldName + " = " + paramArgName + ";"));
        }
        inits.addAll(this.additionalConstructorCode(rw));
        return rw.java_nf().ConstructorDecl(Position.compilerGenerated(), Flags.PUBLIC, jpt.name(), formals, Collections.EMPTY_LIST, rw.java_nf().Block(Position.compilerGenerated(), inits));
    }

    protected List additionalConstructorCode(JifToJavaRewriter rw) {
        return Collections.EMPTY_LIST;
    }

    protected ClassMember produceDefaultConstructorInvoker(ClassType ct, JifToJavaRewriter rw, List throwTypes) throws SemanticException {
        if (throwTypes == null || throwTypes.isEmpty()) {
            return rw.qq().parseMember("public void jif$invokeDefConstructor() {this." + ClassDeclToJavaExt_c.constructorTranslatedName(ct) + "();" + "}");
        }
        ArrayList<AmbTypeNode> typeNodes = new ArrayList<AmbTypeNode>(throwTypes.size());
        for (Type t : throwTypes) {
            AmbTypeNode tn = rw.java_nf().AmbTypeNode(Position.compilerGenerated(), t.toClass().name());
            typeNodes.add(tn);
        }
        return rw.qq().parseMember("public void jif$invokeDefConstructor() throws %LT {this." + ClassDeclToJavaExt_c.constructorTranslatedName(ct) + "();" + "}", typeNodes);
    }
}

