/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import jif.types.ConstArrayType;
import jif.types.Constraint;
import jif.types.ConstraintMessage;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifPolyType;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.PrincipalConstraint;
import jif.types.label.Label;
import jif.types.label.VarLabel;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.main.Report;
import polyglot.types.ArrayType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeObject;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class SubtypeChecker {
    private final Type origSupertype;
    private final Type origSubtype;

    public SubtypeChecker(Type supertype, Type subtype) {
        JifTypeSystem ts = (JifTypeSystem)supertype.typeSystem();
        this.origSupertype = ts.unlabel(supertype);
        this.origSubtype = ts.unlabel(subtype);
    }

    public void addSubtypeConstraints(LabelChecker lc, Position pos) throws SemanticException {
        this.addSubtypeConstraints(lc, pos, this.origSupertype, this.origSubtype);
    }

    protected void addSubtypeConstraints(LabelChecker lc, Position pos, Type supertype, Type subtype) throws SemanticException {
        JifTypeSystem ts = lc.jifTypeSystem();
        supertype = ts.unlabel(supertype);
        subtype = ts.unlabel(subtype);
        if (Report.should_report((String)"types", (int)1)) {
            Report.report((int)1, (String)("Adding subtype constraints: " + supertype + " >= " + subtype));
        }
        if (!this.recursiveAddSubtypeConstraints(lc, pos, supertype, subtype, false)) {
            throw new SemanticException(subtype + " is not a subtype of " + supertype + ".", pos);
        }
    }

    private Label label(Param param, Position pos) throws SemanticException {
        if (param instanceof Label) {
            return (Label)param;
        }
        if (param == null) {
            throw new SemanticException("No parameter given; expected a label parameter.", pos);
        }
        throw new SemanticException("Parameter " + param + " is not a label.", param.position());
    }

    private Principal principal(Param param, Position pos) throws SemanticException {
        if (param instanceof Principal) {
            return (Principal)param;
        }
        if (param == null) {
            throw new SemanticException("No parameter given; expected a principal parameter.", pos);
        }
        throw new SemanticException("Parameter " + param + " is not a principal.", param.position());
    }

    private void addParamConstraints(LabelChecker lc, Position pos, JifClassType supertype, JifClassType subtype) throws SemanticException {
        if (Report.should_report((String)"types", (int)2)) {
            Report.report((int)2, (String)("Adding param constraints: " + supertype + " >= " + subtype));
        }
        JifContext A = lc.jifContext();
        Iterator iter = SubtypeChecker.polyTypeForClass(supertype).params().iterator();
        Iterator supIter = supertype.actuals().iterator();
        Iterator subIter = subtype.actuals().iterator();
        int counter = 0;
        while (iter.hasNext() && supIter.hasNext() && subIter.hasNext()) {
            final int count = ++counter;
            final ParamInstance pi = (ParamInstance)iter.next();
            Param supParam = (Param)supIter.next();
            Param subParam = (Param)subIter.next();
            if (pi.isInvariantLabel() || pi.isCovariantLabel()) {
                Constraint.Kind kind = pi.isInvariantLabel() ? LabelConstraint.EQUAL : (pi.isCovariantLabel() ? LabelConstraint.LEQ : null);
                final Type lOrigSubtype = this.origSubtype;
                final Type lOrigSupertype = this.origSupertype;
                lc.constrain(new NamedLabel("sub_param_" + count, StringUtil.nth((int)count) + " param of subtype " + lOrigSubtype, this.label(subParam, pos)), kind, new NamedLabel("sup_param_" + count, StringUtil.nth((int)count) + " param of supertype " + lOrigSupertype, this.label(supParam, pos)), A.labelEnv(), pos, new ConstraintMessage(){

                    public String msg() {
                        return lOrigSubtype + " is not a subtype of " + lOrigSupertype + ", since the subtype relation between label " + "parameters is not satisfied.";
                    }

                    public String detailMsg() {
                        String variance = pi.isInvariantLabel() ? "invariant" : "covariant";
                        String reln = this.kind() == LabelConstraint.EQUAL ? "equal to" : "less restrictive than";
                        return lOrigSubtype + " is not a subtype of " + lOrigSupertype + ". Subtyping requires " + "the " + StringUtil.nth((int)count) + " parameter of the subtype to be " + reln + " the " + StringUtil.nth((int)count) + " parameter of the supertype, since that " + "parameter is " + variance + ".";
                    }
                });
                continue;
            }
            if (!pi.isPrincipal()) continue;
            lc.constrain(this.principal(supParam, pos), PrincipalConstraint.EQUIV, this.principal(supParam, pos), A.labelEnv(), pos, new ConstraintMessage(){

                public String msg() {
                    return SubtypeChecker.this.origSubtype + " is not a subtype of " + SubtypeChecker.this.origSupertype + ", since the principals are not equivalent.";
                }

                public String detailMsg() {
                    return SubtypeChecker.this.origSubtype + " is not a subtype of " + SubtypeChecker.this.origSupertype + ". Subtyping requires " + "the " + StringUtil.nth((int)count) + " parameter of the subtype to be equivalent to the " + StringUtil.nth((int)count) + " parameter of the supertype.";
                }
            });
        }
        if (iter.hasNext() || supIter.hasNext() || subIter.hasNext()) {
            throw new InternalCompilerError(pos, "Instantiation type parameter count mismatch.");
        }
    }

    private boolean recursiveAddSubtypeConstraints(LabelChecker lc, Position pos, Type supertype, Type subtype, final boolean inNonConstArrayType) throws SemanticException {
        if (Report.should_report((String)"types", (int)2)) {
            Report.report((int)2, (String)("Adding subtype constraints: " + supertype + " >= " + subtype));
        }
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        Type unlblSupertype = ts.unlabel(supertype);
        Type unlblSubtype = ts.unlabel(subtype);
        if (ts.isLabeled(supertype) && ts.isLabeled(subtype)) {
            final Type lOrigSubtype = this.origSubtype;
            final Type lOrigSupertype = this.origSupertype;
            lc.constrain(new NamedLabel("label of type " + subtype, ts.labelOfType(subtype)), LabelConstraint.LEQ, new NamedLabel("label of type " + supertype, ts.labelOfType(supertype)), A.labelEnv(), pos, !(ts.labelOfType(subtype) instanceof VarLabel) && !(ts.labelOfType(supertype) instanceof VarLabel), new ConstraintMessage(){

                public String msg() {
                    String s = lOrigSubtype + " is not a subtype of " + lOrigSupertype + ".";
                    if (inNonConstArrayType) {
                        s = s + " The base type of arrays must be equivalent.";
                    }
                    return s;
                }

                public String detailMsg() {
                    if (inNonConstArrayType) {
                        return lOrigSubtype + " is not a subtype of " + lOrigSupertype + ". Subtyping requires " + "the base types of arrays to be equivalent.";
                    }
                    return lOrigSubtype + " is not a subtype of " + lOrigSupertype + ". Subtyping requires " + "the label of the subtype to be less " + "restrictive than the label of the " + "supertype.";
                }
            });
        }
        if (unlblSupertype instanceof JifClassType && unlblSubtype.isNull()) {
            return true;
        }
        if (unlblSubtype instanceof JifClassType && unlblSupertype instanceof JifClassType) {
            JifClassType sub = (JifClassType)unlblSubtype;
            JifClassType sup = (JifClassType)unlblSupertype;
            LinkedList<JifClassType> subPossibles = new LinkedList<JifClassType>();
            subPossibles.add(sub);
            HashSet<JifClassType> checkedPossibles = new HashSet<JifClassType>();
            while (!subPossibles.isEmpty()) {
                JifClassType poss = (JifClassType)subPossibles.removeFirst();
                if (ts.equalsStrip((TypeObject)SubtypeChecker.polyTypeForClass(poss), (TypeObject)SubtypeChecker.polyTypeForClass(sup))) {
                    this.addParamConstraints(lc, pos, sup, poss);
                    return true;
                }
                checkedPossibles.add(poss);
                Type possParent = poss.superType();
                if (possParent instanceof JifClassType && !checkedPossibles.contains(possParent) && !subPossibles.contains(possParent)) {
                    subPossibles.add((JifClassType)possParent);
                }
                for (Type possInterface : poss.interfaces()) {
                    if (!(possInterface instanceof JifClassType) || checkedPossibles.contains(possInterface) || subPossibles.contains(possInterface)) continue;
                    subPossibles.add((JifClassType)possInterface);
                }
            }
            return false;
        }
        if (unlblSubtype instanceof ArrayType && unlblSupertype instanceof ArrayType) {
            Type subBase = ((ArrayType)unlblSubtype).base();
            Type supBase = ((ArrayType)unlblSupertype).base();
            boolean superIsConst = false;
            boolean superIsNonConst = false;
            boolean subIsBoth = false;
            if (unlblSupertype instanceof ConstArrayType) {
                ConstArrayType unlblSuperCat = (ConstArrayType)unlblSupertype;
                superIsConst = unlblSuperCat.isConst();
                superIsNonConst = unlblSuperCat.isNonConst();
            }
            if (unlblSubtype instanceof ConstArrayType) {
                ConstArrayType unlblSubCat = (ConstArrayType)unlblSubtype;
                boolean bl = subIsBoth = unlblSubCat.isConst() && unlblSubCat.isNonConst();
            }
            if (!(!superIsConst || subIsBoth || unlblSubtype instanceof ConstArrayType && ((ConstArrayType)unlblSubtype).isConst())) {
                throw new SemanticException("A normal array is not a subtype of a const array", pos);
            }
            if (superIsNonConst && !subIsBoth && unlblSubtype instanceof ConstArrayType && !((ConstArrayType)unlblSubtype).isNonConst()) {
                throw new SemanticException("A const array is not a subtype of a non-const array", pos);
            }
            if (superIsConst || subIsBoth ? !this.recursiveAddSubtypeConstraints(lc, pos, supBase, subBase, false) : !this.recursiveAddSubtypeConstraints(lc, pos, subBase, supBase, true) || !this.recursiveAddSubtypeConstraints(lc, pos, supBase, subBase, true)) {
                return false;
            }
        }
        return true;
    }

    public static JifPolyType polyTypeForClass(JifClassType jct) {
        if (jct instanceof JifPolyType) {
            return (JifPolyType)jct;
        }
        if (jct instanceof JifSubstType) {
            return (JifPolyType)((JifSubstType)jct).base();
        }
        throw new InternalCompilerError("Unexpected JifClassType instance.Expected a JifPolyType or JifSubstType, but got " + jct.getClass().getName(), jct.position());
    }
}

