/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.extension.JifStmtExt_c;
import jif.extension.SubtypeChecker;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.JifMethodInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Return;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;

public class JifReturnExt
extends JifStmtExt_c {
    public JifReturnExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheckStmt(LabelChecker lc) throws SemanticException {
        PathMap X;
        Return rs = (Return)this.node();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)rs.del().enterScope((Context)A);
        Expr e = null;
        if (rs.expr() == null) {
            X = ts.pathMap();
            X = X.R(A.pc());
            X = X.NV(ts.notTaken());
        } else {
            e = (Expr)lc.context(A).labelCheck((Node)rs.expr());
            PathMap Xe = JifReturnExt.getPathMap((Node)e);
            X = Xe.N(ts.notTaken()).NV(ts.notTaken());
            X = X.R(Xe.N());
            CodeInstance ci = A.currentCode();
            if (!(ci instanceof MethodInstance)) {
                throw new SemanticException("Cannot return a value from " + ci + ".");
            }
            JifMethodInstance mi = (JifMethodInstance)ci;
            final Type retType = mi.returnType();
            Label Lr = lc.upperBound(mi.returnLabel(), ts.callSitePCLabel(mi));
            Label Lrv = null;
            if (!ts.isLabeled(retType)) {
                throw new InternalCompilerError("Unexpected return type: " + retType);
            }
            Lrv = lc.upperBound(ts.labelOfType(retType), Lr);
            lc.constrain(new NamedLabel("rv", "the label of the value returned", Xe.NV()), LabelConstraint.LEQ, new NamedLabel("Lrv", "return value label of the method", Lrv), A.labelEnv(), rs.position(), new ConstraintMessage(){

                public String msg() {
                    return "This method may return a value with a more restrictive label than the declared return value label.";
                }

                public String detailMsg() {
                    return this.msg() + " The declared return type " + "of this method is " + retType + ". As such, values returned by this " + "method can have a label of at most " + this.namedRhs() + ".";
                }

                public String technicalMsg() {
                    return "this method may return a value with a more restrictive label than the declared return value label.";
                }
            });
            SubtypeChecker subtypeChecker = new SubtypeChecker(retType, e.type());
            subtypeChecker.addSubtypeConstraints(lc.context(A), e.position());
        }
        return JifReturnExt.updatePathMap((Node)rs.expr(e), X);
    }
}

