/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jif.ast.Jif_c;
import jif.extension.CallHelper;
import jif.extension.JifEndorseExprExt;
import jif.extension.JifProcedureDeclExt;
import jif.extension.SubtypeChecker;
import jif.translate.ToJavaExt;
import jif.types.ActsForConstraint;
import jif.types.Assertion;
import jif.types.AuthConstraint;
import jif.types.AutoEndorseConstraint;
import jif.types.CallerConstraint;
import jif.types.ConstraintMessage;
import jif.types.ExceptionPath;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifProcedureInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.LabelLeAssertion;
import jif.types.LabelSubstitution;
import jif.types.NamedLabel;
import jif.types.Path;
import jif.types.PathMap;
import jif.types.PrincipalConstraint;
import jif.types.SemanticDetailedException;
import jif.types.label.Label;
import jif.types.label.NotTaken;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.ast.ProcedureDecl;
import polyglot.main.Report;
import polyglot.types.ConstructorInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JifProcedureDeclExt_c
extends Jif_c
implements JifProcedureDeclExt {
    static String jif_verbose = "jif";

    public JifProcedureDeclExt_c(ToJavaExt toJava) {
        super(toJava);
    }

    protected List checkFormals(List formals, JifProcedureInstance ci, LabelChecker lc) throws SemanticException {
        ArrayList<Formal> newFormals = new ArrayList<Formal>(formals.size());
        boolean changed = false;
        for (Formal formal : formals) {
            Formal newFormal = (Formal)lc.labelCheck((Node)formal);
            if (newFormal != formal) {
                changed = true;
            }
            newFormals.add(newFormal);
        }
        if (changed) {
            return newFormals;
        }
        return formals;
    }

    protected Label checkEnforceSignature(JifProcedureInstance mi, LabelChecker lc) throws SemanticException {
        if (Report.should_report((String)jif_verbose, (int)2)) {
            Report.report((int)2, (String)("Adding constraints for header of " + mi));
        }
        JifContext A = lc.jifContext();
        Set newAuth = this.constrainAuth(mi, A);
        for (Principal p : newAuth) {
            this.checkActsForAuthority(p, A, lc);
        }
        JifProcedureDeclExt_c.addCallers(mi, A, newAuth);
        A.setAuthority(newAuth);
        JifProcedureDeclExt_c.constrainLabelEnv(mi, A, null);
        this.checkConstraintVariance(mi, lc);
        Label Li = this.checkAutoEndorseConstrainPC(mi, lc);
        return Li;
    }

    protected Label checkAutoEndorseConstrainPC(JifProcedureInstance mi, LabelChecker lc) throws SemanticException {
        JifContext A = lc.jifContext();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifClassType ct = (JifClassType)A.currentClass();
        Label Li = mi.pcBound();
        Label endorseTo = ts.topLabel();
        for (Assertion c : mi.constraints()) {
            if (!(c instanceof AutoEndorseConstraint)) continue;
            AutoEndorseConstraint ac = (AutoEndorseConstraint)c;
            endorseTo = ts.meet(endorseTo, ac.endorseTo());
        }
        Label callerPcLabel = ts.callSitePCLabel(mi);
        if (!mi.flags().isStatic()) {
            A.addAssertionLE(ct.thisLabel(), callerPcLabel);
        }
        A.setPc(callerPcLabel, lc);
        Label initialPCBound = Li;
        if (!endorseTo.isTop()) {
            JifEndorseExprExt.checkOneDimen(lc, A, Li, endorseTo, mi.position(), false, true);
            JifEndorseExprExt.checkAuth(lc, A, Li, endorseTo, mi.position(), false, true);
            initialPCBound = endorseTo;
            A.addAssertionLE(callerPcLabel, endorseTo);
        }
        A.setCurrentCodePCBound(initialPCBound);
        return initialPCBound;
    }

    protected Set constrainAuth(JifProcedureInstance mi, JifContext A) {
        LinkedHashSet<Principal> newAuth = new LinkedHashSet<Principal>();
        for (Assertion c : mi.constraints()) {
            if (!(c instanceof AuthConstraint)) continue;
            AuthConstraint ac = (AuthConstraint)c;
            for (Principal pi : ac.principals()) {
                newAuth.add(pi);
            }
        }
        return newAuth;
    }

    protected static void addCallers(JifProcedureInstance mi, JifContext A, Set auth) {
        for (Assertion c : mi.constraints()) {
            if (!(c instanceof CallerConstraint)) continue;
            CallerConstraint cc = (CallerConstraint)c;
            for (Principal pi : cc.principals()) {
                auth.add(pi);
            }
        }
    }

    protected void checkActsForAuthority(final Principal p, final JifContext A, LabelChecker lc) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        Principal authority = ts.conjunctivePrincipal(null, A.authority());
        String codeName = A.currentCode().toString();
        if (A.currentCode() instanceof JifProcedureInstance) {
            codeName = ((JifProcedureInstance)A.currentCode()).debugString();
        }
        final String msgCodeName = codeName;
        lc.constrain(authority, PrincipalConstraint.ACTSFOR, p, A.labelEnv(), A.currentCode().position(), new ConstraintMessage(){

            public String msg() {
                return "The authority of the class " + A.currentClass().name() + " is insufficient to act for principal " + p + ".";
            }

            public String detailMsg() {
                return "The " + msgCodeName + " states that it has the authority of the " + "principal " + p + ". However, the conjunction of the authority" + " set of the class is insufficient to act for " + p + ".";
            }
        });
    }

    protected static void constrainLabelEnv(JifProcedureInstance mi, JifContext A, CallHelper ch) throws SemanticException {
        for (Assertion c : mi.constraints()) {
            if (c instanceof ActsForConstraint) {
                ActsForConstraint ac = (ActsForConstraint)c;
                Principal actor = ac.actor();
                Principal granter = ac.granter();
                if (ch != null) {
                    actor = ch.instantiate(A, actor);
                    granter = ch.instantiate(A, granter);
                }
                if (ac.isEquiv()) {
                    A.addEquiv(actor, granter);
                } else {
                    A.addActsFor(actor, granter);
                }
            }
            if (!(c instanceof LabelLeAssertion)) continue;
            LabelLeAssertion lla = (LabelLeAssertion)c;
            Label lhs = lla.lhs();
            Label rhs = lla.rhs();
            if (ch != null) {
                lhs = ch.instantiate(A, lhs);
                rhs = ch.instantiate(A, rhs);
            }
            A.addAssertionLE(lhs, rhs);
        }
    }

    protected void addReturnConstraints(Label Li, PathMap X, JifProcedureInstance mi, LabelChecker lc, Type returnType) throws SemanticException {
        if (Report.should_report((String)jif_verbose, (int)2)) {
            Report.report((int)2, (String)("Adding constraints for result of " + mi));
        }
        ProcedureDecl mn = (ProcedureDecl)this.node();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        Label Lr = lc.upperBound(mi.returnLabel(), ts.callSitePCLabel(mi));
        if (!(X.N() instanceof NotTaken)) {
            boolean singlePath = true;
            for (Path p : X.paths()) {
                if (p.equals(Path.N) || p.equals(Path.R)) continue;
                singlePath = false;
                break;
            }
            if (singlePath) {
                X = X.N(ts.notTaken());
                X = X.R(ts.bottomLabel());
            }
        }
        lc.constrain(new NamedLabel("X.n", "information that may be gained by the body terminating normally", X.N()).join(lc, "X.r", "information that may be gained by exiting the body with a return statement", X.R()), LabelConstraint.LEQ, new NamedLabel("Lr", "return label of the method", Lr), A.labelEnv(), mn.position(), new ConstraintMessage(){

            public String msg() {
                return "The non-exception termination of the method body may reveal more information than is declared by the method return label.";
            }

            public String detailMsg() {
                return "The method return label, " + this.namedRhs() + ", is an upper bound on how much " + "information can be gained by observing " + "that this method terminates normally " + "(i.e., terminates without throwing " + "an exception). The method body may " + "reveal more information than this. The " + "return label of a method is declared " + "after the variables, e.g. " + "\"void m(int i):{" + this.namedRhs() + "}\".";
            }

            public String technicalMsg() {
                return "the return(end) label is less restrict than " + this.namedLhs() + " of the body.";
            }
        });
        for (Path path : X.paths()) {
            if (!(path instanceof ExceptionPath)) continue;
            ExceptionPath ep = (ExceptionPath)path;
            Label pathLabel = X.get(ep);
            if (pathLabel instanceof NotTaken) {
                throw new InternalCompilerError("An exception path cannot be not taken");
            }
            Type pathType = ep.exception();
            NamedLabel pathNamedLabel = new NamedLabel("exc_" + pathType.toClass().name(), "upper bound on information that may be gained by observing the method throwing the exception " + pathType.toClass().name(), pathLabel);
            for (final Type tj : mi.throwTypes()) {
                SubtypeChecker subtypeChecker;
                Label Lj = ts.labelOfType(tj, Lr);
                Lj = lc.upperBound(Lj, ts.callSitePCLabel(mi));
                if (!ts.isSubtype(pathType, tj) && !ts.isSubtype(tj, pathType)) continue;
                if (ts.isSubtype(pathType, tj)) {
                    subtypeChecker = new SubtypeChecker(tj, pathType);
                    subtypeChecker.addSubtypeConstraints(lc, mn.position());
                } else {
                    subtypeChecker = new SubtypeChecker(pathType, tj);
                    subtypeChecker.addSubtypeConstraints(lc, mn.position());
                }
                if (Report.should_report((String)jif_verbose, (int)4)) {
                    Report.report((int)4, (String)(">>> X[C'] <= Lj (for exception " + tj + ")"));
                }
                lc.constrain(pathNamedLabel, LabelConstraint.LEQ, new NamedLabel("decl_exc_" + tj.toClass().name(), "declared upper bound on information that may be gained by observing the method throwing the exception " + tj.toClass().name(), Lj), A.labelEnv(), mi.position(), new ConstraintMessage(){

                    public String msg() {
                        return "More information may be gained by observing a " + tj.toClass().fullName() + " exception than is permitted by the " + "method/constructor signature";
                    }

                    public String technicalMsg() {
                        return "the path of <" + tj + "> may leak information " + "more restrictive than the join of the declared " + "exception label and the return(end) label";
                    }
                });
            }
        }
    }

    protected void checkConstraintVariance(JifProcedureInstance mi, LabelChecker lc) throws SemanticException {
        if (!(lc.context().currentCode() instanceof ConstructorInstance)) {
            for (Assertion c : mi.constraints()) {
                if (!(c instanceof LabelLeAssertion)) continue;
                LabelLeAssertion lle = (LabelLeAssertion)c;
                lle.rhs().subst(new ConstraintVarianceLabelChecker(c.position()));
            }
        }
    }

    protected static class ConstraintVarianceLabelChecker
    extends LabelSubstitution {
        private Position declPosition;

        ConstraintVarianceLabelChecker(Position declPosition) {
            this.declPosition = declPosition;
        }

        public Label substLabel(Label L) throws SemanticException {
            if (L.isCovariant()) {
                throw new SemanticDetailedException("Covariant labels cannot occur on the right hand side of label constraints.", "The right hand side of a label constraint cannot contain the covariant components such as " + L + ". ", this.declPosition);
            }
            return L;
        }
    }
}

