/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.List;
import jif.ast.JifMethodDecl;
import jif.ast.JifMethodDecl_c;
import jif.extension.JifProcedureDeclDel;
import jif.types.ActsForConstraint;
import jif.types.Assertion;
import jif.types.CallerConstraint;
import jif.types.JifClassType;
import jif.types.JifMethodInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelLeAssertion;
import jif.types.SemanticDetailedException;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathLocal;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import polyglot.ast.Formal;
import polyglot.ast.Node;
import polyglot.types.ArrayType;
import polyglot.types.CodeInstance;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.ErrorQueue;
import polyglot.visit.TypeChecker;

public class JifMethodDeclDel
extends JifProcedureDeclDel {
    public Context enterScope(Context c) {
        JifMethodDecl jmd = (JifMethodDecl)this.node();
        JifMethodInstance mi = JifMethodDecl_c.unrenameArgs((JifMethodInstance)jmd.methodInstance());
        c = c.pushCode((CodeInstance)mi);
        this.addFormalsToScope(c);
        return c;
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        JifMethodDecl jmd = (JifMethodDecl)this.node();
        if (jmd.name().indexOf(36) >= 0) {
            throw new SemanticException("Method names can not contain the character '$'.");
        }
        JifMethodInstance mi = JifMethodDecl_c.unrenameArgs((JifMethodInstance)jmd.methodInstance());
        if ("main".equals(mi.name()) && mi.flags().isStatic()) {
            Type formal0;
            JifClassType currClass = (JifClassType)tc.context().currentClass();
            if (currClass.actuals().size() > 0) {
                throw new SemanticDetailedException("A parameterized class can not have a \"main\" method.", "Parameterized classes cannot have a main method, as the invoker of the main method has no way to specify instantiations of the class parameters.", mi.position());
            }
            boolean wrongSig = true;
            List formalTypes = mi.formalTypes();
            String principalArgName = null;
            JifTypeSystem jts = (JifTypeSystem)tc.typeSystem();
            ArrayType stringArrayType = jts.arrayOf((Type)jts.String());
            if (formalTypes.size() == 1) {
                formal0 = jts.unlabel((Type)formalTypes.get(0));
                if (formal0.equals(stringArrayType)) {
                    wrongSig = false;
                }
            } else if (formalTypes.size() == 2) {
                formal0 = jts.unlabel((Type)formalTypes.get(0));
                Type formal1 = jts.unlabel((Type)formalTypes.get(1));
                if (formal0.equals(jts.Principal()) && formal1.equals(stringArrayType)) {
                    wrongSig = false;
                    principalArgName = ((Formal)jmd.formals().get(0)).name();
                }
            }
            if (wrongSig) {
                ErrorQueue eq = tc.errorQueue();
                eq.enqueue(0, "The signature of an invocable main method in a Jif class should either be \"main(String[] args)\" or \"main(principal p, String[] args)\" where p will be the user invoking the main method. This method may have an incorrect signature.", mi.position());
            }
            for (Assertion constraint : mi.constraints()) {
                Principal callerP;
                if (constraint instanceof ActsForConstraint || constraint instanceof LabelLeAssertion) {
                    throw new SemanticDetailedException("The main method of a class can not have actsfor or label constraint annotations.", "The main method of a class can not have actsfor or label constraint annotations, as these constraints are not guaranteed to hold when the program is invoked. Use runtime tests to establish these constraints.", constraint.position());
                }
                if (!(constraint instanceof CallerConstraint)) continue;
                CallerConstraint cc = (CallerConstraint)constraint;
                boolean callerOK = false;
                if (cc.principals().size() == 1 && (callerP = (Principal)cc.principals().get(0)) instanceof DynamicPrincipal) {
                    AccessPath ap = ((DynamicPrincipal)callerP).path();
                    boolean bl = callerOK = ap instanceof AccessPathLocal && ((AccessPathLocal)ap).name().equals(principalArgName);
                }
                if (callerOK) continue;
                throw new SemanticException("The main method of a class can only have a where caller constraint of the principal given as an argument to the main method.", constraint.position());
            }
        }
        return super.typeCheck(tc);
    }
}

