/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.extension.JifJL_c;
import jif.types.ConstArrayType;
import jif.types.JifLocalInstance;
import jif.types.JifTypeSystem;
import jif.visit.JifTypeChecker;
import polyglot.ast.LocalDecl;
import polyglot.ast.Node;
import polyglot.types.ArrayType;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeBuilder;
import polyglot.visit.TypeChecker;

public class JifLocalDeclDel
extends JifJL_c {
    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        LocalDecl n = (LocalDecl)super.buildTypes(tb);
        JifTypeSystem jts = (JifTypeSystem)tb.typeSystem();
        JifLocalInstance li = (JifLocalInstance)n.localInstance();
        li.setLabel(jts.freshLabelVariable(li.position(), li.name(), "label of the local variable " + li.name()));
        return n.localInstance((LocalInstance)li);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        LocalDecl n = (LocalDecl)this.node();
        LocalInstance li = n.localInstance();
        li.setFlags(n.flags());
        li.setName(n.name());
        li.setType(n.declType());
        return n;
    }

    public NodeVisitor typeCheckEnter(TypeChecker tc) throws SemanticException {
        JifTypeChecker jtc = (JifTypeChecker)super.typeCheckEnter(tc);
        return jtc.inferClassParameters(true);
    }

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        LocalDecl ld = (LocalDecl)this.node();
        if (ld.flags().isFinal() && ld.init() == null) {
            throw new SemanticException("Final local variables must have an initializing expression.", ld.position());
        }
        ld.localInstance().setType(ld.declType());
        if (ld.localInstance().type().isArray()) {
            JifTypeSystem jts = (JifTypeSystem)tc.typeSystem();
            ArrayType at = jts.unlabel(ld.localInstance().type()).toArray();
            JifLocalDeclDel.checkArrayTypeConsistency(at);
        }
        return super.typeCheck(tc);
    }

    static void checkArrayTypeConsistency(ArrayType at) throws SemanticException {
        JifTypeSystem jts;
        Type base;
        boolean isConst = false;
        if (at instanceof ConstArrayType) {
            ConstArrayType cat = (ConstArrayType)at;
            isConst = cat.isConst();
        }
        if ((base = (jts = (JifTypeSystem)at.typeSystem()).unlabel(at.base())).isArray()) {
            boolean baseConst = false;
            if (base instanceof ConstArrayType) {
                ConstArrayType cat = (ConstArrayType)base;
                baseConst = cat.isConst();
            }
            if (isConst != baseConst) {
                throw new SemanticException("A const modifier for an array must apply to all dimensions.");
            }
            JifLocalDeclDel.checkArrayTypeConsistency(base.toArray());
        }
    }
}

