/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.ast.JifUtil;
import jif.extension.JifBinaryDel;
import jif.extension.JifStmtExt_c;
import jif.translate.ToJavaExt;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.ast.Binary;
import polyglot.ast.Expr;
import polyglot.ast.If;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.ast.Unary;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.ErrorQueue;

public class JifIfExt
extends JifStmtExt_c {
    public JifIfExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheckStmt(LabelChecker lc) throws SemanticException {
        PathMap X2;
        If is = (If)this.node();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)is.del().enterScope((Context)A);
        Expr e = (Expr)lc.context(A).labelCheck((Node)is.cond());
        PathMap Xe = JifIfExt.getPathMap((Node)e);
        A = (JifContext)A.pushBlock();
        A.setPc(Xe.NV(), lc);
        JifIfExt.extendContext(lc, A, e, false);
        Stmt S1 = (Stmt)lc.context(A).labelCheck((Node)is.consequent());
        A = (JifContext)A.pop();
        PathMap X1 = JifIfExt.getPathMap((Node)S1);
        Stmt S2 = null;
        if (is.alternative() != null) {
            A = (JifContext)A.pushBlock();
            A.setPc(Xe.NV(), lc);
            S2 = (Stmt)lc.context(A).labelCheck((Node)is.alternative());
            A = (JifContext)A.pop();
            X2 = JifIfExt.getPathMap((Node)S2);
        } else {
            X2 = ts.pathMap().N(Xe.NV());
        }
        PathMap X = Xe.N(ts.notTaken()).join(X1).join(X2);
        X = X.NV(ts.notTaken());
        return JifIfExt.updatePathMap((Node)is.cond(e).consequent(S1).alternative(S2), X);
    }

    protected static void extendContext(LabelChecker lc, JifContext A, Expr e, boolean warn) throws SemanticException {
        Unary u;
        if (e instanceof Binary) {
            Binary b = (Binary)e;
            if (b.operator() == Binary.BIT_AND || b.operator() == Binary.COND_AND) {
                JifIfExt.extendContext(lc, A, b.left(), warn);
                JifIfExt.extendContext(lc, A, b.right(), warn);
            }
            if (b.operator() == Binary.BIT_OR || b.operator() == Binary.COND_OR) {
                JifIfExt.extendContext(lc, A, b.left(), true);
                JifIfExt.extendContext(lc, A, b.right(), true);
            }
        }
        if (e instanceof Unary && (u = (Unary)e).operator() == Unary.NOT && u.expr() instanceof Binary) {
            JifIfExt.extendContext(lc, A, u.expr(), true);
        }
        JifIfExt.extendFact(lc, A, e, warn);
    }

    protected static void extendFact(LabelChecker lc, JifContext A, Expr e, boolean warn) throws SemanticException {
        Unary u;
        if (e instanceof Binary) {
            JifIfExt.extendFact(lc, A, (Binary)e, warn);
        }
        if (e instanceof Unary && (u = (Unary)e).expr() instanceof Binary) {
            JifIfExt.extendFact(lc, A, (Binary)u.expr(), true);
        }
    }

    protected static void extendFact(LabelChecker lc, JifContext A, Binary b, boolean warn) throws SemanticException {
        JifTypeSystem ts = lc.typeSystem();
        Binary.Operator op = b.operator();
        if (op == JifBinaryDel.ACTSFOR) {
            Principal actor = JifUtil.exprToPrincipal(ts, b.left(), A);
            Principal granter = JifUtil.exprToPrincipal(ts, b.right(), A);
            if (warn) {
                ErrorQueue eq = lc.errorQueue();
                eq.enqueue(0, "The Jif compiler can only reason about actsfor tests if they occur as conjuncts in the conditional of an if statement.", b.position());
            } else {
                A.addActsFor(actor, granter);
            }
        } else if (op == JifBinaryDel.EQUIV && ts.isImplicitCastValid(b.left().type(), (Type)ts.Principal())) {
            Principal left = JifUtil.exprToPrincipal(ts, b.left(), A);
            Principal right = JifUtil.exprToPrincipal(ts, b.right(), A);
            if (warn) {
                ErrorQueue eq = lc.errorQueue();
                eq.enqueue(0, "The Jif compiler can only reason about actsfor tests if they occur as conjuncts in the conditional of an if statement.", b.position());
            } else {
                A.addEquiv(left, right);
            }
        } else if (op == JifBinaryDel.EQUIV && ts.isLabel(b.left().type())) {
            Label lhs = JifUtil.exprToLabel(ts, b.left(), A);
            Label rhs = JifUtil.exprToLabel(ts, b.right(), A);
            if (warn) {
                ErrorQueue eq = lc.errorQueue();
                eq.enqueue(0, "The Jif compiler can only reason about label tests if they occur as conjuncts in the conditional of an if statement.", b.position());
            } else {
                A.addEquiv(lhs, rhs);
            }
        } else if (op == Binary.LE && ts.isLabel(b.left().type())) {
            Label lhs = JifUtil.exprToLabel(ts, b.left(), A);
            Label rhs = JifUtil.exprToLabel(ts, b.right(), A);
            if (warn) {
                ErrorQueue eq = lc.errorQueue();
                eq.enqueue(0, "The Jif compiler can only reason about label tests if they occur as conjuncts in the conditional of an if statement.", b.position());
            } else {
                A.addAssertionLE(lhs, rhs);
            }
        }
    }
}

