/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.LinkedList;
import jif.extension.JifStmtExt_c;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.types.label.VarLabel;
import jif.visit.LabelChecker;
import polyglot.ast.Branch;
import polyglot.ast.Expr;
import polyglot.ast.For;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.types.Context;
import polyglot.types.SemanticException;

public class JifForExt
extends JifStmtExt_c {
    public JifForExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheckStmt(LabelChecker lc) throws SemanticException {
        PathMap Xe;
        For fs = (For)this.node();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)fs.del().enterScope((Context)A);
        Label notTaken = ts.notTaken();
        A = (JifContext)A.pushBlock();
        PathMap Xinit = ts.pathMap().N(A.pc());
        LinkedList<Stmt> inits = new LinkedList<Stmt>();
        for (Stmt s : fs.inits()) {
            s = (Stmt)lc.context(A).labelCheck((Node)s);
            inits.add(s);
            PathMap Xs = JifForExt.getPathMap((Node)s);
            A.setPc(Xs.N(), lc);
            Xinit = Xinit.N(notTaken).join(Xs);
        }
        VarLabel L1 = ts.freshLabelVariable(fs.position(), "for", "label of PC for the for statement at " + this.node().position());
        VarLabel L2 = ts.freshLabelVariable(fs.position(), "for", "label of PC for end of the for statement at " + this.node().position());
        A = (JifContext)A.pushBlock();
        Label loopEntryPC = A.pc();
        A.setPc(L1, lc);
        A.gotoLabel(Branch.CONTINUE, null, L1);
        A.gotoLabel(Branch.BREAK, null, L2);
        Expr cond = fs.cond();
        if (cond != null) {
            cond = (Expr)lc.context(A).labelCheck((Node)fs.cond());
            Xe = JifForExt.getPathMap((Node)cond);
        } else {
            Xe = ts.pathMap().NV(A.pc()).N(A.pc());
        }
        A = (JifContext)A.pushBlock();
        A.setPc(Xe.NV(), lc);
        Stmt body = (Stmt)lc.context(A).labelCheck((Node)fs.body());
        PathMap Xbody = JifForExt.getPathMap((Node)body);
        A = (JifContext)A.pushBlock();
        A.setPc(Xbody.N(), lc);
        LinkedList<Stmt> iters = new LinkedList<Stmt>();
        for (Stmt s : fs.iters()) {
            s = (Stmt)lc.context(A).labelCheck((Node)s);
            iters.add(s);
            PathMap Xs = JifForExt.getPathMap((Node)s);
            A.setPc(Xs.N(), lc);
            Xbody = Xbody.N(notTaken).join(Xs);
        }
        lc.constrain(new NamedLabel("for_body.N", "label of normal termination of the loop body", Xbody.N()).join(lc, "loop_entry_pc", "label of the program counter just before the loop is executed", loopEntryPC), LabelConstraint.LEQ, new NamedLabel("loop_pc", "label of the program counter at the top of the loop", L1), lc.context().labelEnv(), fs.position(), false, new ConstraintMessage(){

            public String msg() {
                return "The information revealed by the normal termination of the body of the for loop may be more restrictive than the information that should be revealed by reaching the top of the loop.";
            }

            public String detailMsg() {
                return "The program counter label at the start of the loop is at least as restrictive as the normal termination label of the loop body, and the entry program counter label (that is, the program counter label just before the loop is executed for the first time).";
            }

            public String technicalMsg() {
                return "X(loopbody).n <= _pc_ of the for statement";
            }
        });
        PathMap Xloop = Xe.join(Xbody);
        Xloop = Xloop.set(ts.gotoPath(Branch.CONTINUE, null), notTaken);
        Xloop = Xloop.set(ts.gotoPath(Branch.BREAK, null), notTaken);
        Xloop = Xloop.N(lc.upperBound(Xloop.N(), L2));
        PathMap X = Xinit.N(notTaken).join(Xloop);
        return JifForExt.updatePathMap((Node)fs.iters(iters).cond(cond).inits(inits).body(body), X);
    }
}

