/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import jif.ast.JifInstantiator;
import jif.ast.JifNodeFactory;
import jif.extension.JifExprExt;
import jif.extension.JifFieldDel;
import jif.translate.ToJavaExt;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.FieldAssign;
import polyglot.ast.IntLit;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JifFieldExt
extends JifExprExt {
    public JifFieldExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheckIncrement(LabelChecker lc) throws SemanticException {
        JifNodeFactory nf = (JifNodeFactory)lc.nodeFactory();
        lc.nodeFactory();
        Field fe = (Field)this.node();
        Position pos = fe.position();
        FieldAssign fae = nf.FieldAssign(pos, fe, Assign.ADD_ASSIGN, (Expr)nf.IntLit(pos, IntLit.INT, 1L));
        fae = (FieldAssign)lc.labelCheck((Node)fae);
        return fae.left();
    }

    public Node labelCheck(LabelChecker lc) throws SemanticException {
        JifContext A = lc.jifContext();
        JifTypeSystem ts = lc.jifTypeSystem();
        Field fe = (Field)this.node();
        Receiver target = JifFieldExt.checkTarget(lc, fe);
        PathMap Xe = JifFieldExt.getPathMap((Node)target);
        ArrayList throwTypes = new ArrayList(fe.del().throwTypes((TypeSystem)ts));
        if (!((JifFieldDel)this.node().del()).targetIsNeverNull()) {
            ClassType npe = ts.NullPointerException();
            JifFieldExt.checkAndRemoveThrowType(throwTypes, (Type)npe);
            Xe = Xe.exc(Xe.NV(), (Type)npe);
        }
        ReferenceType targetType = JifFieldExt.targetType(ts, A, target, fe);
        FieldInstance fi = ts.findField(targetType, fe.name());
        fe = fe.fieldInstance(fi);
        Label L = ts.labelOfField(fi, A.pc());
        if (target instanceof Expr) {
            Label objLabel = JifFieldExt.getPathMap((Node)target).NV();
            L = JifInstantiator.instantiate(L, A, (Expr)target, targetType, objLabel);
            Type ft = JifInstantiator.instantiate(fi.type(), A, (Expr)target, targetType, objLabel);
            fe = (Field)fe.type(ft);
        }
        PathMap X = Xe.NV(lc.upperBound(L, Xe.NV()));
        JifFieldExt.checkThrowTypes(throwTypes);
        return JifFieldExt.updatePathMap((Node)fe.target(target), X);
    }

    protected static Receiver checkTarget(LabelChecker lc, Field fe) throws SemanticException {
        JifTypeSystem ts = lc.jifTypeSystem();
        if (!(fe.target() instanceof Expr)) {
            JifContext A = lc.context();
            return (Receiver)JifFieldExt.updatePathMap((Node)fe.target(), ts.pathMap().N(A.pc()).NV(A.pc()));
        }
        Expr target = (Expr)lc.labelCheck((Node)fe.target());
        return target;
    }

    protected static ReferenceType targetType(JifTypeSystem ts, JifContext A, Receiver target, Field fe) {
        String name = fe.name();
        ClassType rt = A.currentClass();
        if (target instanceof Special) {
            Special st = (Special)target;
            if (st.kind() == Special.SUPER) {
                rt = (ReferenceType)A.currentClass().superType();
            } else {
                try {
                    FieldInstance fi = ts.findField((ReferenceType)rt, name);
                    rt = fi.container();
                }
                catch (SemanticException x) {
                    throw new InternalCompilerError("Cannot find the field " + name + " in " + rt, (Throwable)x);
                }
            }
        } else {
            rt = (ReferenceType)ts.unlabel(target.type());
        }
        return rt;
    }
}

