/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.ast.JifUtil;
import jif.ast.Jif_c;
import jif.extension.JifArrayInitExt;
import jif.extension.JifFieldDeclExt;
import jif.extension.SubtypeChecker;
import jif.translate.ToJavaExt;
import jif.types.ConstArrayType;
import jif.types.ConstraintMessage;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifFieldInstance;
import jif.types.JifSubstType;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.LabelSubstitution;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.SemanticDetailedException;
import jif.types.TypeSubstitutor;
import jif.types.label.CovariantParamLabel;
import jif.types.label.DynamicLabel;
import jif.types.label.Label;
import jif.types.label.ParamLabel;
import jif.types.label.ThisLabel;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.ParamPrincipal;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.ast.ArrayInit;
import polyglot.ast.Expr;
import polyglot.ast.FieldDecl;
import polyglot.ast.Node;
import polyglot.types.ArrayType;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JifFieldDeclExt_c
extends Jif_c
implements JifFieldDeclExt {
    public JifFieldDeclExt_c(ToJavaExt toJava) {
        super(toJava);
    }

    public void labelCheckField(LabelChecker lc, JifClassType ct) throws SemanticException {
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        FieldDecl decl = (FieldDecl)this.node();
        JifFieldInstance fi = (JifFieldInstance)decl.fieldInstance();
        Label L = fi.label();
        Type t = decl.declType();
        if (!ts.isLabeled(t)) {
            throw new InternalCompilerError("Unexpectedly unlabeled field", this.node().position());
        }
        Label declaredLabel = ts.labelOfType(t);
        lc.constrain(new NamedLabel("field_label", "inferred label of field " + fi.name(), L), LabelConstraint.EQUAL, new NamedLabel("declared label of field " + fi.name(), declaredLabel), A.labelEnv(), decl.position());
    }

    public Node labelCheck(LabelChecker lc) throws SemanticException {
        PathMap Xd;
        FieldDecl decl = (FieldDecl)this.node();
        final JifFieldInstance fi = (JifFieldInstance)decl.fieldInstance();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        A = (JifContext)decl.del().enterScope((Context)A);
        Type fieldType = fi.type();
        InvarianceLabelSubstr tsb = new InvarianceLabelSubstr(decl.position());
        if (decl.flags().isFinal()) {
            tsb.rewriteType(ts.unlabel(fieldType));
        } else {
            tsb.rewriteType(fieldType);
        }
        if (decl.flags().isStatic()) {
            TypeSubstitutor tsb2 = new TypeSubstitutor(new StaticFieldLabelChecker(decl.position()));
            tsb2.rewriteType(fi.type());
        }
        Label L = fi.label();
        Type t = decl.declType();
        if (!ts.isLabeled(t)) {
            throw new InternalCompilerError("Unexpectedly unlabeled field", this.node().position());
        }
        Label declaredLabel = ts.labelOfType(t);
        lc.constrain(new NamedLabel("field_label", "inferred label of field " + fi.name(), L), LabelConstraint.EQUAL, new NamedLabel("PC", "Information revealed by program counter being at this program point", A.pc()).join(lc, "declared label of field " + fi.name(), declaredLabel), A.labelEnv(), decl.position());
        Expr init = decl.init();
        if (decl.init() != null) {
            LabelChecker lcInit;
            A = (JifContext)A.pushBlock();
            A.setCurrentCodePCBound(ts.topLabel());
            JifClassType jct = (JifClassType)A.currentClass();
            A.addAssertionLE(jct.thisLabel(), ts.bottomLabel());
            if (fi.flags().isFinal() && JifUtil.isFinalAccessExprOrConst(ts, init)) {
                if (ts.isLabel(fi.type())) {
                    DynamicLabel dl = ts.dynamicLabel(fi.position(), JifUtil.varInstanceToAccessPath(fi, fi.position()));
                    Label rhs_label = JifUtil.exprToLabel(ts, init, A);
                    A.addDefinitionalAssertionEquiv(dl, rhs_label, true);
                } else if (ts.isImplicitCastValid(fi.type(), (Type)ts.Principal())) {
                    DynamicPrincipal dp = ts.dynamicPrincipal(fi.position(), JifUtil.varInstanceToAccessPath(fi, fi.position()));
                    Principal rhs_principal = JifUtil.exprToPrincipal(ts, init, A);
                    A.addDefinitionalEquiv(dp, rhs_principal);
                }
            }
            if ((init = (Expr)(lcInit = lc.context(A)).labelCheck((Node)decl.init())) instanceof ArrayInit) {
                ((JifArrayInitExt)JifUtil.jifExt((Node)init)).labelCheckElements(lcInit, decl.type().type());
            } else {
                SubtypeChecker subtypeChecker = new SubtypeChecker(t, init.type());
                subtypeChecker.addSubtypeConstraints(lcInit, init.position());
            }
            PathMap Xe = JifFieldDeclExt_c.getPathMap((Node)init);
            lcInit.constrain(new NamedLabel("init.nv", "label of successful evaluation of initializing expression", Xe.NV()), LabelConstraint.LEQ, new NamedLabel("label of field " + fi.name(), L), A.labelEnv(), init.position(), new ConstraintMessage(){

                public String msg() {
                    return "Label of field initializer not less restrictive than the label for field " + fi.name();
                }

                public String detailMsg() {
                    return "More information is revealed by the successful evaluation of the intializing expression than is allowed to flow to the field " + fi.name() + ".";
                }

                public String technicalMsg() {
                    return "Invalid assignment: NV of initializer is more restrictive than the declared label of field " + fi.name() + ".";
                }
            });
            Xd = Xe;
            A = (JifContext)A.pop();
        } else {
            Xd = ts.pathMap();
        }
        decl = (FieldDecl)JifFieldDeclExt_c.updatePathMap((Node)decl.init(init), Xd);
        return decl;
    }

    protected static class InvarianceLabelChecker
    extends LabelSubstitution {
        private Position declPosition;

        InvarianceLabelChecker(Position declPosition) {
            this.declPosition = declPosition;
        }

        public Label substLabel(Label L) throws SemanticException {
            if (L instanceof ThisLabel) {
                throw new SemanticDetailedException("The label of a non-final field, or a mutable location within a final field can not contain the label \"this\".", "The label of a non-final field, or a mutable location within a final field (such as the label of elements of an array) can not contain the label \"this\". Otherwise, sensitive information could be written into the location through a sensitive reference to the object, and converted to non-sensitive information by reading the value through a non-sensitive reference.", this.declPosition);
            }
            if (L.isCovariant()) {
                throw new SemanticDetailedException("The label of a non-final field, or a mutable location within a final field can not contain the covariant component " + L, "The label of a non-final field, or a mutable location within a final field (such as the label of elements of an array) can not contain the covariant component " + L + ". " + "Otherwise, sensitive " + "information could be written into the location " + "through a reference to the object with a sensitive type, " + "and converted to non-sensitive information by reading " + "the value through a reference with a less sensitive type.", this.declPosition);
            }
            return L;
        }
    }

    protected static class InvarianceLabelSubstr
    extends TypeSubstitutor {
        protected boolean recurseIntoSubstType(JifSubstType type) {
            return false;
        }

        protected boolean recurseIntoArrayType(ArrayType type) {
            ConstArrayType cat;
            return !(type instanceof ConstArrayType) || !(cat = (ConstArrayType)type).isConst();
        }

        public InvarianceLabelSubstr(Position pos) {
            super(new InvarianceLabelChecker(pos));
        }
    }

    protected static class StaticFieldLabelChecker
    extends LabelSubstitution {
        private Position declPosition;

        StaticFieldLabelChecker(Position declPosition) {
            this.declPosition = declPosition;
        }

        public Label substLabel(Label L) throws SemanticException {
            if (L instanceof ThisLabel) {
                throw new SemanticException("The label of a static field cannot use the \"this\" label.", this.declPosition);
            }
            if (L instanceof ParamLabel || L instanceof CovariantParamLabel) {
                throw new SemanticException("The label of a static field cannot use the label parameter " + L.componentString(), this.declPosition);
            }
            return L;
        }

        public Principal substPrincipal(Principal p) throws SemanticException {
            if (p instanceof ParamPrincipal) {
                throw new SemanticException("The label of a static field cannot use the principal parameter " + p.toString(), this.declPosition);
            }
            return p;
        }
    }
}

