/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.List;
import jif.ast.JifInstantiator;
import jif.ast.JifUtil;
import jif.extension.JifAssignExt;
import jif.extension.JifFieldDel;
import jif.extension.JifFieldExt;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifFieldInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.DynamicLabel;
import jif.types.label.Label;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.ast.Assign;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.types.ClassType;
import polyglot.types.FieldInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;

public class JifFieldAssignExt
extends JifAssignExt {
    public JifFieldAssignExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheckLHS(LabelChecker lc) throws SemanticException {
        Assign assign = (Assign)this.node();
        Field fe = (Field)assign.left();
        JifTypeSystem ts = lc.jifTypeSystem();
        JifContext A = lc.jifContext();
        ArrayList throwTypes = new ArrayList(assign.del().throwTypes((TypeSystem)ts));
        ClassType npe = ts.NullPointerException();
        ClassType are = ts.ArithmeticException();
        Receiver target = JifFieldExt.checkTarget(lc, fe);
        PathMap Xe = JifFieldAssignExt.getPathMap((Node)target);
        A = (JifContext)A.pushBlock();
        A.setPc(Xe.N(), lc);
        Expr rhs = (Expr)lc.context(A).labelCheck((Node)assign.right());
        PathMap Xr = this.rhsPathMap(lc.context(A), rhs, throwTypes);
        A = (JifContext)A.pop();
        PathMap X = Xe.join(Xr);
        if (assign.throwsArithmeticException()) {
            JifFieldAssignExt.checkAndRemoveThrowType(throwTypes, (Type)are);
            X = X.exc(Xr.NV(), (Type)are);
        }
        if (!((JifFieldDel)fe.del()).targetIsNeverNull()) {
            JifFieldAssignExt.checkAndRemoveThrowType(throwTypes, (Type)npe);
            X = X.exc(lc.upperBound(Xe.NV(), Xr.N()), (Type)npe);
        }
        ReferenceType targetType = JifFieldExt.targetType(ts, A, target, fe);
        final JifFieldInstance fi = (JifFieldInstance)ts.findField(targetType, fe.name());
        fe = fe.fieldInstance((FieldInstance)fi);
        Label Lf = ts.labelOfField(fi, A.pc());
        if (target instanceof Expr) {
            if (!(target instanceof Special)) {
                Lf = JifInstantiator.instantiate(Lf, A, (Expr)target, JifFieldExt.targetType(ts, A, target, fe), JifFieldAssignExt.getPathMap((Node)target).NV());
            } else {
                JifClassType jct = (JifClassType)A.currentClass();
                Lf = JifInstantiator.instantiate(Lf, A, (Expr)target, JifFieldExt.targetType(ts, A, target, fe), (Label)jct.thisLabel());
            }
        }
        Label L = Lf;
        if (target instanceof Expr) {
            Type ft = JifInstantiator.instantiate(fe.type(), A, (Expr)target, JifFieldExt.targetType(ts, A, target, fe), JifFieldAssignExt.getPathMap((Node)target).NV());
            fe = (Field)fe.type(ft);
        }
        if (target instanceof Special && A.checkingInits()) {
            Label Lr = A.constructorReturnLabel();
            if (Lr != null) {
                L = lc.upperBound(L, Lr);
            }
            if (fi.flags().isFinal() && JifUtil.isFinalAccessExprOrConst(ts, assign.right())) {
                if (ts.isLabel(fi.type())) {
                    DynamicLabel dl = ts.dynamicLabel(fi.position(), JifUtil.varInstanceToAccessPath(fi, fi.position()));
                    Label rhs_label = JifUtil.exprToLabel(ts, assign.right(), A);
                    A.addDefinitionalAssertionEquiv(dl, rhs_label);
                } else if (ts.isImplicitCastValid(fi.type(), (Type)ts.Principal())) {
                    DynamicPrincipal dp = ts.dynamicPrincipal(fi.position(), JifUtil.varInstanceToAccessPath(fi, fi.position()));
                    Principal rhs_principal = JifUtil.exprToPrincipal(ts, assign.right(), A);
                    A.addDefinitionalEquiv(dp, rhs_principal);
                } else {
                    A.addDefinitionalAssertionEquiv(JifUtil.varInstanceToAccessPath(fi, fi.position()), JifUtil.exprToAccessPath(assign.right(), A));
                }
            }
        }
        lc.constrain(new NamedLabel("rhs.nv", "label of successful evaluation of right hand of assignment", X.NV()), LabelConstraint.LEQ, new NamedLabel("label of field " + fi.name(), L), A.labelEnv(), fe.position(), new ConstraintMessage(){

            public String msg() {
                return "Label of right hand side not less restrictive than the label for field " + fi.name();
            }

            public String detailMsg() {
                return "More information is revealed by the successful evaluation of the right hand side of the assignment than is allowed to flow to the field " + fi.name() + ".";
            }

            public String technicalMsg() {
                return "Invalid assignment: path NV of rhs is more restrictive than the declared label of the field <" + fi.name() + ">.";
            }
        });
        if (!(target instanceof Special) || !A.checkingInits()) {
            lc.constrain(new NamedLabel("Li", "Lower bound for side-effects", A.currentCodePCBound()), LabelConstraint.LEQ, new NamedLabel("label of field " + fi.name(), L), A.labelEnv(), fe.position(), new ConstraintMessage(){

                public String msg() {
                    return "Effect of assignment to field " + fi.name() + " is not bounded below by the PC bound.";
                }

                public String detailMsg() {
                    return "Assignment to the field " + fi.name() + " is a side effect which reveals more" + " information than this method is allowed" + " to; the side effects of this method must" + " be bounded below by the method's PC" + " bound, Li.";
                }

                public String technicalMsg() {
                    return "Invalid assignment: Li is more restrictive than the declared label of the field <" + fi.name() + ">.";
                }
            });
        }
        if (assign.operator() != Assign.ASSIGN) {
            X = X.NV(lc.upperBound(X.NV(), Lf));
        }
        Expr lhs = (Expr)JifFieldAssignExt.updatePathMap((Node)fe.target(target), X);
        JifFieldAssignExt.checkThrowTypes(throwTypes);
        return (Assign)JifFieldAssignExt.updatePathMap((Node)assign.right(rhs).left(lhs), X);
    }

    protected PathMap rhsPathMap(LabelChecker lc, Expr rhs, List throwTypes) {
        return JifFieldAssignExt.getPathMap((Node)rhs);
    }
}

