/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.JifOptions;
import jif.ast.DowngradeExpr;
import jif.extension.JifExprExt;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.util.Position;

public abstract class JifDowngradeExprExt
extends JifExprExt {
    public JifDowngradeExprExt(ToJavaExt toJava) {
        super(toJava);
    }

    protected JifContext declassifyConstraintContext(LabelChecker lc, JifContext A, Label downgradeFrom, Label downgradeTo) throws SemanticException {
        return A;
    }

    public Node labelCheck(LabelChecker lc) throws SemanticException {
        boolean boundSpecified;
        DowngradeExpr d = (DowngradeExpr)this.node();
        JifContext A = lc.jifContext();
        A = (JifContext)d.del().enterScope((Context)A);
        Expr e = (Expr)lc.context(A).labelCheck((Node)d.expr());
        PathMap Xe = JifDowngradeExprExt.getPathMap((Node)e);
        Xe = this.downgradeExprPathMap(lc.context(A), Xe);
        Label downgradeTo = d.label().label();
        Label downgradeFrom = null;
        if (d.bound() != null) {
            boundSpecified = true;
            downgradeFrom = d.bound().label();
        } else {
            boundSpecified = false;
            downgradeFrom = lc.typeSystem().freshLabelVariable(d.position(), "downgrade_from", "The label the downgrade expression is downgrading from");
        }
        A = (JifContext)A.pushBlock();
        A.setPc(Xe.N(), lc);
        lc = lc.context(A);
        this.checkDowngradeFromBound(lc, A, Xe, d, downgradeFrom, downgradeTo, boundSpecified);
        JifContext dA = this.declassifyConstraintContext(lc, A, downgradeFrom, downgradeTo);
        this.checkOneDimenOnly(lc, dA, downgradeFrom, downgradeTo, d.position());
        this.checkAuthority(lc, dA, downgradeFrom, downgradeTo, d.position());
        if (!((JifOptions)JifOptions.global).nonRobustness) {
            this.checkRobustness(lc, dA, downgradeFrom, downgradeTo, d.position());
        }
        PathMap X = Xe.NV(lc.upperBound(dA.pc(), downgradeTo));
        return JifDowngradeExprExt.updatePathMap((Node)d.expr(e), X);
    }

    protected void checkDowngradeFromBound(LabelChecker lc, JifContext A, PathMap Xe, final DowngradeExpr d, Label downgradeFrom, Label downgradeTo, boolean boundSpecified) throws SemanticException {
        lc.constrain(new NamedLabel("expr.nv", Xe.NV()), boundSpecified ? LabelConstraint.LEQ : LabelConstraint.EQUAL, new NamedLabel("downgrade_bound", downgradeFrom), A.labelEnv(), d.position(), boundSpecified, new ConstraintMessage(){

            public String msg() {
                return "The label of the expression to " + d.downgradeKind() + " is " + "more restrictive than label of data that " + "the " + d.downgradeKind() + " expression is allowed to " + d.downgradeKind() + ".";
            }

            public String detailMsg() {
                return "This " + d.downgradeKind() + " expression is allowed to " + "" + d.downgradeKind() + " information labeled up to " + this.namedRhs() + ". However, the label of the " + "expression to " + d.downgradeKind() + " is " + this.namedLhs() + ", which is more restrictive than " + "allowed.";
            }

            public String technicalMsg() {
                return "Invalid " + d.downgradeKind() + ": NV of the " + "expression is out of bound.";
            }
        });
    }

    protected PathMap downgradeExprPathMap(LabelChecker lc, PathMap Xe) throws SemanticException {
        return Xe;
    }

    protected abstract void checkOneDimenOnly(LabelChecker var1, JifContext var2, Label var3, Label var4, Position var5) throws SemanticException;

    protected abstract void checkAuthority(LabelChecker var1, JifContext var2, Label var3, Label var4, Position var5) throws SemanticException;

    protected abstract void checkRobustness(LabelChecker var1, JifContext var2, Label var3, Label var4, Position var5) throws SemanticException;
}

