/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.extension.JifStmtExt_c;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.label.Label;
import jif.types.label.VarLabel;
import jif.visit.LabelChecker;
import polyglot.ast.Branch;
import polyglot.ast.Do;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Stmt;
import polyglot.types.Context;
import polyglot.types.SemanticException;

public class JifDoExt
extends JifStmtExt_c {
    public JifDoExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheckStmt(LabelChecker lc) throws SemanticException {
        Do ds = (Do)this.node();
        JifTypeSystem ts = lc.typeSystem();
        JifContext A = lc.context();
        A = (JifContext)ds.del().enterScope((Context)A);
        lc = lc.context(A);
        VarLabel L1 = ts.freshLabelVariable(this.node().position(), "do", "label of PC for the do statement at " + this.node().position());
        VarLabel L2 = ts.freshLabelVariable(this.node().position(), "do", "label of PC at end of do statement at " + this.node().position());
        Label loopEntryPC = A.pc();
        A = (JifContext)A.pushBlock();
        A.setPc(L1, lc);
        A.gotoLabel(Branch.CONTINUE, null, L1);
        A.gotoLabel(Branch.BREAK, null, L2);
        Stmt s = (Stmt)lc.context(A).labelCheck((Node)ds.body());
        PathMap Xs = JifDoExt.getPathMap((Node)s);
        A = (JifContext)A.pushBlock();
        A.setPc(Xs.N(), lc);
        Expr e = (Expr)lc.context(A).labelCheck((Node)ds.cond());
        PathMap Xe = JifDoExt.getPathMap((Node)e);
        lc.constrain(new NamedLabel("do_while_guard.NV", "label of evaluation of the loop guard", Xe.NV()).join(lc, "loop_entry_pc", "label of the program counter just before the loop is executed", loopEntryPC), LabelConstraint.LEQ, new NamedLabel("loop_pc", "label of the program counter at the top of the loop", L1), lc.context().labelEnv(), ds.position(), false, new ConstraintMessage(){

            public String msg() {
                return "The information revealed by the normal termination of the body of the do-while loop may be more restrictive than the information that should be revealed by reaching the top of the loop.";
            }

            public String detailMsg() {
                return "The program counter label at the start of the loop is at least as restrictive as the normal termination label of the loop body, and the entry program counter label (that is, the program counter label just before the loop is executed for the first time).";
            }

            public String technicalMsg() {
                return "X(loopbody).n <= _pc_ of the do-while statement";
            }
        });
        PathMap X = Xe.join(Xs);
        X = X.set(ts.gotoPath(Branch.BREAK, null), ts.notTaken());
        X = X.set(ts.gotoPath(Branch.CONTINUE, null), ts.notTaken());
        X = X.N(lc.upperBound(X.N(), L2));
        return JifDoExt.updatePathMap((Node)ds.cond(e).body(s), X);
    }
}

