/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.Iterator;
import java.util.Set;
import jif.extension.JifDowngradeExprExt;
import jif.translate.ToJavaExt;
import jif.types.ConstraintMessage;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.NamedLabel;
import jif.types.label.Label;
import jif.types.label.PairLabel;
import jif.types.label.WritersToReadersLabel;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.types.SemanticException;
import polyglot.util.Position;

public class JifDeclassifyExprExt
extends JifDowngradeExprExt {
    public JifDeclassifyExprExt(ToJavaExt toJava) {
        super(toJava);
    }

    protected void checkOneDimenOnly(LabelChecker lc, JifContext A, Label labelFrom, Label labelTo, Position pos) throws SemanticException {
        JifDeclassifyExprExt.checkOneDimen(lc, A, labelFrom, labelTo, pos, true);
    }

    protected static void checkOneDimen(LabelChecker lc, JifContext A, Label labelFrom, Label labelTo, Position pos, boolean isExpr) throws SemanticException {
        final String exprOrStmt = isExpr ? "expression" : "statement";
        JifTypeSystem jts = lc.jifTypeSystem();
        PairLabel topConfLabel = jts.pairLabel(pos, jts.topConfPolicy(pos), jts.bottomIntegPolicy(pos));
        lc.constrain(new NamedLabel("declass_from", labelFrom), LabelConstraint.LEQ, new NamedLabel("declass_to", labelTo).join(lc, "top_confidentiality", topConfLabel), A.labelEnv(), pos, new ConstraintMessage(){

            public String msg() {
                return "Declassify " + exprOrStmt + "s cannot downgrade integrity.";
            }

            public String detailMsg() {
                return "The declass_from label has lower integrity than the declass_to label; declassify " + exprOrStmt + "s " + "cannot downgrade integrity.";
            }
        });
    }

    protected void checkAuthority(LabelChecker lc, JifContext A, Label labelFrom, Label labelTo, Position pos) throws SemanticException {
        JifDeclassifyExprExt.checkAuth(lc, A, labelFrom, labelTo, pos, true);
    }

    protected static void checkAuth(LabelChecker lc, final JifContext A, Label labelFrom, Label labelTo, Position pos, boolean isExpr) throws SemanticException {
        final String exprOrStmt = isExpr ? "expression" : "statement";
        Label authLabel = A.authLabel();
        lc.constrain(new NamedLabel("declass_from", labelFrom), LabelConstraint.LEQ, new NamedLabel("declass_to", labelTo).join(lc, "auth_label", authLabel), A.labelEnv(), pos, new ConstraintMessage(){

            public String msg() {
                return "The method does not have sufficient authority to declassify this " + exprOrStmt + ".";
            }

            public String detailMsg() {
                StringBuffer sb = new StringBuffer();
                Set authorities = A.authority();
                if (authorities.isEmpty()) {
                    sb.append("no principals");
                } else {
                    sb.append("the following principals: ");
                }
                Iterator iter = authorities.iterator();
                while (iter.hasNext()) {
                    Principal p = (Principal)iter.next();
                    sb.append(p.toString());
                    if (!iter.hasNext()) continue;
                    sb.append(", ");
                }
                return "The " + exprOrStmt + " to declassify has label " + this.namedRhs() + ", and the " + exprOrStmt + " " + "should be downgraded to label " + "declass_to. However, the method has " + "the authority of " + sb.toString() + ". " + "The authority of other principals is " + "required to perform the declassify.";
            }

            public String technicalMsg() {
                return "Invalid declassify: the method does not have sufficient authorities.";
            }
        });
    }

    protected void checkRobustness(LabelChecker lc, JifContext A, Label labelFrom, Label labelTo, Position pos) throws SemanticException {
        JifDeclassifyExprExt.checkRobustDecl(lc, A, labelFrom, labelTo, pos, true);
    }

    protected static void checkRobustDecl(LabelChecker lc, JifContext A, Label labelFrom, Label labelTo, Position pos, boolean isExpr) throws SemanticException {
        final String exprOrStmt = isExpr ? "expression" : "statement";
        JifTypeSystem jts = lc.typeSystem();
        WritersToReadersLabel pcInteg = jts.writersToReadersLabel(pos, A.pc());
        lc.constrain(new NamedLabel("declass_from", labelFrom), LabelConstraint.LEQ, new NamedLabel("declass_to", labelTo).join(lc, "pc_integrity", pcInteg), A.labelEnv(), pos, new ConstraintMessage(){

            public String msg() {
                return "Declassification not robust: a new reader may influence the decision to declassify.";
            }

            public String detailMsg() {
                return "The declassification of this " + exprOrStmt + " is " + "not robust; at least one of the principals that is " + "allowed to read the information after " + "declassification may be able to influence the " + "decision to declassify.";
            }
        });
        WritersToReadersLabel fromInteg = jts.writersToReadersLabel(pos, labelFrom);
        lc.constrain(new NamedLabel("declass_from_label", labelFrom), LabelConstraint.LEQ, new NamedLabel("declass_to_label", labelTo).join(lc, "from_label_integrity", fromInteg), A.labelEnv(), pos, new ConstraintMessage(){

            public String msg() {
                return "Declassification not robust: a new reader may influence the data to be declassified.";
            }

            public String detailMsg() {
                return "The declassification of this " + exprOrStmt + " is " + "not robust; at least one of the principals that is " + "allowed to read the information after " + "declassification may be able to influence the " + "data to be declassified.";
            }
        });
    }
}

