/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import jif.ast.JifUtil;
import jif.extension.CallHelper;
import jif.extension.ConstructorChecker;
import jif.extension.JifCallDel;
import jif.extension.JifExprExt;
import jif.translate.ToJavaExt;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifMethodInstance;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.SemanticDetailedException;
import jif.types.label.Label;
import jif.visit.LabelChecker;
import polyglot.ast.Call;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.types.Context;
import polyglot.types.MethodInstance;
import polyglot.types.SemanticException;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;

public class JifCallExt
extends JifExprExt {
    public JifCallExt(ToJavaExt toJava) {
        super(toJava);
    }

    public Node labelCheck(LabelChecker lc) throws SemanticException {
        Call me = (Call)this.node();
        JifContext A = lc.jifContext();
        A = (JifContext)me.del().enterScope((Context)A);
        JifTypeSystem ts = lc.jifTypeSystem();
        if (A.checkingInits()) {
            if (me.target() instanceof Expr && JifUtil.effectiveExpr((Expr)me.target()) instanceof Special) {
                throw new SemanticDetailedException("No methods may be called on \"this\" object in a constructor prologue.", "In a constructor body before the call to the super class, no reference to the \"this\" object is allowed to escape. This means that no methods of the current object may be called.", me.position());
            }
            for (Expr arg : me.arguments()) {
                if (!(JifUtil.effectiveExpr(arg) instanceof Special)) continue;
                throw new SemanticDetailedException("The \"this\" object cannot be used as a method argument in a constructor prologue.", "In a constructor body before the call to the super class, no reference to the \"this\" object is allowed to escape. This means that the \"this\" object cannot be used as a method argument.", arg.position());
            }
        }
        ArrayList throwTypes = new ArrayList(me.del().throwTypes((TypeSystem)ts));
        Receiver target = (Receiver)lc.context(A).labelCheck((Node)me.target());
        JifMethodInstance mi = (JifMethodInstance)ts.findMethod(target.type().toReference(), me.name(), me.methodInstance().formalTypes(), A.currentClass());
        me = me.methodInstance((MethodInstance)mi);
        if (mi.flags().isStatic()) {
            new ConstructorChecker().checkStaticMethodAuthority(mi, A, lc, me.position());
        }
        A = (JifContext)A.pushBlock();
        boolean npExc = false;
        Label objLabel = null;
        if (target instanceof Expr) {
            Expr e = (Expr)target;
            if (e.type() == null) {
                throw new InternalCompilerError("Type of " + e + " is null", e.position());
            }
            PathMap Xs = JifCallExt.getPathMap((Node)target);
            A.setPc(Xs.N(), lc);
            if (!(target instanceof Special)) {
                npExc = !((JifCallDel)this.node().del()).targetIsNeverNull();
                objLabel = Xs.NV();
                A.setPc(Xs.NV(), lc);
            } else {
                objLabel = ((JifClassType)lc.context().currentClass()).thisLabel();
            }
        }
        CallHelper helper = lc.createCallHelper(objLabel, target, mi.container(), mi, me.arguments(), this.node().position());
        LabelChecker callLC = lc.context(A);
        helper.checkCall(callLC, throwTypes, npExc);
        JifCallDel del = (JifCallDel)me.del();
        helper.bindVarLabels(callLC, del.receiverVarLabel, del.argVarLabels, del.paramVarLabels);
        A = (JifContext)A.pop();
        if (helper.returnType() != me.type()) {
            me = (Call)me.type(helper.returnType());
        }
        JifCallExt.checkThrowTypes(throwTypes);
        return JifCallExt.updatePathMap((Node)me.target(target).arguments(helper.labelCheckedArgs()), helper.X());
    }
}

