/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import jif.ast.JifNodeFactory;
import jif.ast.JifUtil;
import jif.ast.LabelExpr;
import jif.ast.PrincipalExpr;
import jif.extension.JifJL_c;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.SemanticDetailedException;
import jif.types.label.AccessPath;
import jif.types.principal.Principal;
import polyglot.ast.Binary;
import polyglot.ast.Expr;
import polyglot.ast.Node;
import polyglot.ast.Precedence;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class JifBinaryDel
extends JifJL_c {
    public static final Binary.Operator ACTSFOR = new Binary.Operator("actsfor", Precedence.RELATIONAL);
    public static final Binary.Operator EQUIV = new Binary.Operator("equiv", Precedence.RELATIONAL);

    public Node typeCheck(TypeChecker tc) throws SemanticException {
        Binary b = (Binary)this.node();
        JifTypeSystem ts = (JifTypeSystem)tc.typeSystem();
        if ((b.operator() == Binary.LE || b.operator() == EQUIV) && (ts.isLabel(b.left().type()) || ts.isLabel(b.right().type()))) {
            LabelExpr rhs;
            LabelExpr lhs;
            if (!ts.isLabel(b.left().type()) || !ts.isLabel(b.right().type())) {
                throw new SemanticException("The operator " + b.operator() + " requires both operands to be labels.", b.position());
            }
            JifNodeFactory nf = (JifNodeFactory)tc.nodeFactory();
            if (b.left() instanceof LabelExpr) {
                lhs = (LabelExpr)b.left();
            } else {
                if (!JifUtil.isFinalAccessExprOrConst(ts, b.left())) {
                    throw new SemanticException("An expression used in a label test must be either a final access path, principal parameter or a constant principal", b.left().position());
                }
                lhs = nf.LabelExpr(b.left().position(), JifUtil.exprToLabel(ts, b.left(), (JifContext)tc.context()));
                lhs = (LabelExpr)lhs.visit((NodeVisitor)tc);
            }
            if (b.right() instanceof LabelExpr) {
                rhs = (LabelExpr)b.right();
            } else {
                if (!JifUtil.isFinalAccessExprOrConst(ts, b.right())) {
                    throw new SemanticException("An expression used in a label test must either be a final access path or a \"new label\"", b.right().position());
                }
                rhs = nf.LabelExpr(b.right().position(), JifUtil.exprToLabel(ts, b.right(), (JifContext)tc.context()));
                rhs = (LabelExpr)rhs.visit((NodeVisitor)tc);
            }
            return b.left((Expr)lhs).right((Expr)rhs).type((Type)ts.Boolean());
        }
        boolean leftPrinc = ts.isImplicitCastValid(b.left().type(), (Type)ts.Principal());
        boolean rightPrinc = ts.isImplicitCastValid(b.right().type(), (Type)ts.Principal());
        if (b.operator() == ACTSFOR || b.operator() == EQUIV && (leftPrinc || rightPrinc)) {
            if (!leftPrinc || !rightPrinc) {
                throw new SemanticException("The operator " + b.operator() + " requires both operands to be principals.", b.position());
            }
            this.checkPrincipalExpr(tc, b.left());
            this.checkPrincipalExpr(tc, b.right());
            return b.type((Type)ts.Boolean());
        }
        if (b.operator() == EQUIV) {
            throw new SemanticException("The equiv operator requires either both operands to be principals, or both operands to be labels.", b.position());
        }
        return super.typeCheck(tc);
    }

    private void checkPrincipalExpr(TypeChecker tc, Expr expr) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)tc.typeSystem();
        if (expr instanceof PrincipalExpr) {
            return;
        }
        if (expr.type() != null && expr.type().isCanonical() && !JifUtil.isFinalAccessExprOrConst(ts, expr)) {
            AccessPath ap = JifUtil.exprToAccessPath(expr, (JifContext)tc.context());
            ap.verify((JifContext)tc.context());
            throw new SemanticDetailedException("Illegal dynamic principal.", "Only final access paths or principal expressions can be used as a dynamic principal. A final access path is an expression starting with either \"this\" or a final local variable \"v\", followed by zero or more final field accesses. That is, a final access path is either this.f1.f2....fn, or v.f1.f2.....fn, where v is a final local variables, and each field f1 to fn is a final field. A principal expression is either a principal parameter, or an external principal.", expr.position());
        }
        Principal p = JifUtil.exprToPrincipal(ts, expr, (JifContext)tc.context());
        if (!p.isRuntimeRepresentable()) {
            throw new SemanticDetailedException("A principal used in an actsfor must be runtime-representable.", "Both principals used in an actsfor test must be represented at runtime, since the actsfor test is a dynamic test. The principal " + p + " is not represented at runtime, and thus cannot be used " + "in an actsfor test.", expr.position());
        }
    }
}

