/*
 * Decompiled with CFR 0.152.
 */
package jif.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import jif.Topics;
import jif.ast.JifInstantiator;
import jif.ast.JifNodeFactory;
import jif.ast.JifUtil;
import jif.ast.Jif_c;
import jif.extension.JifProcedureDeclExt_c;
import jif.extension.LabelTypeCheckUtil;
import jif.extension.SubtypeChecker;
import jif.types.ActsForConstraint;
import jif.types.Assertion;
import jif.types.AuthConstraint;
import jif.types.AutoEndorseConstraint;
import jif.types.CallerConstraint;
import jif.types.ConstraintMessage;
import jif.types.JifClassType;
import jif.types.JifContext;
import jif.types.JifMethodInstance;
import jif.types.JifProcedureInstance;
import jif.types.JifTypeSystem;
import jif.types.LabelConstraint;
import jif.types.LabelLeAssertion;
import jif.types.LabelSubstitution;
import jif.types.LabeledType;
import jif.types.NamedLabel;
import jif.types.PathMap;
import jif.types.PrincipalConstraint;
import jif.types.SemanticDetailedException;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathLocal;
import jif.types.label.AccessPathRoot;
import jif.types.label.ArgLabel;
import jif.types.label.Label;
import jif.types.label.ThisLabel;
import jif.types.label.VarLabel;
import jif.types.principal.Principal;
import jif.visit.LabelChecker;
import polyglot.ast.Expr;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.main.Report;
import polyglot.types.ConstructorInstance;
import polyglot.types.LocalInstance;
import polyglot.types.MethodInstance;
import polyglot.types.ReferenceType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.StringUtil;

public class CallHelper {
    protected final Label receiverLabel;
    protected final Expr receiverExpr;
    protected final ReferenceType calleeContainer;
    protected final List actualArgs;
    protected final JifProcedureInstance pi;
    protected final Position position;
    protected List actualArgLabels;
    protected List actualParamLabels;
    protected PathMap X;
    protected Type returnType;
    protected boolean callChecked = false;
    protected final boolean overrideChecker;
    JifMethodInstance overridingMethod = null;

    protected static boolean shouldReport(int obscurity) {
        return Report.should_report((String)Topics.labels, (int)obscurity);
    }

    protected static void report(int obscurity, String s) {
        Report.report((int)obscurity, (String)("labels: " + s));
    }

    public CallHelper(Label receiverLabel, Receiver receiver, ReferenceType calleeContainer, JifProcedureInstance pi, List actualArgs, Position position) {
        this(receiverLabel, receiver, calleeContainer, pi, actualArgs, position, false);
    }

    protected CallHelper(Label receiverLabel, Receiver receiver, ReferenceType calleeContainer, JifProcedureInstance pi, List actualArgs, Position position, boolean overrideChecker) {
        this.receiverLabel = receiverLabel;
        this.calleeContainer = calleeContainer;
        this.overrideChecker = overrideChecker;
        this.receiverExpr = receiver instanceof Expr ? (Expr)receiver : null;
        this.actualArgs = new ArrayList(actualArgs);
        this.pi = pi;
        this.position = position;
        this.callChecked = false;
        if (pi.formalTypes().size() != actualArgs.size()) {
            throw new InternalCompilerError("Wrong number of args.");
        }
    }

    public static CallHelper OverrideHelper(JifMethodInstance overridden, JifMethodInstance overriding, LabelChecker lc) {
        JifTypeSystem jts = (JifTypeSystem)overridden.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)lc.nodeFactory();
        JifClassType subContainer = (JifClassType)overriding.container();
        ThisLabel receiverLabel = subContainer.thisLabel();
        Special receiver = nf.This(overriding.position());
        ReferenceType calleeContainer = overridden.container().toReference();
        ArrayList<Local> actualArgs = new ArrayList<Local>(overriding.formalTypes().size());
        for (Type t : overriding.formalTypes()) {
            if (jts.isLabeled(t)) {
                ArgLabel al = (ArgLabel)jts.labelOfType(t);
                LocalInstance formalInst = (LocalInstance)al.formalInstance();
                Local l = nf.Local(formalInst.position(), nf.Id(al.position(), al.name())).localInstance(formalInst);
                actualArgs.add(l);
                continue;
            }
            throw new InternalCompilerError("Formal type is not labeled!");
        }
        CallHelper ch = new CallHelper(receiverLabel, (Receiver)receiver, calleeContainer, overridden, actualArgs, overriding.position(), true);
        ch.overridingMethod = overriding;
        ch.actualParamLabels = Collections.EMPTY_LIST;
        ch.actualArgLabels = new ArrayList(overriding.formalTypes().size());
        for (Type t : overriding.formalTypes()) {
            ArgLabel al = (ArgLabel)jts.labelOfType(t);
            ch.actualArgLabels.add(al);
        }
        return ch;
    }

    public Type returnType() {
        if (this.overrideChecker) {
            throw new InternalCompilerError("Not available for call checking");
        }
        if (!this.callChecked) {
            throw new InternalCompilerError("checkCall not yet called!");
        }
        return this.returnType;
    }

    public List labelCheckedArgs() {
        if (this.overrideChecker) {
            throw new InternalCompilerError("Not available for call checking");
        }
        if (!this.callChecked) {
            throw new InternalCompilerError("checkCall not yet called!");
        }
        return this.actualArgs;
    }

    public PathMap X() {
        if (this.overrideChecker) {
            throw new InternalCompilerError("Not available for call checking");
        }
        if (!this.callChecked) {
            throw new InternalCompilerError("checkCall not yet called!");
        }
        return this.X;
    }

    protected PathMap labelCheckAndConstrainParams(LabelChecker lc, List throwTypes) throws SemanticException {
        PathMap Xjoin;
        JifTypeSystem ts = lc.typeSystem();
        LabelTypeCheckUtil ltcu = ts.labelTypeCheckUtil();
        if (this.pi.flags().isStatic()) {
            Xjoin = ltcu.labelCheckType((Type)this.pi.container(), lc, throwTypes, this.position);
            List Xparams = ltcu.labelCheckTypeParams((Type)this.pi.container(), lc, throwTypes, this.position);
            this.actualParamLabels = new ArrayList(Xparams.size());
            for (PathMap Xj : Xparams) {
                this.actualParamLabels.add(Xj.NV());
            }
        } else if (this.pi instanceof ConstructorInstance) {
            Xjoin = ltcu.labelCheckType((Type)this.pi.container(), lc, throwTypes, this.position);
            List Xparams = ltcu.labelCheckTypeParams((Type)this.pi.container(), lc, throwTypes, this.position);
            this.actualParamLabels = new ArrayList(Xparams.size());
            JifContext A = lc.context();
            NamedLabel paramUB = new NamedLabel("param_upper_bound", "the upper bound on the information that may be revealed by any actual parameter", this.receiverLabel);
            int counter = 0;
            for (PathMap Xj : Xparams) {
                this.actualParamLabels.add(Xj.NV());
                int count = ++counter;
                lc.constrain(new NamedLabel("actual_param_" + count, "the label of the " + StringUtil.nth((int)count) + " actual parameter", Xj.NV()), LabelConstraint.LEQ, paramUB, A.labelEnv(), this.position, new ConstraintMessage(){

                    public String msg() {
                        return "The actual parameter is more restrictive than permitted.";
                    }
                });
            }
            if (lc.context().inConstructorCall()) {
                Xjoin = Xjoin.N(lc.context().pc());
            }
        } else {
            Xjoin = ts.pathMap().N(lc.context().pc());
            this.actualParamLabels = Collections.EMPTY_LIST;
        }
        return Xjoin;
    }

    protected PathMap labelCheckAndConstrainArgs(LabelChecker lc, PathMap Xjoin) throws SemanticException {
        Expr Ej;
        int i;
        JifContext A = lc.context();
        JifTypeSystem ts = lc.typeSystem();
        PathMap Xj = ts.pathMap();
        Xj = Xj.N(A.pc());
        this.actualArgLabels = new ArrayList(this.actualArgs.size());
        for (i = 0; i < this.actualArgs.size(); ++i) {
            Ej = (Expr)this.actualArgs.get(i);
            A = (JifContext)A.pushBlock();
            A.setPc(Xj.N(), lc);
            Ej = (Expr)lc.context(A).labelCheck((Node)Ej);
            A = (JifContext)A.pop();
            this.actualArgs.set(i, Ej);
            Xj = Jif_c.getPathMap((Node)Ej);
            this.actualArgLabels.add(Xj.NV());
            Xjoin = Xjoin.join(Xj);
        }
        for (i = 0; i < this.actualArgs.size(); ++i) {
            Ej = (Expr)this.actualArgs.get(i);
            this.constrainArg(lc, i, Ej, (Type)this.pi.formalTypes().get(i));
        }
        return Xjoin;
    }

    protected void constrainArg(LabelChecker lc, int index, final Expr Ej, Type formalType) throws SemanticException {
        JifContext A = lc.context();
        JifTypeSystem jts = (JifTypeSystem)A.typeSystem();
        ArgLabel aj = (ArgLabel)jts.labelOfType(formalType);
        Label argBoundj = this.instantiate(A, aj.upperBound());
        PathMap Xj = Jif_c.getPathMap((Node)Ej);
        lc.constrain(new NamedLabel("actual_arg_" + (index + 1), "the label of the " + StringUtil.nth((int)(index + 1)) + " actual argument", Xj.NV()), LabelConstraint.LEQ, new NamedLabel("formal_arg_" + (index + 1), "the upper bound of the formal argument " + aj.formalInstance().name(), argBoundj), A.labelEnv(), Ej.position(), new ConstraintMessage(){

            public String msg() {
                return "The actual argument is more restrictive than the formal argument.";
            }

            public String detailMsg() {
                return "The label of the actual argument, " + this.namedLhs() + ", is more restrictive than the label of the " + "formal argument, " + this.namedRhs() + ".";
            }

            public String technicalMsg() {
                return "Invalid argument: the actual argument <" + Ej + "> has a more restrictive label than the " + "formal argument.";
            }
        });
        SubtypeChecker sc = new SubtypeChecker(this.instantiate(A, jts.unlabel(formalType)), jts.unlabel(Ej.type()));
        sc.addSubtypeConstraints(lc, Ej.position());
    }

    protected void constrainFinalActualArgs(JifTypeSystem jts) throws SemanticException {
        final LinkedHashSet argInstances = new LinkedHashSet();
        LabelSubstitution argLabelGather = new LabelSubstitution(){

            public AccessPath substAccessPath(AccessPath ap) {
                this.extractRoot(ap.root());
                return ap;
            }

            void extractRoot(AccessPathRoot root) {
                if (root instanceof AccessPathLocal) {
                    argInstances.add(((AccessPathLocal)root).localInstance());
                }
            }
        };
        this.pi.subst(argLabelGather);
        Iterator formalTypes = this.pi.formalTypes().iterator();
        for (int j = 0; j < this.actualArgs.size(); ++j) {
            Expr Ej;
            Type tj = (Type)formalTypes.next();
            ArgLabel aj = (ArgLabel)jts.labelOfType(tj);
            if (!argInstances.contains(aj.formalInstance()) || JifUtil.isFinalAccessExprOrConst(jts, Ej = (Expr)this.actualArgs.get(j))) continue;
            throw new SemanticDetailedException("The " + StringUtil.nth((int)(j + 1)) + " argument must be a final access path or a " + "constant", "The " + StringUtil.nth((int)(j + 1)) + " formal argument " + "of " + this.pi.debugString() + " is used to express a dynamic label or principal " + "in the procedure's signature. As such, " + "the actual argument must be a final " + "access path or a constant.", Ej.position());
        }
    }

    protected Label resolvePCBound(LabelChecker lc) throws SemanticException {
        return this.instantiate(lc.context(), this.pi.pcBound());
    }

    protected Label resolveReturnLabel(LabelChecker lc) throws SemanticException {
        return this.instantiate(lc.context(), this.pi.returnLabel());
    }

    protected Label resolveReturnValueLabel(LabelChecker lc, Label returnLabel) throws SemanticException {
        JifTypeSystem ts = lc.typeSystem();
        Label L = null;
        if (this.pi instanceof MethodInstance) {
            MethodInstance mi = (MethodInstance)this.pi;
            L = this.instantiate(lc.context(), ts.labelOfType(mi.returnType()));
        } else {
            L = ts.bottomLabel(this.pi.position());
        }
        return lc.upperBound(L, returnLabel);
    }

    protected PathMap excPathMap(LabelChecker lc, Label returnLabel, Label pcPriorToInvoke, List throwTypes) throws SemanticException {
        JifTypeSystem ts = lc.typeSystem();
        PathMap Xexn = ts.pathMap();
        for (Type te : this.pi.throwTypes()) {
            Label Le = ts.labelOfType(te, returnLabel);
            Le = this.instantiate(lc.context(), Le);
            Jif_c.checkAndRemoveThrowType(throwTypes, te);
            Xexn = Xexn.exception(te, lc.upperBound(Le, pcPriorToInvoke));
        }
        return Xexn;
    }

    public void checkCall(LabelChecker lc, List throwTypes, boolean targetMayBeNull) throws SemanticException {
        if (this.overrideChecker) {
            throw new InternalCompilerError("Not available for call checking");
        }
        if (this.callChecked) {
            throw new InternalCompilerError("checkCall already called!");
        }
        JifTypeSystem ts = lc.typeSystem();
        if (CallHelper.shouldReport(4)) {
            CallHelper.report(4, ">>>>> call-begin");
        }
        PathMap Xjoin = this.labelCheckAndConstrainParams(lc, throwTypes);
        lc = lc.context((JifContext)lc.context().pushBlock());
        lc.context().setPc(Xjoin.N(), lc);
        Xjoin = this.labelCheckAndConstrainArgs(lc, Xjoin);
        if (targetMayBeNull) {
            Jif_c.checkAndRemoveThrowType(throwTypes, (Type)ts.NullPointerException());
            Xjoin = Xjoin.exc(this.receiverLabel, (Type)ts.NullPointerException());
        }
        this.constrainFinalActualArgs(ts);
        lc = lc.context((JifContext)lc.context().pushBlock());
        lc.context().setPc(Xjoin.N(), lc);
        Label Li = this.resolvePCBound(lc);
        if (Li != null) {
            final JifProcedureInstance callee = this.pi;
            JifContext A = lc.context();
            NamedLabel namedLi = new NamedLabel("callee_PC_bound", "lower bound on the side effects of the method " + callee.signature(), Li);
            lc.constrain(new NamedLabel("pc_call", "label of the program counter at this call site", Xjoin.N()), LabelConstraint.LEQ, namedLi, A.labelEnv(), this.position, new ConstraintMessage(){

                public String msg() {
                    return "PC at call site more restrictive than begin label of " + callee.signature() + ".";
                }

                public String detailMsg() {
                    return "Calling the method at this program point may reveal too much information to the receiver of the method call. " + callee.signature() + " can only be invoked " + "if the invocation will reveal no more " + "information than the callee's begin label, " + this.namedRhs() + ". However, execution reaching " + "this program point may depend on information " + "up to the PC at this program point: " + this.namedLhs() + ".";
                }

                public String technicalMsg() {
                    return "Invalid method call: " + this.namedLhs() + " is more restrictive than " + "the callee's begin label.";
                }
            });
            lc.constrain(new NamedLabel("caller_PC_bound", "lower bound on the side effects of caller", A.currentCodePCBound()), LabelConstraint.LEQ, namedLi, A.labelEnv(), this.position, new ConstraintMessage(){

                public String msg() {
                    return "The side effects of " + callee.signature() + " are not bounded by the PC bound.";
                }

                public String detailMsg() {
                    return "Calling the method here may have side effects that are not bounded below by the PC bound of the caller. The side effects of the method to be invoked are bounded below by the callee's begin label, " + this.namedRhs() + ". However, the side effects of the calling context must " + "be bounded below by the caller's begin label " + this.namedLhs() + ".";
                }

                public String technicalMsg() {
                    return "Invalid method call: " + this.namedLhs() + " is more restrictive than " + "the callee's begin label.";
                }
            });
        }
        this.satisfiesConstraints(this.pi, lc, true);
        if (CallHelper.shouldReport(4)) {
            CallHelper.report(4, ">>>>> call-end");
        }
        Label Lr = this.resolveReturnLabel(lc);
        Label Lrv = this.resolveReturnValueLabel(lc, Lr);
        Label pcPriorToInvoke = Xjoin.N();
        this.X = Xjoin.N(lc.upperBound(Lr, pcPriorToInvoke));
        this.X = this.X.NV(lc.upperBound(Lrv, pcPriorToInvoke));
        this.X = this.X.join(this.excPathMap(lc, Lr, pcPriorToInvoke, throwTypes));
        this.returnType = this.pi instanceof MethodInstance ? this.instantiate(lc.context(), ((MethodInstance)this.pi).returnType()) : null;
        this.callChecked = true;
    }

    protected void satisfiesConstraints(final JifProcedureInstance jpi, LabelChecker lc, boolean performInstantiations) throws SemanticException {
        JifContext A = lc.context();
        for (Assertion jc : jpi.constraints()) {
            if (jc instanceof AuthConstraint || jc instanceof AutoEndorseConstraint) continue;
            if (jc instanceof CallerConstraint) {
                CallerConstraint jcc = (CallerConstraint)jc;
                Principal authPrincipal = lc.jifTypeSystem().conjunctivePrincipal(jpi.position(), A.authority());
                for (Principal orig : jcc.principals()) {
                    final Principal pi = performInstantiations ? this.instantiate(A, orig) : orig;
                    lc.constrain(authPrincipal, PrincipalConstraint.ACTSFOR, pi, A.labelEnv(), this.overrideChecker ? jcc.position() : this.position, new ConstraintMessage(){

                        public String msg() {
                            if (!CallHelper.this.overrideChecker) {
                                return "The caller must have the authority of the principal " + pi + " to invoke " + jpi.debugString();
                            }
                            return "The subclass cannot assume the caller has the authority of the principal " + pi;
                        }

                        public String detailMsg() {
                            if (!CallHelper.this.overrideChecker) {
                                return "The " + jpi.debugString() + " requires that the " + "caller of the method have the authority of " + "the principal " + pi + ". The caller does " + "not have this principal's authority.";
                            }
                            return "The " + jpi.debugString() + " requires that the " + "caller of the method have the authority of " + "the principal " + pi + ". However, this " + "method overrides the method in class " + CallHelper.this.pi.container() + " which does not make this requirement.";
                        }
                    });
                }
                continue;
            }
            if (jc instanceof ActsForConstraint) {
                Principal granter;
                final ActsForConstraint jac = (ActsForConstraint)jc;
                final Principal actor = performInstantiations ? this.instantiate(A, jac.actor()) : jac.actor();
                Principal principal = granter = performInstantiations ? this.instantiate(A, jac.granter()) : jac.granter();
                if (jac.isEquiv()) {
                    lc.constrain(actor, PrincipalConstraint.EQUIV, granter, A.labelEnv(), this.position, new ConstraintMessage(){

                        public String msg() {
                            if (!CallHelper.this.overrideChecker) {
                                return "The principal " + actor + " must be equivalent to " + granter + " to invoke " + jpi.debugString();
                            }
                            return "The subclass cannot assume that " + actor + " is " + "equivalent to " + granter;
                        }

                        public String detailMsg() {
                            if (!CallHelper.this.overrideChecker) {
                                return "The " + jpi.debugString() + " requires that the " + " relationship " + jac + " holds at the call site.";
                            }
                            return "The " + jpi.debugString() + " requires that " + actor + " is " + "equivalent to " + granter + ". However, this " + "method overrides the method in class " + CallHelper.this.pi.container() + " which does not make this requirement.";
                        }
                    });
                    continue;
                }
                lc.constrain(actor, PrincipalConstraint.ACTSFOR, granter, A.labelEnv(), this.position, new ConstraintMessage(){

                    public String msg() {
                        if (!CallHelper.this.overrideChecker) {
                            return "The principal " + actor + " must act for " + granter + " to invoke " + jpi.debugString();
                        }
                        return "The subclass cannot assume that " + actor + " can " + "actfor " + granter;
                    }

                    public String detailMsg() {
                        if (!CallHelper.this.overrideChecker) {
                            return "The " + jpi.debugString() + " requires that the " + "relationship " + actor + " actsfor " + granter + " holds at the call site.";
                        }
                        return "The " + jpi.debugString() + " requires that " + actor + " can " + "actfor " + granter + ". However, this " + "method overrides the method in class " + CallHelper.this.pi.container() + " which does not make this requirement.";
                    }
                });
                continue;
            }
            if (!(jc instanceof LabelLeAssertion)) continue;
            LabelLeAssertion lla = (LabelLeAssertion)jc;
            final Label lhs = performInstantiations ? this.instantiate(A, lla.lhs()) : lla.lhs();
            final Label rhs = performInstantiations ? this.instantiate(A, lla.rhs()) : lla.rhs();
            Position pos = this.position;
            if (this.overrideChecker) {
                pos = lla.position();
            }
            lc.constrain(new NamedLabel(lla.lhs().toString(), "LHS of label assertion", lhs), LabelConstraint.LEQ, new NamedLabel(lla.rhs().toString(), "RHS of label assertion", rhs), A.labelEnv(), pos, new ConstraintMessage(){

                public String msg() {
                    if (!CallHelper.this.overrideChecker) {
                        return "The label " + lhs + " must be less restrictive " + "than " + rhs + " to invoke " + jpi.debugString();
                    }
                    return "The subclass cannot assume that " + lhs + " <= " + rhs;
                }

                public String detailMsg() {
                    if (!CallHelper.this.overrideChecker) {
                        return "The " + jpi.debugString() + " requires that the " + "relationship " + lhs + " <= " + rhs + " holds at the call site.";
                    }
                    return "The " + jpi.debugString() + " requires that " + lhs + " <= " + rhs + ". However, this " + "method overrides the method in class " + CallHelper.this.pi.container() + " which does not make this requirement.";
                }
            });
        }
    }

    public void bindVarLabels(LabelChecker lc, VarLabel receiverVarLabel, List actualArgVarLabels, List actualParamVarLabels) throws SemanticException {
        int i;
        if (this.overrideChecker) {
            throw new InternalCompilerError("Not available for call checking");
        }
        if (!this.callChecked) {
            throw new InternalCompilerError("checkCall not yet called!");
        }
        JifContext A = lc.context();
        if (receiverVarLabel != null && this.receiverLabel != null) {
            lc.constrain(new NamedLabel(receiverVarLabel.componentString(), receiverVarLabel), LabelConstraint.EQUAL, new NamedLabel(receiverVarLabel.componentString(), this.receiverLabel), A.labelEnv(), this.position);
        } else if (receiverVarLabel != null || this.receiverLabel != null) {
            throw new InternalCompilerError("Inconsistent receiver labels", this.position);
        }
        for (i = 0; i < this.actualArgLabels.size(); ++i) {
            VarLabel argVarLbl = (VarLabel)actualArgVarLabels.get(i);
            Label argLbl = (Label)this.actualArgLabels.get(i);
            lc.constrain(new NamedLabel(argVarLbl.componentString(), argVarLbl), LabelConstraint.EQUAL, new NamedLabel(argVarLbl.componentString(), argLbl), A.labelEnv(), this.position);
        }
        if (this.pi.flags().isStatic() || this.pi instanceof ConstructorInstance) {
            for (i = 0; i < actualParamVarLabels.size(); ++i) {
                VarLabel paramVarLbl = (VarLabel)actualParamVarLabels.get(i);
                Label paramLbl = (Label)this.actualParamLabels.get(i);
                lc.constrain(new NamedLabel(paramVarLbl.componentString(), paramVarLbl), LabelConstraint.EQUAL, new NamedLabel(paramVarLbl.componentString(), paramLbl), A.labelEnv(), this.position);
            }
        }
    }

    protected static List getArgLabelsFromFormalTypes(List formalTypes, JifTypeSystem jts, Position pos) throws SemanticException {
        ArrayList<ArgLabel> formalArgLabels = new ArrayList<ArgLabel>(formalTypes.size());
        for (Type t : formalTypes) {
            Label l = jts.labelOfType(t);
            if (!(l instanceof ArgLabel)) {
                throw new SemanticException("Internal label error, probably caused by an earlier error.", pos);
            }
            ArgLabel al = (ArgLabel)l;
            formalArgLabels.add(al);
        }
        return formalArgLabels;
    }

    public Label instantiate(JifContext A, Label L) throws SemanticException {
        return JifInstantiator.instantiate(L, A, this.receiverExpr, this.calleeContainer, this.receiverLabel, CallHelper.getArgLabelsFromFormalTypes(this.pi.formalTypes(), (JifTypeSystem)this.pi.typeSystem(), this.pi.position()), this.pi.formalTypes(), this.actualArgLabels, this.actualArgs, this.actualParamLabels);
    }

    public Set instantiate(JifContext A, Set s) throws SemanticException {
        LinkedHashSet<Principal> newS = new LinkedHashSet<Principal>();
        for (Principal p : s) {
            newS.add(this.instantiate(A, p));
        }
        return newS;
    }

    public Principal instantiate(JifContext A, Principal p) throws SemanticException {
        return JifInstantiator.instantiate(p, A, this.receiverExpr, this.calleeContainer, this.receiverLabel, CallHelper.getArgLabelsFromFormalTypes(this.pi.formalTypes(), (JifTypeSystem)this.pi.typeSystem(), this.pi.position()), this.pi.formalTypes(), this.actualArgs, this.actualParamLabels);
    }

    public Type instantiate(JifContext A, Type t) throws SemanticException {
        return JifInstantiator.instantiate(t, A, this.receiverExpr, this.calleeContainer, this.receiverLabel, CallHelper.getArgLabelsFromFormalTypes(this.pi.formalTypes(), (JifTypeSystem)this.pi.typeSystem(), this.pi.position()), this.pi.formalTypes(), this.actualArgLabels, this.actualArgs, this.actualParamLabels);
    }

    public void checkOverride(LabelChecker lc) throws SemanticException {
        if (!this.overrideChecker) {
            throw new InternalCompilerError("Not available for override checking");
        }
        JifContext A = lc.context();
        A = (JifContext)A.pushBlock();
        JifTypeSystem ts = lc.typeSystem();
        final JifMethodInstance overridden = (JifMethodInstance)this.pi;
        final JifMethodInstance overriding = this.overridingMethod;
        if (overriding.formalTypes().size() != overridden.formalTypes().size()) {
            throw new InternalCompilerError("Different number of arguments!");
        }
        LabelChecker newlc = lc.context(A);
        LinkedHashSet newAuth = new LinkedHashSet();
        JifProcedureDeclExt_c.addCallers(overridden, newlc.context(), newAuth);
        A.setAuthority(this.instantiate(A, newAuth));
        JifProcedureDeclExt_c.constrainLabelEnv(overridden, newlc.context(), this);
        this.satisfiesConstraints(overriding, newlc, false);
        Iterator miargs = overriding.formalTypes().iterator();
        Iterator mjargs = overridden.formalTypes().iterator();
        int c = 0;
        while (miargs.hasNext() && mjargs.hasNext()) {
            Type i = (Type)miargs.next();
            Type j = (Type)mjargs.next();
            ArgLabel ai = (ArgLabel)ts.labelOfType(i);
            ArgLabel aj = (ArgLabel)ts.labelOfType(j);
            final int argIndex = ++c;
            newlc.constrain(new NamedLabel("sup_arg_" + argIndex, "label of " + StringUtil.nth((int)argIndex) + " arg of overridden method", this.instantiate(A, aj.upperBound())), LabelConstraint.LEQ, new NamedLabel("sub_arg_" + argIndex, "label of " + StringUtil.nth((int)argIndex) + " arg of overridding method", ai.upperBound()), A.labelEnv(), overriding.position(), new ConstraintMessage(){

                public String msg() {
                    return "Cannot override " + overridden.signature() + " in " + overridden.container() + " with " + overriding.signature() + " in " + overriding.container() + ". The label of the " + StringUtil.nth((int)argIndex) + " argument " + "of the overriding method cannot " + "be less restrictive than in " + "the overridden method.";
                }
            });
            new SubtypeChecker(ts.unlabel(i), this.instantiate(A, ts.unlabel(j))).addSubtypeConstraints(lc, overriding.position());
        }
        NamedLabel starti = new NamedLabel("sub_pc_bound", "PC bound of method " + overriding.name() + " in " + overriding.container(), overriding.pcBound());
        NamedLabel startj = new NamedLabel("sup_pc_bound", "PC bound of method " + overridden.name() + " in " + overridden.container(), this.instantiate(A, overridden.pcBound()));
        newlc.constrain(startj, LabelConstraint.LEQ, starti, A.labelEnv(), overriding.position(), new ConstraintMessage(){

            public String msg() {
                return "Cannot override " + overridden.signature() + " in " + overridden.container() + " with " + overriding.signature() + " in " + overriding.container() + ". The program counter bound of the " + "overriding method " + "cannot be less restrictive than in " + "the overridden method.";
            }

            public String detailMsg() {
                return this.msg() + " The program counter bound of a method is a lower " + "bound on the observable side effects that " + "the method may perform (such as updates to fields), and " + "an upper bound of the program counter label at the call site.";
            }
        });
        NamedLabel reti = new NamedLabel("sub_return_label", "return label of method " + overriding.name() + " in " + overriding.container(), overriding.returnLabel());
        NamedLabel retj = new NamedLabel("sup_return_label", "return label of method " + overridden.name() + " in " + overridden.container(), this.instantiate(A, overridden.returnLabel()));
        newlc.constrain(reti, LabelConstraint.LEQ, retj, A.labelEnv(), overriding.position(), new ConstraintMessage(){

            public String msg() {
                return "Cannot override " + overridden.signature() + " in " + overridden.container() + " with " + overriding.signature() + " in " + overriding.container() + ". The return label of the " + "overriding method " + "cannot be more restrictive than in " + "the overridden method.";
            }

            public String detailMsg() {
                return this.msg() + " The return label of a method is an upper " + "bound on the information that can be gained " + "by observing that the method terminates normally.";
            }
        });
        NamedLabel retVali = new NamedLabel("sub_return_val_label", "label of the return value of method " + overriding.name() + " in " + overriding.container(), overriding.returnValueLabel());
        NamedLabel retValj = new NamedLabel("sup_return_val_label", "label of the return value of method " + overridden.name() + " in " + overridden.container(), this.instantiate(A, overridden.returnValueLabel()));
        newlc.constrain(retVali, LabelConstraint.LEQ, retValj, A.labelEnv(), overriding.position(), new ConstraintMessage(){

            public String msg() {
                return "Cannot override " + overridden.signature() + " in " + overridden.container() + " with " + overriding.signature() + " in " + overriding.container() + ". The return value label of the " + "overriding method " + "cannot be more restrictive than in " + "the overridden method.";
            }

            public String detailMsg() {
                return this.msg() + " The return value label of a method is the " + "label of the value returned by the method.";
            }
        });
        Iterator miExc = overriding.throwTypes().iterator();
        List mjExc = overridden.throwTypes();
        while (miExc.hasNext()) {
            final LabeledType exi = (LabeledType)miExc.next();
            for (final LabeledType exj : mjExc) {
                if (!ts.isSubtype(exi.typePart(), exj.typePart())) continue;
                newlc.constrain(new NamedLabel("exc_label_" + exi.typePart().toString(), "", exi.labelPart()), LabelConstraint.LEQ, new NamedLabel("exc_label_" + exj.typePart().toString(), "", this.instantiate(A, exj.labelPart())), A.labelEnv(), overriding.position(), new ConstraintMessage(){

                    public String msg() {
                        return "Cannot override " + overridden.signature() + " in " + overridden.container() + " with " + overriding.signature() + " in " + overriding.container() + ". The label of the " + exi.typePart().toString() + " exception in overriding method " + "cannot be more restrictive " + "than the label of the " + exj.typePart().toString() + " exception in " + "the overridden method.";
                    }

                    public String detailMsg() {
                        return "Cannot override " + overridden.signature() + " in " + overridden.container() + " with " + overriding.signature() + " in " + overriding.container() + ". If the exception " + exi.typePart().toString() + " is thrown " + "by " + overriding.signature() + " in " + overriding.container() + " then more information " + "may be revealed than is permitted by " + "the overridden method throwing " + "the exception " + exj.typePart().toString() + ".";
                    }
                });
            }
        }
    }
}

