/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jif.ast.PolicyNode;
import jif.ast.PolicyNode_c;
import jif.ast.PrincipalNode;
import jif.types.JifTypeSystem;
import jif.types.label.Policy;
import jif.types.principal.Principal;
import polyglot.ast.Node;
import polyglot.types.SemanticException;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;

public class WriterPolicyNode_c
extends PolicyNode_c {
    protected List principals;

    public WriterPolicyNode_c(Position pos, PrincipalNode owner, List principals) {
        super(pos, owner);
        this.principals = TypedList.copyAndCheck((List)principals, PrincipalNode.class, (boolean)true);
    }

    public List principals() {
        return this.principals;
    }

    public PolicyNode principals(List principals) {
        WriterPolicyNode_c n = (WriterPolicyNode_c)this.copy();
        n.principals = TypedList.copyAndCheck((List)principals, PrincipalNode.class, (boolean)true);
        return n;
    }

    protected Policy producePolicy(JifTypeSystem ts, Principal owner, List principals) {
        return ts.writerPolicy(this.position(), owner, principals);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)ar.typeSystem();
        if (!this.owner.isDisambiguated()) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        Principal o = this.owner.principal();
        if (o == null) {
            throw new InternalCompilerError("null owner " + this.owner.getClass().getName() + " " + this.owner.position());
        }
        LinkedList<Principal> l = new LinkedList<Principal>();
        for (PrincipalNode r : this.principals) {
            if (!r.isDisambiguated()) {
                ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
                return this;
            }
            l.add(r.principal());
        }
        this.policy = this.producePolicy(ts, o, l);
        return this;
    }

    protected WriterPolicyNode_c reconstruct(PrincipalNode owner, List principals) {
        if (owner != this.owner || !CollectionUtil.equals((Collection)principals, (Collection)this.principals)) {
            WriterPolicyNode_c n = (WriterPolicyNode_c)this.copy();
            n.owner = owner;
            n.principals = TypedList.copyAndCheck((List)principals, PrincipalNode.class, (boolean)true);
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        PrincipalNode owner = (PrincipalNode)this.visitChild(this.owner, v);
        List readers = this.visitList(this.principals, v);
        return this.reconstruct(owner, readers);
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        this.print(this.owner, w, tr);
        w.write("<-");
        Iterator i = this.principals.iterator();
        while (i.hasNext()) {
            PrincipalNode n = (PrincipalNode)i.next();
            this.print(n, w, tr);
            if (!i.hasNext()) continue;
            w.write(";");
            w.allowBreak(0, " ");
        }
    }
}

