/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import jif.ast.ParamDecl;
import jif.types.JifPolyType;
import jif.types.JifTypeSystem;
import jif.types.ParamInstance;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.types.Context;
import polyglot.types.SemanticException;
import polyglot.types.VarInstance;
import polyglot.util.CodeWriter;
import polyglot.util.Position;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;

public class ParamDecl_c
extends Node_c
implements ParamDecl {
    ParamInstance pi;
    Id name;
    ParamInstance.Kind kind;

    public ParamDecl_c(Position pos, ParamInstance.Kind kind, Id name) {
        super(pos);
        this.kind = kind;
        this.name = name;
    }

    public boolean isDisambiguated() {
        return this.pi != null && this.pi.isCanonical() && super.isDisambiguated();
    }

    public ParamInstance.Kind kind() {
        return this.kind;
    }

    public ParamDecl kind(ParamInstance.Kind kind) {
        ParamDecl_c n = (ParamDecl_c)this.copy();
        n.kind = kind;
        return n;
    }

    public String name() {
        return this.name.id();
    }

    public ParamDecl name(String name) {
        ParamDecl_c n = (ParamDecl_c)this.copy();
        n.name = n.name.id(name);
        return n;
    }

    public ParamInstance paramInstance() {
        return this.pi;
    }

    public ParamDecl paramInstance(ParamInstance pi) {
        ParamDecl_c n = (ParamDecl_c)this.copy();
        n.pi = pi;
        return n;
    }

    public boolean isPrincipal() {
        return this.kind == ParamInstance.PRINCIPAL;
    }

    public boolean isLabel() {
        return this.kind == ParamInstance.INVARIANT_LABEL || this.kind == ParamInstance.COVARIANT_LABEL;
    }

    public boolean isInvariantLabel() {
        return this.kind == ParamInstance.INVARIANT_LABEL;
    }

    public boolean isCovariantLabel() {
        return this.kind == ParamInstance.COVARIANT_LABEL;
    }

    public void leaveScope(Context c) {
        c.addVariable((VarInstance)this.pi);
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)tb.typeSystem();
        JifPolyType ct = (JifPolyType)tb.currentClass();
        ParamInstance pi = ts.paramInstance(this.position(), ct, this.kind, this.name.id());
        return this.paramInstance(pi);
    }

    public String toString() {
        return this.kind.toString();
    }

    public void prettyPrint(CodeWriter w, PrettyPrinter tr) {
        if (this.kind == ParamInstance.COVARIANT_LABEL) {
            w.write("covariant label ");
        } else if (this.kind == ParamInstance.INVARIANT_LABEL) {
            w.write("label ");
        } else if (this.kind == ParamInstance.PRINCIPAL) {
            w.write("principal ");
        }
        w.write(this.name.id());
    }

    public void translate(CodeWriter w, Translator tr) {
    }
}

