/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import jif.ast.DowngradeExpr;
import jif.ast.Jif;
import jif.ast.LabelExpr;
import jif.ast.PrincipalExpr;
import jif.ast.PrincipalNode;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.PathMap;
import jif.types.SemanticDetailedException;
import jif.types.label.AccessPath;
import jif.types.label.AccessPathClass;
import jif.types.label.AccessPathConstant;
import jif.types.label.AccessPathField;
import jif.types.label.AccessPathLocal;
import jif.types.label.AccessPathRoot;
import jif.types.label.AccessPathThis;
import jif.types.label.Label;
import jif.types.principal.BottomPrincipal;
import jif.types.principal.Principal;
import polyglot.ast.Cast;
import polyglot.ast.Expr;
import polyglot.ast.Ext;
import polyglot.ast.Field;
import polyglot.ast.Local;
import polyglot.ast.Node;
import polyglot.ast.NullLit;
import polyglot.ast.Receiver;
import polyglot.ast.Special;
import polyglot.ast.TypeNode;
import polyglot.types.FieldInstance;
import polyglot.types.Flags;
import polyglot.types.LocalInstance;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.VarInstance;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;

public class JifUtil {
    public static PathMap getPathMap(Node n) {
        Jif ext = JifUtil.jifExt(n);
        return ext.X();
    }

    public static Jif jifExt(Node n) {
        Ext ext;
        for (ext = n.ext(); ext != null && !(ext instanceof Jif); ext = ext.ext()) {
        }
        return (Jif)ext;
    }

    public static Node updatePathMap(Node n, PathMap X) {
        Jif ext = JifUtil.jifExt(n);
        return JifUtil.updateJifExt(n, ext.X(X));
    }

    private static Node updateJifExt(Node n, Jif jif) {
        return n.ext(JifUtil.updateJifExt(n.ext(), jif));
    }

    private static Ext updateJifExt(Ext e, Jif jif) {
        if (e instanceof Jif) {
            return jif;
        }
        if (e == null) {
            return e;
        }
        return e.ext(JifUtil.updateJifExt(e.ext(), jif));
    }

    public static AccessPath varInstanceToAccessPath(VarInstance vi, Position pos) throws SemanticException {
        return JifUtil.varInstanceToAccessPath(vi, vi.name(), pos);
    }

    public static AccessPath varInstanceToAccessPath(VarInstance vi, String name, Position pos) throws SemanticException {
        if (!vi.flags().isFinal()) {
            throw new SemanticException("Only final fields and final local variables may be used as access paths.", pos);
        }
        if (vi instanceof LocalInstance) {
            return new AccessPathLocal((LocalInstance)vi, name, pos);
        }
        if (vi instanceof FieldInstance) {
            FieldInstance fi = (FieldInstance)vi;
            AccessPathRoot root = fi.flags().isStatic() ? new AccessPathClass(fi.container().toClass(), pos) : new AccessPathThis(fi.container().toClass(), pos);
            return new AccessPathField(root, fi, name, pos);
        }
        throw new InternalCompilerError("Unexpected var instance " + vi.getClass());
    }

    public static AccessPath exprToAccessPath(Expr e, JifContext context) throws SemanticException {
        Type expectedType = null;
        if (e != null && e.type() != null && !e.type().isNull()) {
            expectedType = e.type();
        }
        return JifUtil.exprToAccessPath(e, expectedType, context);
    }

    public static AccessPath exprToAccessPath(Expr e, Type expectedType, JifContext context) throws SemanticException {
        if (e instanceof Local) {
            Local l = (Local)e;
            return new AccessPathLocal(l.localInstance(), l.name(), e.position());
        }
        if (e instanceof Field) {
            Field f = (Field)e;
            Receiver target = f.target();
            if (target instanceof Expr) {
                AccessPath prefix = JifUtil.exprToAccessPath((Expr)f.target(), null, context);
                return new AccessPathField(prefix, f.fieldInstance(), f.name(), f.position());
            }
            if (target instanceof TypeNode && ((TypeNode)target).type().isClass()) {
                AccessPathClass prefix = new AccessPathClass(((TypeNode)target).type().toClass(), target.position());
                return new AccessPathField(prefix, f.fieldInstance(), f.name(), f.position());
            }
            throw new InternalCompilerError("Not currently supporting access paths for targets of " + target.getClass());
        }
        if (e instanceof Special) {
            Special s = (Special)e;
            if (Special.THIS.equals((Object)s.kind())) {
                if (context.currentClass() == null || context.inStaticContext()) {
                    throw new SemanticException("Cannot use \"this\" in this scope.", e.position());
                }
                return new AccessPathThis(context.currentClass(), s.position());
            }
            throw new InternalCompilerError("Not currently supporting access paths for special of kind " + s.kind());
        }
        if (e instanceof LabelExpr) {
            LabelExpr le = (LabelExpr)e;
            return new AccessPathConstant(le.label().label(), le.type(), le.position());
        }
        if (e instanceof PrincipalNode) {
            PrincipalNode pn = (PrincipalNode)e;
            return new AccessPathConstant(pn.principal(), pn.type(), pn.position());
        }
        if (e instanceof NullLit && expectedType != null && context.typeSystem().isImplicitCastValid(expectedType, (Type)((JifTypeSystem)context.typeSystem()).Principal())) {
            JifTypeSystem ts = (JifTypeSystem)context.typeSystem();
            BottomPrincipal bot = ts.bottomPrincipal(e.position());
            return new AccessPathConstant(bot, (Type)ts.Principal(), e.position());
        }
        if (e instanceof Cast) {
            return JifUtil.exprToAccessPath(((Cast)e).expr(), expectedType, context);
        }
        if (e instanceof DowngradeExpr) {
            return JifUtil.exprToAccessPath(((DowngradeExpr)e).expr(), expectedType, context);
        }
        throw new SemanticDetailedException("Expression " + e + " not suitable for an access path.", "The expression " + e + " is not suitable for a final access " + "path. A final access path is an expression starting with either " + "\"this\" or a final local variable \"v\", followed by zero or more final field accesses. That is, " + "a final access path is either this.f1.f2....fn, or v.f1.f2.....fn, where v is a " + "final local variables, and each field f1 to fn is a final field.", e.position());
    }

    private static boolean isFinalAccessExpr(JifTypeSystem ts, Expr e) {
        if (e instanceof Local) {
            Local l = (Local)e;
            if (l.type() != null && l.type().isCanonical()) {
                return l.localInstance().flags().isFinal();
            }
            return true;
        }
        if (e instanceof Field) {
            Field f = (Field)e;
            if (f.type() != null && f.type().isCanonical()) {
                Flags flgs = f.flags();
                return flgs.isFinal() && (flgs.isStatic() || f.target() instanceof Expr && JifUtil.isFinalAccessExpr(ts, (Expr)f.target()));
            }
            return true;
        }
        if (e instanceof Special) {
            return ((Special)e).kind() == Special.THIS;
        }
        if (e instanceof Cast) {
            return JifUtil.isFinalAccessExpr(ts, ((Cast)e).expr());
        }
        if (e instanceof DowngradeExpr) {
            return JifUtil.isFinalAccessExpr(ts, ((DowngradeExpr)e).expr());
        }
        return false;
    }

    public static boolean isFinalAccessExprOrConst(JifTypeSystem ts, Expr e) {
        Type expectedType = null;
        if (e != null && e.type() != null && !e.type().isNull()) {
            expectedType = e.type();
        }
        return JifUtil.isFinalAccessExprOrConst(ts, e, expectedType);
    }

    public static boolean isFinalAccessExprOrConst(JifTypeSystem ts, Expr e, Type expectedType) {
        return JifUtil.isFinalAccessExpr(ts, e) || e instanceof LabelExpr || e instanceof PrincipalNode || e instanceof Cast && JifUtil.isFinalAccessExprOrConst(ts, ((Cast)e).expr()) || e instanceof DowngradeExpr && JifUtil.isFinalAccessExprOrConst(ts, ((DowngradeExpr)e).expr()) || e instanceof NullLit && expectedType != null && ts.isImplicitCastValid(expectedType, (Type)ts.Principal());
    }

    public static Label exprToLabel(JifTypeSystem ts, Expr e, JifContext context) throws SemanticException {
        if (e instanceof LabelExpr) {
            return ((LabelExpr)e).label().label();
        }
        if (e instanceof DowngradeExpr) {
            return JifUtil.exprToLabel(ts, ((DowngradeExpr)e).expr(), context);
        }
        if (JifUtil.isFinalAccessExpr(ts, e)) {
            return ts.dynamicLabel(e.position(), JifUtil.exprToAccessPath(e, (Type)ts.Label(), context));
        }
        throw new InternalCompilerError("Expected a final access expression, or constant");
    }

    public static Principal exprToPrincipal(JifTypeSystem ts, Expr e, JifContext context) throws SemanticException {
        if (e instanceof PrincipalNode) {
            return ((PrincipalNode)e).principal();
        }
        if (e instanceof PrincipalExpr) {
            return ((PrincipalExpr)e).principal().principal();
        }
        if (e instanceof Cast) {
            return JifUtil.exprToPrincipal(ts, ((Cast)e).expr(), context);
        }
        if (e instanceof DowngradeExpr) {
            return JifUtil.exprToPrincipal(ts, ((DowngradeExpr)e).expr(), context);
        }
        if (e instanceof NullLit) {
            return ts.bottomPrincipal(e.position());
        }
        if (JifUtil.isFinalAccessExpr(ts, e)) {
            return ts.dynamicPrincipal(e.position(), JifUtil.exprToAccessPath(e, (Type)ts.Principal(), context));
        }
        throw new InternalCompilerError("Expected a final access expression, or constant");
    }

    public static String accessPathDescrip(AccessPath path, String kind) {
        if (path.isUninterpreted()) {
            return "an uninterpreted dynamic " + kind;
        }
        return "dynamic " + kind + " represented by the final access path " + path;
    }

    public static Expr effectiveExpr(Expr expr) {
        if (expr instanceof Cast) {
            return JifUtil.effectiveExpr(((Cast)expr).expr());
        }
        if (expr instanceof DowngradeExpr) {
            return JifUtil.effectiveExpr(((DowngradeExpr)expr).expr());
        }
        return expr;
    }
}

