/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import jif.ast.JifClassDecl;
import jif.ast.ParamDecl;
import jif.ast.PrincipalNode;
import jif.types.JifContext;
import jif.types.JifParsedPolyType;
import jif.types.JifTypeSystem;
import jif.types.ParamInstance;
import jif.types.label.AccessPathThis;
import jif.types.principal.DynamicPrincipal;
import jif.types.principal.Principal;
import polyglot.ast.ClassBody;
import polyglot.ast.ClassDecl_c;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.TypeNode;
import polyglot.ext.param.types.MuPClass;
import polyglot.ext.param.types.PClass;
import polyglot.types.ClassType;
import polyglot.types.Context;
import polyglot.types.Flags;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.CodeWriter;
import polyglot.util.CollectionUtil;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.util.TypedList;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.PrettyPrinter;
import polyglot.visit.Translator;
import polyglot.visit.TypeBuilder;

public class JifClassDecl_c
extends ClassDecl_c
implements JifClassDecl {
    protected List params;
    protected List authority;

    public JifClassDecl_c(Position pos, Flags flags, Id name, List params, TypeNode superClass, List interfaces, List authority, ClassBody body) {
        super(pos, flags, name, superClass, interfaces, body);
        this.params = TypedList.copyAndCheck((List)params, ParamDecl.class, (boolean)true);
        this.authority = TypedList.copyAndCheck((List)authority, PrincipalNode.class, (boolean)true);
    }

    public List params() {
        return this.params;
    }

    public JifClassDecl params(List params) {
        JifClassDecl_c n = (JifClassDecl_c)this.copy();
        n.params = TypedList.copyAndCheck((List)params, ParamDecl.class, (boolean)true);
        return n;
    }

    public List authority() {
        return this.authority;
    }

    public JifClassDecl authority(List authority) {
        JifClassDecl_c n = (JifClassDecl_c)this.copy();
        n.authority = TypedList.copyAndCheck((List)authority, PrincipalNode.class, (boolean)true);
        return n;
    }

    protected JifClassDecl_c reconstruct(Id name, List params, TypeNode superClass, List interfaces, List authority, ClassBody body) {
        if (!CollectionUtil.equals((Collection)params, (Collection)this.params) || !CollectionUtil.equals((Collection)authority, (Collection)this.authority)) {
            JifClassDecl_c n = (JifClassDecl_c)this.copy();
            n.params = TypedList.copyAndCheck((List)params, ParamDecl.class, (boolean)true);
            n.authority = TypedList.copyAndCheck((List)authority, PrincipalNode.class, (boolean)true);
            return (JifClassDecl_c)n.reconstruct(name, superClass, interfaces, body);
        }
        return (JifClassDecl_c)super.reconstruct(name, superClass, interfaces, body);
    }

    public Node visitChildren(NodeVisitor v) {
        Id name = (Id)this.visitChild((Node)this.name, v);
        List params = this.visitList(this.params, v);
        TypeNode superClass = (TypeNode)this.visitChild((Node)this.superClass, v);
        List interfaces = this.visitList(this.interfaces, v);
        List authority = this.visitList(this.authority, v);
        ClassBody body = (ClassBody)this.visitChild((Node)this.body, v);
        return this.reconstruct(name, params, superClass, interfaces, authority, body);
    }

    public Context enterScope(Context c) {
        JifContext A = (JifContext)c;
        return this.addParamsToContext(A);
    }

    public Context enterChildScope(Node child, Context c) {
        if (child == this.body) {
            JifParsedPolyType ct;
            JifContext A = (JifContext)c;
            JifParsedPolyType inst = ct = (JifParsedPolyType)this.type;
            A = (JifContext)A.pushClass(ct, inst);
            return this.addAuthorityToContext(A);
        }
        return super.enterChildScope(child, c);
    }

    public JifContext addParamsToContext(JifContext A) {
        JifParsedPolyType ct = (JifParsedPolyType)this.type;
        A = (JifContext)A.pushBlock();
        for (ParamInstance pi : ct.params()) {
            A.addVariable(pi);
        }
        return A;
    }

    public JifContext addAuthorityToContext(JifContext A) {
        JifTypeSystem ts = (JifTypeSystem)A.typeSystem();
        JifParsedPolyType ct = (JifParsedPolyType)this.type;
        LinkedHashSet<DynamicPrincipal> s = new LinkedHashSet<DynamicPrincipal>(ct.authority());
        if (ts.isSubtype((Type)ct, ts.PrincipalClass())) {
            s.add(ts.dynamicPrincipal(ct.position(), new AccessPathThis(ct, ct.position())));
        }
        A.setAuthority(s);
        return A;
    }

    public Node buildTypes(TypeBuilder tb) throws SemanticException {
        JifClassDecl_c n = (JifClassDecl_c)super.buildTypes(tb);
        n.buildParams((JifTypeSystem)tb.typeSystem());
        return n;
    }

    private void buildParams(JifTypeSystem ts) throws SemanticException {
        JifParsedPolyType ct = (JifParsedPolyType)this.type;
        if (ct == null) {
            return;
        }
        MuPClass pc = ts.mutablePClass(ct.position());
        ct.setInstantiatedFrom((PClass)pc);
        pc.clazz((ClassType)ct);
        LinkedHashSet<String> names = new LinkedHashSet<String>(this.params.size());
        ArrayList<ParamInstance> newParams = new ArrayList<ParamInstance>(this.params.size());
        for (ParamDecl p : this.params) {
            newParams.add(p.paramInstance());
            if (names.contains(p.name())) {
                throw new SemanticException("Redefined Parameter Error.", p.position());
            }
            names.add(p.name());
        }
        ct.setParams(newParams);
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        JifClassDecl_c n = (JifClassDecl_c)super.disambiguate(ar);
        JifParsedPolyType ct = (JifParsedPolyType)n.type;
        ArrayList<Principal> principals = new ArrayList<Principal>(n.authority().size());
        for (PrincipalNode p : n.authority()) {
            principals.add(p.principal());
        }
        ct.setAuthority(principals);
        return n;
    }

    public JifClassDecl type(Type type) {
        JifClassDecl_c n = (JifClassDecl_c)this.copy();
        n.type = (ParsedClassType)type;
        return n;
    }

    public void prettyPrintHeader(CodeWriter w, PrettyPrinter tr) {
        Object p;
        Iterator i;
        if (this.flags.isInterface()) {
            w.write(this.flags.clearInterface().clearAbstract().translate());
            w.write("interface ");
        } else {
            w.write(this.flags.translate());
            w.write("class ");
        }
        w.write(this.name.id());
        if (!this.params.isEmpty()) {
            w.write("[");
            i = this.params.iterator();
            while (i.hasNext()) {
                p = (ParamDecl)i.next();
                this.print((Node)p, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.write("]");
        }
        if (!this.authority.isEmpty()) {
            w.write(" authority(");
            i = this.authority.iterator();
            while (i.hasNext()) {
                p = (PrincipalNode)i.next();
                this.print((Node)p, w, tr);
                if (!i.hasNext()) continue;
                w.write(",");
                w.allowBreak(0, " ");
            }
            w.write(")");
        }
        if (this.superClass() != null) {
            w.write(" extends ");
            this.print((Node)this.superClass(), w, tr);
        }
        if (!this.interfaces.isEmpty()) {
            if (this.flags.isInterface()) {
                w.write(" extends ");
            } else {
                w.write(" implements ");
            }
            i = this.interfaces().iterator();
            while (i.hasNext()) {
                TypeNode tn = (TypeNode)i.next();
                this.print((Node)tn, w, tr);
                if (!i.hasNext()) continue;
                w.write(", ");
            }
        }
        w.write(" {");
    }

    public void translate(CodeWriter w, Translator tr) {
        throw new InternalCompilerError("cannot translate " + this);
    }
}

