/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.Collections;
import java.util.Set;
import jif.ast.ConstraintNode;
import jif.types.Assertion;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.types.SemanticException;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.ExceptionChecker;
import polyglot.visit.NodeVisitor;

public class ConstraintNode_c
extends Node_c
implements ConstraintNode {
    protected Set constraints;

    public ConstraintNode_c(Position pos) {
        super(pos);
    }

    public boolean isDisambiguated() {
        if (this.constraints == null) {
            return false;
        }
        for (Assertion a : this.constraints) {
            if (a.isCanonical()) continue;
            return false;
        }
        return super.isDisambiguated();
    }

    public Set constraints() {
        return this.constraints;
    }

    public ConstraintNode constraints(Set constraints) {
        ConstraintNode_c n = (ConstraintNode_c)this.copy();
        n.constraints = constraints;
        return n;
    }

    protected Assertion constraint() {
        if (this.constraints == null) {
            return null;
        }
        if (this.constraints.size() > 1) {
            throw new InternalCompilerError("Multiple constraints");
        }
        return (Assertion)this.constraints.iterator().next();
    }

    protected ConstraintNode constraint(Assertion constraint) {
        ConstraintNode_c n = (ConstraintNode_c)this.copy();
        n.constraints = Collections.singleton(constraint);
        return n;
    }

    protected void setConstraint(Assertion constraint) {
        this.constraints = Collections.singleton(constraint);
    }

    public NodeVisitor exceptionCheckEnter(ExceptionChecker ec) throws SemanticException {
        ec = (ExceptionChecker)super.exceptionCheckEnter(ec);
        return ec.bypassChildren((Node)this);
    }

    public String toString() {
        if (this.constraints != null) {
            return this.constraints.toString();
        }
        return "<unknown-constraint>";
    }
}

