/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import java.util.LinkedList;
import jif.ast.AmbParamTypeOrAccess;
import jif.ast.JifNodeFactory;
import jif.ast.ParamNode;
import jif.types.JifPolyType;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.ParamInstance;
import polyglot.ast.Expr;
import polyglot.ast.Id;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.ast.Receiver;
import polyglot.ast.TypeNode;
import polyglot.types.ClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;

public class AmbParamTypeOrAccess_c
extends Node_c
implements AmbParamTypeOrAccess {
    protected Receiver prefix;
    protected Object expr;
    protected Type type;

    public AmbParamTypeOrAccess_c(Position pos, Receiver prefix, Object expr) {
        super(pos);
        this.prefix = prefix;
        this.expr = expr;
    }

    public boolean isDisambiguated() {
        return false;
    }

    public Receiver prefix() {
        return this.prefix;
    }

    public AmbParamTypeOrAccess prefix(Receiver prefix) {
        AmbParamTypeOrAccess_c n = (AmbParamTypeOrAccess_c)this.copy();
        n.prefix = prefix;
        return n;
    }

    public Object expr() {
        return this.expr;
    }

    public Type type() {
        return this.type;
    }

    protected AmbParamTypeOrAccess_c reconstruct(Receiver prefix, Object expr) {
        if (prefix != this.prefix || expr != this.expr) {
            AmbParamTypeOrAccess_c n = (AmbParamTypeOrAccess_c)this.copy();
            n.prefix = prefix;
            n.expr = expr;
            return n;
        }
        return this;
    }

    public Node visitChildren(NodeVisitor v) {
        Receiver prefix = (Receiver)this.visitChild((Node)this.prefix, v);
        Object expr = this.expr;
        if (expr instanceof Expr) {
            expr = this.visitChild((Node)((Expr)expr), v);
        }
        return this.reconstruct(prefix, expr);
    }

    public String toString() {
        return this.prefix + "[" + this.expr + "]{amb}";
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        JifTypeSystem ts = (JifTypeSystem)ar.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)ar.nodeFactory();
        if (!ar.isASTDisambiguated((Node)this.prefix) || this.expr instanceof Expr && !ar.isASTDisambiguated((Node)((Expr)this.expr))) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        if (this.prefix instanceof TypeNode) {
            ParamNode n;
            TypeNode tn = (TypeNode)this.prefix;
            if (!(tn.type() instanceof JifPolyType)) {
                throw new SemanticException(tn.type() + " is not a parameterized type.", this.position());
            }
            JifPolyType pt = (JifPolyType)tn.type();
            if (pt.params().isEmpty()) {
                throw new SemanticException(tn.type() + " is not a parameterized type.", this.position());
            }
            ParamInstance pi = (ParamInstance)pt.params().get(0);
            if (this.expr instanceof Expr) {
                n = nf.AmbParam(this.position(), (Expr)this.expr, pi);
                n = (ParamNode)n.del().disambiguate(ar);
            } else {
                n = nf.AmbParam(this.position(), (Id)this.expr, pi);
                if (!(n = (ParamNode)n.del().disambiguate(ar)).isDisambiguated()) {
                    throw new SemanticException("\"" + this.expr + "\" is not " + "suitable as a parameter.", this.position());
                }
            }
            LinkedList<Param> l = new LinkedList<Param>();
            l.add(n.parameter());
            ClassType t = ts.instantiate(this.position(), pt.instantiatedFrom(), l);
            return nf.CanonicalTypeNode(this.position(), (Type)t);
        }
        if (this.prefix instanceof Expr) {
            Expr n;
            if (this.expr instanceof Expr) {
                n = (Expr)this.expr;
            } else {
                n = nf.AmbExpr(this.position(), (Id)this.expr);
                n = (Expr)n.visit((NodeVisitor)ar);
            }
            return nf.ArrayAccess(this.position(), (Expr)this.prefix, n);
        }
        throw new SemanticException("Could not disambiguate type or expression.", this.position());
    }
}

