/*
 * Decompiled with CFR 0.152.
 */
package jif.ast;

import jif.ast.AmbExprParam;
import jif.ast.AmbParam;
import jif.ast.JifNodeFactory;
import jif.ast.JifUtil;
import jif.ast.PrincipalNode;
import jif.types.JifContext;
import jif.types.JifTypeSystem;
import jif.types.Param;
import jif.types.ParamInstance;
import jif.types.SemanticDetailedException;
import jif.visit.JifTypeChecker;
import polyglot.ast.Expr;
import polyglot.ast.Field;
import polyglot.ast.Node;
import polyglot.ast.Node_c;
import polyglot.frontend.MissingDependencyException;
import polyglot.frontend.Scheduler;
import polyglot.frontend.goals.Goal;
import polyglot.types.ParsedClassType;
import polyglot.types.SemanticException;
import polyglot.types.Type;
import polyglot.types.TypeSystem;
import polyglot.util.InternalCompilerError;
import polyglot.util.Position;
import polyglot.visit.AmbiguityRemover;
import polyglot.visit.NodeVisitor;
import polyglot.visit.TypeChecker;

public class AmbExprParam_c
extends Node_c
implements AmbExprParam {
    protected Expr expr;
    protected ParamInstance expectedPI;

    public AmbExprParam_c(Position pos, Expr expr, ParamInstance expectedPI) {
        super(pos);
        this.expr = expr;
        this.expectedPI = expectedPI;
    }

    public boolean isDisambiguated() {
        return false;
    }

    public Expr expr() {
        return this.expr;
    }

    public AmbParam expr(Expr expr) {
        AmbExprParam_c n = (AmbExprParam_c)this.copy();
        n.expr = expr;
        return n;
    }

    public AmbParam expectedPI(ParamInstance expectedPI) {
        AmbExprParam_c n = (AmbExprParam_c)this.copy();
        n.expectedPI = expectedPI;
        return n;
    }

    public Param parameter() {
        throw new InternalCompilerError("No parameter yet");
    }

    public String toString() {
        return this.expr + "{amb}";
    }

    public Node visitChildren(NodeVisitor v) {
        Expr expr = (Expr)this.visitChild((Node)this.expr, v);
        return this.reconstruct(expr, this.expectedPI);
    }

    protected AmbExprParam_c reconstruct(Expr expr, ParamInstance expectedPI) {
        if (this.expr == expr && this.expectedPI == expectedPI) {
            return this;
        }
        AmbExprParam_c n = (AmbExprParam_c)this.copy();
        n.expr = expr;
        n.expectedPI = expectedPI;
        return n;
    }

    public Node disambiguate(AmbiguityRemover ar) throws SemanticException {
        if (!ar.isASTDisambiguated((Node)this.expr)) {
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        JifContext c = (JifContext)ar.context();
        JifTypeSystem ts = (JifTypeSystem)ar.typeSystem();
        JifNodeFactory nf = (JifNodeFactory)ar.nodeFactory();
        JifTypeChecker tc = new JifTypeChecker(ar.job(), (TypeSystem)ts, nf);
        tc = (TypeChecker)tc.context(ar.context());
        this.expr = (Expr)this.expr.visit((NodeVisitor)tc);
        if (!this.expr.isTypeChecked()) {
            Field f;
            if (this.expr instanceof Field && ts.unlabel((f = (Field)this.expr).target().type()) instanceof ParsedClassType) {
                ParsedClassType pct = (ParsedClassType)ts.unlabel(f.target().type());
                Scheduler sched = ar.job().extensionInfo().scheduler();
                Goal g = sched.Disambiguated(pct.job());
                throw new MissingDependencyException(g);
            }
            ar.job().extensionInfo().scheduler().currentGoal().setUnreachableThisRun();
            return this;
        }
        if (this.expr instanceof PrincipalNode || ts.isImplicitCastValid(this.expr.type(), (Type)ts.Principal()) || this.expectedPI != null && this.expectedPI.isPrincipal()) {
            if (!JifUtil.isFinalAccessExprOrConst(ts, this.expr, (Type)ts.Principal())) {
                throw new SemanticDetailedException("Illegal principal parameter.", "The expression " + this.expr + " is not suitable as a " + "principal parameter. Principal parameters can be either " + "dynamic principals, or principal expressions, such as a " + "principal parameter, or an external principal.", this.position());
            }
            return nf.CanonicalPrincipalNode(this.position(), JifUtil.exprToPrincipal(ts, this.expr, c));
        }
        if (!JifUtil.isFinalAccessExprOrConst(ts, this.expr, (Type)ts.Label())) {
            throw new SemanticDetailedException("Illegal label parameter.", "The expression " + this.expr + " is not suitable as a " + "label parameter. Label parameters can be either " + "dynamic labels, or label expressions.", this.position());
        }
        return nf.CanonicalLabelNode(this.position(), JifUtil.exprToLabel(ts, this.expr, c));
    }
}

